package mChaRM.mChaRMCollection;

import mChaRM.multichannel.*;
import uka.karmi.rmi.*;

  /**
   * realizes the sender stubs of a multi-channel of kind <I>verbose</I>. 
   * Its meta-behavior consists in tracing the trapped calls printing the information related them, at the moment they are trapped on the sender side.
   * @author  Walter Cazzola (<A HREF="mailto:cazzola@disi.unige.it">cazzola@disi.unige.it</A>)
   * @version 1.1
   * @since Version 1.0
   **/
public class verboseSenderStub extends senderStub {
    /**
     * constructor for the stubs. Its ancestor constructor is entrusted of all the work.
     * <HR>
     * @param myReferent a representant of the stub referent.
     * @param myKind the multi-channel's name.
     * @param myReferentName the referent's name.
     * @exception SenderStubCannotBeRegisteredAsAServerException thrown when the stub cannot be registered as a server.
     * @exception SenderStubNotFoundException thrown when the core can't link to the this sender stub.
     * @exception CoreNotFoundException thrown when the core of the multi-channel, which the stub is part of,
     *            doesn't exist or isn't correctly registered as a server. 
     **/
  public verboseSenderStub(Object myReferent, String myKind, String myReferentName) 
         throws RemoteException, SenderStubCannotBeRegisteredAsAServerException, SenderStubNotFoundException, CoreNotFoundException {
    super(myReferent, myKind, myReferentName);
  }  
  
   /** This method performs the sender side meta-behavior for a multi-channel of kind <I>verbose</I>.
    * <HR>
    * It is called before passing all the staff to the core and it permits to perform meta-computations on sender side.
    * It prints a message related the trapped call.
    * <HR>
    * @param msg a reification of the trapped message.
    **/
  public void beforeSenderSideMetaBehavior(mChaRMMethodCall msg) {
    try {
      System.out.print("*** I'm in the source locus of ["+(java.lang.String)retrieveField("whoAmI")+"],\n*** I'm working for "+msg.getMethodName()+"( ");
    } catch (FieldDoesNotExistException e) {
      System.err.println("*** Troubles Field 'whoAmI' Does Not Exist"); 
      e.printStackTrace();
    }
    if (msg.hasArgs())
      for(int i=0;i<(msg.actualArguments()).length;i++) System.out.print((msg.actualArguments())[i]+" ");
    System.out.print(")\n*** when I exit I'll forward the call to: "+(msg.receivers())[0]);
    for(int i=1;i<(msg.receivers()).length;i++) System.out.print(", "+(msg.receivers())[i]);
    System.out.println(".");
  }
  
   /** This method performs the sender side meta-behavior for a multi-channel of kind <I>verbose</I>.
    * <HR>
    * It is called after that the computation passed through the abstract locus.
    * It prints a message related to the returned message.
    * <HR>
    * @param msg a reification of the trapped message.
    **/
  public void afterSenderSideMetaBehavior(mChaRMMethodCall msg) {
    try {
      System.out.print("*** I'm again in the source locus of ["+(java.lang.String)retrieveField("whoAmI")+"],\n*** The call "+msg.getMethodName()+"( ");
    } catch (FieldDoesNotExistException e) {
      System.err.println("*** Troubles Field 'whoAmI' Does Not Exist"); 
      e.printStackTrace();
    }
    if (msg.hasArgs())
      for(int i=0;i<(msg.actualArguments()).length;i++) System.out.print((msg.actualArguments())[i]+" ");
    System.out.print(") gives the following answer: "+(msg.getReturnValue()));
    System.out.println(".");
  }
}


