package mChaRM.mChaRMCollection;

import mChaRM.multichannel.*;
import uka.karmi.rmi.*;

  /**
   * realizes a multi-channel of kind <I>verbose</I>. Its meta-behavior consists in printing messages stressing 
   * the flow of trapped calls through the multi-channel components.
   * It uses instances of {@link verboseSenderStub verboseSenderStub} class as senderStubs, 
   * and instances of {@link verboseReceiverStub verboseReceiverStub} as receiverStubs
   * @author  Walter Cazzola (<A HREF="mailto:cazzola@disi.unige.it">cazzola@disi.unige.it</A>)
   * @version 1.1
   * @since Version 1.0
   **/
public class verboseChannel extends channelCore implements channelInterface {
    /** 
     * constructor of multi-channels of kind verbose.
     * <HR>
     * It calls the {@link mChaRM.multichannel.channelCore#channelCore channelCore} constructor with kind verbose 
     * and as classes for sender and receiver stubs their verbose version.
     * <HR>
     * @param RsName an Array of Strings representing the name of the receivers, which it is connected to.
     * @exception ReceiverStubNotFoundException thrown when one of the specified receiver wasn't started before the core.
     **/
  public verboseChannel(String[] RsName) throws RemoteException, ReceiverStubNotFoundException {
    super("verbose", RsName, "mChaRM.mChaRMCollection.verboseSenderStub", "mChaRM.mChaRMCollection.verboseReceiverStub");
  }
   
  public verboseChannel(String kind, String[] RsName, String SSClassName, String RSClassName) throws RemoteException, ReceiverStubNotFoundException {
    super(kind, RsName, SSClassName, RSClassName);
  }

   /** This method embodies the reflective behaviour realized by the multi-channel.
    * <HR>
    * Its behavior consists in printing information about the call trapped and then applies the 
    # {@link mChaRM.multichannel.channelCore#coreMetaBehavior coreMetaBehavior} of its ancestor.
    * <HR>
    * @param RsName the name of the receivers who the message have to be delivered to.
    * @param methodName the name of the method whose execution is requested.
    * @param args the actual arguments of the call.
    * @return the result of the method call.
    * @exception MethodDoesNotExistException thrown when the method reified doesn't exist in the referent class.
    **/

  public Object coreMetaBehavior(mChaRMMethodCall msg) throws MethodDoesNotExistException, RemoteException {
    System.out.print("*** ");
    msg.printmChaRMMethodCall();
    return super.coreMetaBehavior(msg);
  }
}

