package mChaRM.mChaRMCollection;

import uka.karmi.rmi.*;
import java.net.*;
import java.lang.reflect.*;
import mChaRM.multichannel.*;

/**
 * Interface for class RMPChannel
 * @author Michele Ferraro (<A HREF="mailto:1996s106@educ.disi.unige.it">1996s106@educ.disi.unige.it</A>)<br>
 *         Luigi Tosetto (<A HREF="mailto:1996s028@educ.disi.unige.it">1996s028@educ.disi.unige.it</A>)<br>
 *         Davide Zerbino (<A HREF="mailto:1996s027@educ.disi.unige.it">1996s027@educ.disi.unige.it</A>)
 * @version 1.2
 * @since Version 1.2
 **/

public interface RMPChannelInterface extends channelInterface {

  /**
	 * This method is remotely invoked by receiverStubs to request the retransmission of a message.
	 * @param n the number of the message needed
	 * @param name the name of the receiverStub that need the retransmission
	 **/
  public String nACK (int n, String name) throws MethodDoesNotExistException,RemoteException;
}
