package mChaRM.PremChaRM;

import openjava.mop.*;
import openjava.syntax.*;
import openjava.ptree.*;
import java.util.*;

  /**
   * This class representing the structure of fields and methods used to resolve the problem
   * of sharing out.
   * It contains methods to insert methods/fields and to find multi-refered fields.
   * @author Valentina Cord&igrave; (<A HREF="mailto:1996s081@educ.disi.unige.it">1996s081@educ.disi.unige.it</A>)
   * @author Maurizio Mazza (<A HREF="mailto:1996s065@educ.disi.unige.it">1996s065@educ.disi.unige.it</A>)
   * @author Roberto Montagna (<A HREF="mailto:1996s063@educ.disi.unige.it">1996s063@educ.disi.unige.it</A>)
   **/
public class PreGraph
 {
/*---------------------------------------
 Private Fields
---------------------------------------*/
   /**
    * This field contains all methods of the class.
    * It can be filled usig {@link #insertMethod(OJMethod, int) <B>insertMethod</B>} method.
    **/
 private Vector ojMethods = new Vector();

   /**
    * This field contains, for each method, the info about which class invoke it.
    * It's a Vector of boolean array of three elements. Each position of the array indicates:
    * <UL> 
    * <LI>[0] the method is used by Core class</LI>
    * <LI>[1] the method is used by Sender class</LI>
    * <LI>[2] the method is used by Receiver class</LI>
    * </UL>
    **/
 private Vector bUsedMethods = new Vector();

   /**
    * This field contains all fields of the class.
    * It can be filled usig {@link #insertFields(OJField, int[]) <B>insertFields</B>} method.
    **/
 private Vector ojFields = new Vector();

   /**
    * This field contains, for each field, the info about which class use it.
    * It's a Vector of boolean array that means:
    * <UL> 
    * <LI>[0] this field is used by Core class</LI>
    * <LI>[1] this field is used by Sender class</LI>
    * <LI>[2] this field is used by Receiver class</LI>
    * </UL>
    **/
 private Vector bUsedFields = new Vector();

/*---------------------------------------
 Public Methods
---------------------------------------*/

  /**
   * This method return the number of methods stored.
   * @return size of Vector ojMethods.
   **/ 
 public int numberOfMethods()
  {
  return ojMethods.size();
  }

  /**
   * This method return OJMethod specified by given index. 
   *<HR> 
   * @param index index of element to return
   * @exception ArrayIndexOutOfBoundsException  thrown when the index reified doesn't exist.
   **/ 
 public OJMethod methodAt(int index)
  {
  return (OJMethod)ojMethods.elementAt( index );
  }

  /**
   * This method check if a method is used by a class.
   *<HR> 
   * @param index index of method to be checked.
   * @param className a number that representing name of class to check if method is used in.
   * @return true if method at specified index is used by specified class.
   * @exception ArrayIndexOutOfBoundsException  thrown when the index reified doesn't exist in bUsedMethods.
   **/ 
 public boolean methodUsedBy( int index, int className )
  {
  return( ((int[])bUsedMethods.elementAt( index ))[className-1] == 1 );
  }

  /**
   * This method return an array that rapresent in which classes a method is called.
   *<HR> 
   * @param index index of method 
   * @exception ArrayIndexOutOfBoundsException  thrown when the index reified doesn't exist in bUsedMethods.
   **/ 
 public int[] methodUsedBy( int index )
  {
  return (int[])bUsedMethods.elementAt( index );
  }

  /**
   * This method return the number of fields stored. 
   * @return size of ojFields. 
   **/ 
 public int numberOfFields()
  {
  return ojFields.size();
  }

  /**
   * This method return the OJField object specified by index. 
   *<HR> 
   * @param index index of element to return
   * @return the field at given index.
   * @exception ArrayIndexOutOfBoundsException  thrown when the index reified doesn't exist in ojFields.
   **/ 
 public OJField fieldAt(int index)
  {
  return (OJField)ojFields.elementAt( index );
  }

  /**
   * This method check if a field is used in a class.
   *<HR> 
   * @param index index of field to be checked
   * @param className a number that representing name of class to check if field is used in 
   * @return true if field at specified index is used by specified class
   * @exception ArrayIndexOutOfBoundsException  thrown when the index reified doesn't exist in bUsedFields.
   **/ 
 public boolean fieldUsedBy( int index, int className )
  {
  return( ((int[])bUsedFields.elementAt( index ))[className-1] == 1 );
  }

  /**
   * This method return an array that rapresent in which classes the field is used.
   *<HR> 
   * @param index index of method 
   * @return array of three elements indicating in which classes the field is used.
   * @exception ArrayIndexOutOfBoundsException  thrown when the index reified doesn't exist in bUsedFields.
   **/ 
 public int[] fieldUsedBy( int index )
  {
  return (int[])bUsedFields.elementAt( index );
  }
  
  /**
   * Put a method in the graph. 
   * If the spedified method isn't already present in ojMethods 
   * this method adds it and sets bUsedMethod field, otherwise it only update bUsedMethod.
   *<HR> 
   * @param Method method to insert into the graph.
   * @param className a number that representing class that use the method.
   * @exception ArrayIndexOutOfBoundsException  thrown when the classname reified is grater than three
   **/ 
 public boolean insertMethod( OJMethod Method, int className )
  {
  PreUtils.printDebug("Start Method insertMethod", PreUtils.dbgGraphMethod, 0);
  PreUtils.printDebug("method inserted: "+ Method +" " + className, PreUtils.dbgGraphMethod, 1);
  int temp;
  int bRow[] = {0, 0, 0};
  if(( temp = ojMethods.indexOf( Method ) ) == -1 )
    {
    ojMethods.add( ojMethods.size(), Method );  
    bRow[className - 1] = 1;
    bUsedMethods.add( bUsedMethods.size(), bRow );
    return true; 
    }
  bRow = (int[])bUsedMethods.elementAt( temp );
  if( bRow[className - 1] == 1 )
    return false;
  bUsedMethods.remove( temp );
  bRow[className - 1] = 1;
  bUsedMethods.add( temp, bRow );
  return true;
  }
  
  /**
   * Put a field  in the graph. 
   * If the spedified fields isn't already present in ojFields 
   * add it and set bUsed, otherwise it only update bUsed
   *<HR> 
   * @param Method method to insert in the graph
   * @param className a number that representing class that use the method
   * @exception ArrayIndexOutOfBoundsException  thrown when the classname reified is grater than three
   **/ 
 public void insertFields( OJField Fields, int[] classesName )
  {
  PreUtils.printDebug("Start Method insertFields", PreUtils.dbgGraphField, 0);
  PreUtils.printDebug("field inserted: "+ Fields +" " + 
			    classesName[0] + " " + 
			    classesName[1] + " " +
			    classesName[2], PreUtils.dbgGraphField, 1);
  int temp;
  int bRow[] = {0, 0, 0};
  if(( temp = ojFields.indexOf( Fields ) ) == -1 )
    {
    ojFields.add( ojFields.size(), Fields );  
    for( int i=0; i<3; i++)
      if( classesName[i] == 1 )
        bRow[i] = 1;
    bUsedFields.add( bUsedFields.size(), bRow );
    return;
    }
  bRow = (int[])bUsedFields.elementAt( temp );
  bUsedFields.remove( temp );
  for( int i=0; i<3; i++)
    if( classesName[i] == 1 )
      bRow[i] = 1;
  bUsedFields.add( temp, bRow );
  }
  
  /**
   * This method checks if fields are dangerous, in other words it control if a fields is used by more than one class.
   * @return array that contains all dangerous methods.
   *<HR> 
   **/ 
 public Vector DangerousFields()
  {
  PreUtils.printDebug("Start Method DangerousFields", PreUtils.dbgGraphField, 0);

  Vector vReturn = new Vector();
  int bRow[];
  for(int i=0; i<bUsedFields.size(); i++)
    {
    bRow = (int[])bUsedFields.elementAt( i );
    if( (bRow[0]+bRow[1]+bRow[2]) > 1 )
      vReturn.add( ojFields.elementAt(i) ); 
    }
  return vReturn;
  } 

 }
