import mChaRM.multichannel.*;
import mChaRM.mChaRMCollection.*;
import uka.karmi.rmi.*;

  /**
   * realizes the sender stubs of a multi-channel of kind <I>mutant</I>. 
   * Its meta-behavior consists in piggybacking a second value to the call. This value will be used by the mutant call.
   * @author  Walter Cazzola (<A HREF="mailto:cazzola@disi.unige.it">cazzola@disi.unige.it</A>)
   * @version 1.1
   * @since Version 1.1
   **/
public class mutantSenderStub extends senderStub {
    /**
     * constructor for the stubs. Its ancestor constructor is entrusted of all the work.
     * <HR>
     * @param myReferent a representant of the stub referent.
     * @param myKind the multi-channel's name.
     * @param myReferentName the referent's name.
     * @exception SenderStubCannotBeRegisteredAsAServerException thrown when the stub cannot be registered as a server.
     * @exception SenderStubNotFoundException thrown when the core can't link to the this sender stub.
     * @exception CoreNotFoundException thrown when the core of the multi-channel, which the stub is part of,
     *            doesn't exist or isn't correctly registered as a server. 
     **/
  public mutantSenderStub(Object myReferent, String myKind, String myReferentName) 
         throws RemoteException, SenderStubCannotBeRegisteredAsAServerException, SenderStubNotFoundException, CoreNotFoundException {
    super(myReferent, myKind, myReferentName);
  }  
  
   /** This method performs the sender side meta-behavior for a multi-channel of kind <I>mutant</I>.
    * <HR>
    * It is called before passing all the staff to the core and it permits to perform meta-computations on sender side.
    * It prints a message related the trapped call, and piggybacks a new value to the call.
    * <HR>
    * @param msg the trapped message.
    **/
  public void beforeSenderSideMetaBehavior(mChaRMMethodCall msg) {
    System.out.print("*** trapped message "); msg.printmChaRMMethodCall();
    msg.insertArgument(1, new String("Piggybacked Value"));
    System.out.print("*** modified message "); msg.printmChaRMMethodCall();
  }
}


