import mChaRM.multichannel.*;
import mChaRM.mChaRMCollection.*;
import uka.karmi.rmi.*;

  /**
   * realizes a multi-channel of kind <I>mutant</I>. Its meta-behavior consists in replace a message with another. 
   * It uses instances of {@link mutantSenderStub mutantSenderStub} class as senderStubs, 
   * and instances of {@link mChaRM.multichannelreceiverStub receiverStub} as receiverStubs
   * @author  Walter Cazzola (<A HREF="mailto:cazzola@disi.unige.it">cazzola@disi.unige.it</A>)
   * @version 1.1
   * @since Version 1.1
   **/
public class mutantChannel extends verboseChannel implements channelInterface {
    /** 
     * constructor of multi-channels of kind mutant.
     * <HR>
     * It calls the {@link mChaRM.multichannel.channelCore#channelCore channelCore} constructor with kind mutant 
     * and as classes for sender and receiver stubs their mutant version.
     * <HR>
     * @param RsName an Array of Strings representing the name of the receivers, which it is connected to.
     * @exception ReceiverStubNotFoundException thrown when one of the specified receiver wasn't started before the core.
     **/
  public mutantChannel(String[] RsName) throws RemoteException, ReceiverStubNotFoundException {
    super("mutant", RsName, "mutantSenderStub", "mChaRM.multichannel.receiverStub");
  }
   
   /** This method embodies the reflective behaviour realized by the multi-channel.
    * @param msg the message to mutate.
    * @return the result of the method call.
    * @exception MethodDoesNotExistException thrown when the method reified doesn't exist in the referent class.
    **/

  public Object coreMetaBehavior(mChaRMMethodCall msg) throws MethodDoesNotExistException, RemoteException {
    System.out.print("*** [before changing] ");
    msg.printmChaRMMethodCall();
    msg.setMethodName("dummy3");
    return super.coreMetaBehavior(msg);
  }
}

