import uka.karmi.rmi.*;
import java.net.*;
import java.lang.reflect.*;
import java.lang.*;

/**
 *	Interface for class RMPReceiver
 * @author Michele Ferraro (<A HREF="mailto:1996s106@educ.disi.unige.it">1996s106@educ.disi.unige.it</A>)<br>
 *         Luigi Tosetto (<A HREF="mailto:1996s028@educ.disi.unige.it">1996s028@educ.disi.unige.it</A>)<br>
 *         Davide Zerbino (<A HREF="mailto:1996s027@educ.disi.unige.it">1996s027@educ.disi.unige.it</A>)
 * @version 1.2
 * @since Version 1.2
 **/

	
public interface RMPReceiverInterface extends Remote {
  /**
   * This method returns the string <I>Hello</I>.
   **/
  public String sayHello() throws RemoteException;
	
	/**
	 * This method increases the value of the parameter and returns the result.
	 * @param i the number to be incremented
	 **/
  public Integer increase(Integer i) throws RemoteException;
	
	/**
	 * This method sums the parameters and returns the result.
	 * @param x the first number
	 * @param y the second number
	 **/
  public Integer sum(Integer x, Integer y) throws RemoteException;
}
  
