# Downloading FLiRTS 2

Extract the zip file that you downloaded. Find the following contents inside the flirts2 folder:
* lib folder. Contains the jar file flirts2.jar.
* config folder. Contains the configuration files:
  * configs.txt. Contains the weights assigned to the UML relationship types, and the selection threshold.
  * fuzzylogic.fcl. Contains the fuzzy logic configuration.
* flirts2.sh. Script to run flirts2.jar.

The config and lib folders must be kept in the source folder as flirts2.sh.

# Installing Third Party Libraries Used by FLiRTS 2

FLiRTS 2 uses NanoXML, jFuzzyLogic, and JGraphT libraries. Download their jar files and place them inside the lib folder. These jar files are:     
* NanoXML (nanoxml-2.2.1.jar,  http://nanoxml.sourceforge.net/orig/). 
* jFuzzyLogic (jFuzzyLogic.jar the full version, http://jfuzzylogic.sourceforge.net/html/index.html).
* JGraphT (JGraphT 1.2.0 was used in our experiment) and its dependencies (https://jgrapht.org/):
 * jgrapht-core-x.y.z.jar
 * jgrapht-demo-x.y.z.jar
 * jgrapht-ext-x.y.z.jar
 * jgrapht-io-x.y.z.jar
 * jgrapht-guava-x.y.z.jar
 * jgrapht-bundle-x.y.z.jar
 * jgraphx-a.b.c.jar
 * antlr4-runtime-x.y.jar
 * commons-lang3-x.y.z.jar
 * commons-text-x.y.jar
 * fastutil-x.y.z.jar
 * guava-x.y-jre.jar
 * jheaps-x.y.jar

# Define the FLIRTS2_HOME Environment Variable
* For bash use the command:
export FLIRTS2_HOME=<"absolute path to the flirts2 installation folder">

* For csh/tcsh use the command:
setenv FLIRTS2_HOME <"absolute path to the flirts2 installation folder">

# Running FLiRTS 2
Use the script flirts2.sh to run FLiRTS 2 as follows:

* If the direct invocations of the test classes are already represented in the class diagram as call usage dependencies, then run the command:

 ./flirts2.sh <"classDiagram.emx"> <"AdaptedClasses.txt"> <"path to a folder to store the output files produced by FLiRTS 2">

* If a separate text file that contains the direct invocations of the test classes is provided, then run the command:

 ./flirts2.sh <"classDiagram.emx"> <"DirectInvocationsFromTestClasses.txt">  <"AdaptedClasses.txt">  <"path to a folder to store the output files produced by FLiRTS 2">

where:
 * classDiagram.emx. The adapted UML class diagram that represents the system under test and its test classes.  FLiRTS 2 accepts .emx and .uml model files, which can be produced using Rational Software Architect (RSA).

 * DirectInvocationsFromTestClasses.txt. Contains the direct invocations from test classes. Each line in the text file must be in the format: fully qualified name of the test class --> fully qualified name of the invoked class. 

 * AdaptedClasses.txt. Lists the names of the adapted classes.


FLiRTS 2 outputs the following two files:

* RetestableTestClasses.txt. Lists the fully qualified names of the retestable test classes.

* ReusableTestClasses.txt. Lists the fully qualified names of the reusable test classes.

These two files are stored inside the folder whose path is provided as an argument to flirts2.sh.
