/*
 * Decompiled with CFR 0.152.
 */
package fliRTS.rts;

import fliRTS.crg.CRGBuilder;
import fliRTS.crg.ClassModelReader;
import fliRTS.crg.ClassRelationType;
import fliRTS.rts.AdaptedClassesReader;
import fliRTS.rts.InputCrispVariable;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Scanner;
import java.util.Set;
import net.sourceforge.jFuzzyLogic.FIS;
import org.jgrapht.alg.shortestpath.DijkstraShortestPath;
import org.jgrapht.graph.DefaultDirectedWeightedGraph;
import org.jgrapht.graph.DefaultWeightedEdge;
import org.jgrapht.graph.EdgeReversedGraph;
import org.jgrapht.traverse.BreadthFirstIterator;

public class Classifier {
    protected DefaultDirectedWeightedGraph<String, DefaultWeightedEdge> classRelationsGraph = new DefaultDirectedWeightedGraph(DefaultWeightedEdge.class);
    protected HashMap<String, InputCrispVariable> ClassCrispValueMap = new HashMap();
    protected HashSet<String> AdaptedClasses = new HashSet();
    protected HashSet<String> testClasses = new HashSet();
    protected HashMap<DefaultWeightedEdge, ClassRelationType> edgeTypeMap = new HashMap();
    protected int[] weightsSet = new int[7];
    protected double selectionThreshold;
    protected static final int MIN_DISTANCE = Integer.MAX_VALUE;
    protected AdaptedClassesReader adaptedClassesReader = new AdaptedClassesReader(this);
    String fclFile;

    protected AdaptedClassesReader getAdaptedClassReader() {
        return this.adaptedClassesReader;
    }

    protected DefaultDirectedWeightedGraph<String, DefaultWeightedEdge> getClassRelationsGraph() {
        return this.classRelationsGraph;
    }

    protected HashMap<DefaultWeightedEdge, ClassRelationType> getEdgeTypeMap() {
        return this.edgeTypeMap;
    }

    protected HashSet<String> getAdaptedClasses() {
        return this.AdaptedClasses;
    }

    protected HashSet<String> getTestClasses() {
        return this.testClasses;
    }

    public void readClassModelRelations(String string) throws Exception {
        ClassModelReader classModelReader = new ClassModelReader();
        classModelReader.readUMLClassModel(string);
        this.classRelationsGraph = classModelReader.getClassRelationsGraph();
        this.testClasses = classModelReader.getTestClasses();
        this.edgeTypeMap = classModelReader.geteEdgeTypeMap();
    }

    protected void calculateValuesOfInputCrispVariables() {
        EdgeReversedGraph edgeReversedGraph = new EdgeReversedGraph(this.classRelationsGraph);
        for (String string : this.testClasses) {
            if (!this.classRelationsGraph.containsVertex((Object)string)) continue;
            int n = Integer.MAX_VALUE;
            double d = 0.0;
            for (String string2 : this.AdaptedClasses) {
                int n2;
                if (!this.classRelationsGraph.containsVertex((Object)string2)) continue;
                if (string.equals(string2)) {
                    n = 0;
                    d = 1.0;
                    continue;
                }
                if (DijkstraShortestPath.findPathBetween(this.classRelationsGraph, (Object)string, (Object)string2) == null || (n2 = DijkstraShortestPath.findPathBetween(this.classRelationsGraph, (Object)string, (Object)string2).getLength()) >= n) continue;
                n = n2;
            }
            InputCrispVariable inputCrispVariable = new InputCrispVariable();
            inputCrispVariable.setMinimumDistance(n);
            HashSet<String> object2 = this.getNodesReachableFromTestClass(string);
            HashSet<String> hashSet = this.getNodesReachingAdaptedClasses(object2, this.AdaptedClasses, (EdgeReversedGraph<String, DefaultWeightedEdge>)edgeReversedGraph);
            double d2 = 0.0;
            d2 = this.getProbability(object2, hashSet, this.weightsSet);
            if (d2 > d) {
                inputCrispVariable.setPathsProbability(this.weightsSet, d2);
            } else {
                inputCrispVariable.setPathsProbability(this.weightsSet, d);
            }
            this.ClassCrispValueMap.put(string, inputCrispVariable);
        }
    }

    protected HashSet<String> classifyBasedOnFuzzyLogicWithWieght(String string) {
        Object object;
        HashSet<String> hashSet = new HashSet<String>();
        HashSet<String> hashSet2 = new HashSet<String>();
        FIS fIS = FIS.load((String)this.fclFile, (boolean)true);
        if (fIS == null) {
            System.err.println("Can't load file: '" + this.fclFile + "'");
            return null;
        }
        for (String iterator : this.ClassCrispValueMap.keySet()) {
            fIS.setVariable("p", this.ClassCrispValueMap.get(iterator).getPathsProbability(this.weightsSet));
            fIS.setVariable("d", (double)this.ClassCrispValueMap.get(iterator).getMinimumDistance());
            fIS.evaluate();
            double d = fIS.getVariable("tc").getMembership("Retestable");
            if (d >= this.selectionThreshold) {
                hashSet.add(iterator);
                continue;
            }
            hashSet2.add(iterator);
        }
        try {
            object = new FileWriter(string + "RetestableTestClasses.txt", false);
            for (String string2 : hashSet) {
                ((Writer)object).write(string2);
                ((Writer)object).write("\n");
            }
            ((OutputStreamWriter)object).close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        try {
            object = new FileWriter(string + "ReusableTestClasses.txt", false);
            for (String string3 : hashSet2) {
                ((Writer)object).write(string3);
                ((Writer)object).write("\n");
            }
            ((OutputStreamWriter)object).close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return hashSet;
    }

    protected HashSet<String> getNodesReachableFromTestClass(String string) {
        HashSet<String> hashSet = new HashSet<String>();
        BreadthFirstIterator breadthFirstIterator = new BreadthFirstIterator(this.classRelationsGraph, (Object)string);
        while (breadthFirstIterator.hasNext()) {
            hashSet.add((String)breadthFirstIterator.next());
        }
        return hashSet;
    }

    protected HashSet<String> getNodesReachingAdaptedClasses(HashSet<String> hashSet, HashSet<String> hashSet2, EdgeReversedGraph<String, DefaultWeightedEdge> edgeReversedGraph) {
        HashSet<String> hashSet3 = new HashSet<String>();
        BreadthFirstIterator breadthFirstIterator = new BreadthFirstIterator(edgeReversedGraph, hashSet2);
        while (breadthFirstIterator.hasNext()) {
            String string = (String)breadthFirstIterator.next();
            if (!hashSet.contains(string)) continue;
            hashSet3.add(string);
        }
        return hashSet3;
    }

    protected double getProbability(HashSet<String> hashSet, HashSet<String> hashSet2, int[] nArray) {
        HashSet<DefaultWeightedEdge> hashSet3 = new HashSet<DefaultWeightedEdge>();
        HashSet<DefaultWeightedEdge> hashSet4 = new HashSet<DefaultWeightedEdge>();
        for (String string : hashSet) {
            hashSet3.addAll(this.classRelationsGraph.outgoingEdgesOf((Object)string));
        }
        double d = 0.0;
        d = this.getWeightsOfEdgeSet(hashSet3, nArray);
        for (String string : hashSet) {
            if (!hashSet2.contains(string)) continue;
            HashSet hashSet5 = new HashSet();
            hashSet5.addAll(this.classRelationsGraph.outgoingEdgesOf((Object)string));
            for (DefaultWeightedEdge defaultWeightedEdge : hashSet5) {
                if (!hashSet2.contains(this.classRelationsGraph.getEdgeTarget((Object)defaultWeightedEdge))) continue;
                hashSet4.add(defaultWeightedEdge);
            }
        }
        double d2 = 0.0;
        d2 = this.getWeightsOfEdgeSet(hashSet4, nArray);
        double d3 = d;
        if (d3 > 0.0) {
            d3 = d2 / d;
        }
        return d3;
    }

    private double getWeightsOfEdgeSet(Set<DefaultWeightedEdge> set, int[] nArray) {
        double d = 0.0;
        for (DefaultWeightedEdge defaultWeightedEdge : set) {
            ClassRelationType classRelationType = this.edgeTypeMap.get(defaultWeightedEdge);
            if (classRelationType == null) continue;
            if (classRelationType.getAssociation()) {
                d += (double)(nArray[0] * classRelationType.getAssociationCount());
            }
            if (classRelationType.getRealization()) {
                d += (double)(nArray[1] * classRelationType.getRealizationCount());
            }
            if (classRelationType.getGeneralization()) {
                d += (double)(nArray[2] * classRelationType.getGeneralizationCount());
            }
            if (classRelationType.getOpReturnType()) {
                d += (double)(nArray[3] * classRelationType.getOpReturnTypeCount());
            }
            if (classRelationType.getOpInputParType()) {
                d += (double)(nArray[4] * classRelationType.getOpInputParTypeTCount());
            }
            if (classRelationType.getUsageDepedency()) {
                d += (double)(nArray[5] * classRelationType.getUsageDepedencyCount());
            }
            if (!classRelationType.getTagValue()) continue;
            d += (double)(nArray[6] * classRelationType.getTagValueCount());
        }
        return d;
    }

    protected void readTestClassesDirectInvocations(String string) throws IOException {
        String string2 = "";
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        Scanner scanner = new Scanner(string2);
        String string3 = "-->";
        String string4 = "[$]";
        while ((string2 = bufferedReader.readLine()) != null) {
            DefaultWeightedEdge defaultWeightedEdge;
            if (!string2.contains(string3)) continue;
            String[] stringArray = string2.split(string3);
            String string5 = stringArray[0].trim();
            String string6 = stringArray[1].trim();
            String[] stringArray2 = string5.split(string4);
            string5 = stringArray2[0].trim();
            String[] stringArray3 = string6.split(string4);
            string6 = stringArray3[0].trim();
            if (!this.testClasses.contains(string5) || !this.classRelationsGraph.containsVertex((Object)string5) || !this.classRelationsGraph.containsVertex((Object)string6) || string5.equals(string6)) continue;
            ++CRGBuilder.numUsageDependency;
            if (!this.classRelationsGraph.containsEdge((Object)string5, (Object)string6)) {
                defaultWeightedEdge = new DefaultWeightedEdge();
                this.classRelationsGraph.addEdge((Object)string5, (Object)string6, (Object)defaultWeightedEdge);
                this.classRelationsGraph.setEdgeWeight((Object)defaultWeightedEdge, 0.0);
                ClassRelationType classRelationType = new ClassRelationType();
                classRelationType.setUsageDepedencyTrue();
                classRelationType.increaseUsageDepedencyCount();
                this.edgeTypeMap.put(defaultWeightedEdge, classRelationType);
                continue;
            }
            defaultWeightedEdge = (DefaultWeightedEdge)this.classRelationsGraph.getEdge((Object)string5, (Object)string6);
            if (!this.edgeTypeMap.containsKey(defaultWeightedEdge)) continue;
            this.edgeTypeMap.get(defaultWeightedEdge).increaseUsageDepedencyCount();
            this.edgeTypeMap.get(defaultWeightedEdge).setUsageDepedencyTrue();
        }
    }

    protected void readConfigurations(String string, String string2) throws IOException {
        this.fclFile = string2;
        String string3 = "";
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        Scanner scanner = new Scanner(string3);
        while ((string3 = bufferedReader.readLine()) != null) {
            String[] stringArray;
            if (string3.contains("selectionThreshold")) {
                double d;
                stringArray = string3.split("=");
                this.selectionThreshold = d = Double.parseDouble(stringArray[1].trim());
                continue;
            }
            stringArray = string3.split("=");
            int n = Integer.parseInt(stringArray[1].trim());
            if (string3.contains("association")) {
                this.weightsSet[0] = n;
                continue;
            }
            if (string3.contains("realization")) {
                this.weightsSet[1] = n;
                continue;
            }
            if (string3.contains("generalization")) {
                this.weightsSet[2] = n;
                continue;
            }
            if (string3.contains("operationReturnType")) {
                this.weightsSet[3] = n;
                continue;
            }
            if (string3.contains("operationInputParameter")) {
                this.weightsSet[4] = n;
                continue;
            }
            if (string3.contains("usageDependency")) {
                this.weightsSet[5] = n;
                continue;
            }
            if (!string3.contains("tagValue")) continue;
            this.weightsSet[6] = n;
        }
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length == 6) {
            Classifier classifier = new Classifier();
            classifier.readConfigurations(stringArray[0], stringArray[1]);
            classifier.readClassModelRelations(stringArray[2]);
            classifier.readTestClassesDirectInvocations(stringArray[3]);
            classifier.getAdaptedClassReader().readAdaptedClasses(stringArray[4]);
            classifier.calculateValuesOfInputCrispVariables();
            classifier.classifyBasedOnFuzzyLogicWithWieght(stringArray[5]);
        } else if (stringArray.length == 5) {
            Classifier classifier = new Classifier();
            classifier.readConfigurations(stringArray[0], stringArray[1]);
            classifier.readClassModelRelations(stringArray[2]);
            classifier.getAdaptedClassReader().readAdaptedClasses(stringArray[3]);
            classifier.calculateValuesOfInputCrispVariables();
            classifier.classifyBasedOnFuzzyLogicWithWieght(stringArray[4]);
        }
    }
}

