/*
 * Decompiled with CFR 0.152.
 */
package fliRTS.crg;

import fliRTS.crg.ClassRelationType;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import java.util.Vector;
import net.n3.nanoxml.IXMLElement;
import net.n3.nanoxml.XMLException;
import org.jgrapht.graph.DefaultDirectedWeightedGraph;
import org.jgrapht.graph.DefaultWeightedEdge;

public class CRGBuilder {
    public static int numGeralization;
    public static int numRealization;
    public static int numAssociation;
    public static int numUsageDependency;
    public static int numOpInputPar;
    public static int numOpReturnType;
    DefaultDirectedWeightedGraph<String, DefaultWeightedEdge> classRelationsGraph = new DefaultDirectedWeightedGraph(DefaultWeightedEdge.class);
    HashMap<DefaultWeightedEdge, ClassRelationType> edgeTypeMap = new HashMap();
    HashSet<String> testClasses = new HashSet();
    private PrintWriter writer;
    public HashMap<String, String> classIDMapper = new HashMap();
    public HashMap<String, String> tageValue2stereoTypeBaseClass = new HashMap();
    public HashMap<String, String> stereoTypeID2BaseClass = new HashMap();

    public HashMap<DefaultWeightedEdge, ClassRelationType> getEdgeTypeMap() {
        return this.edgeTypeMap;
    }

    public DefaultDirectedWeightedGraph<String, DefaultWeightedEdge> getClassRelationsGraph() {
        return this.classRelationsGraph;
    }

    public HashSet<String> getTestClasses() {
        return this.testClasses;
    }

    public CRGBuilder(Writer writer) {
        this.writer = writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer);
    }

    public CRGBuilder(OutputStream outputStream) {
        this.writer = new PrintWriter(outputStream);
    }

    protected void finalize() throws Throwable {
        this.writer = null;
        super.finalize();
    }

    public void buildCRG(IXMLElement iXMLElement, String string) throws IOException, XMLException {
        this.obtainClassIDs(iXMLElement);
        this.buildCRG(iXMLElement);
        this.addEdgesForTaggedValues();
    }

    private void addEdgesForTaggedValues() {
        for (String string : this.tageValue2stereoTypeBaseClass.keySet()) {
            String string2 = this.classIDMapper.get(this.tageValue2stereoTypeBaseClass.get(string));
            String string3 = this.stereoTypeID2BaseClass.get(string);
            String string4 = this.classIDMapper.get(string3);
            if (string2 == null || string4 == null || string2.equals(string4) || !this.classRelationsGraph.containsVertex((Object)string2) || !this.classRelationsGraph.containsVertex((Object)string4)) continue;
            this.addEdgeInCRG(string2, string4, "TagValue");
        }
    }

    public void buildCRG(IXMLElement iXMLElement) throws IOException, XMLException {
        if (iXMLElement.getName() != null && iXMLElement.hasChildren()) {
            Enumeration enumeration = iXMLElement.enumerateChildren();
            while (enumeration.hasMoreElements()) {
                IXMLElement iXMLElement2 = (IXMLElement)enumeration.nextElement();
                this.buildCRG(iXMLElement2);
            }
            if (iXMLElement.getAttribute("xmi:type", "").toString().equals("uml:Class")) {
                this.readClassRelationships(iXMLElement, true);
            }
            if (iXMLElement.getAttribute("xmi:type", "").toString().equals("uml:Interface")) {
                this.readClassRelationships(iXMLElement, false);
            }
            this.readUsageDependency(iXMLElement);
        }
    }

    public void readUsageDependency(IXMLElement iXMLElement) {
        Vector vector = iXMLElement.getChildren();
        for (IXMLElement iXMLElement2 : vector) {
            if (!iXMLElement2.getAttribute("xmi:type", "").equals("uml:Dependency") && !iXMLElement2.getAttribute("xmi:type", "").equals("uml:Usage")) continue;
            String string = this.classIDMapper.get(iXMLElement2.getAttribute("supplier", ""));
            String string2 = this.classIDMapper.get(iXMLElement2.getAttribute("client", ""));
            if (string == null || string2 == null) continue;
            ++numUsageDependency;
            if (!this.classRelationsGraph.containsVertex((Object)string2)) {
                this.classRelationsGraph.addVertex((Object)string2);
            }
            this.addEdgeInCRG(string2, string, "UsageDepedency");
        }
    }

    protected void addEdgeInCRG(String string, String string2, String string3) {
        if (!string.equals(string2)) {
            if (!this.classRelationsGraph.containsVertex((Object)string2)) {
                this.classRelationsGraph.addVertex((Object)string2);
            }
            if (!this.classRelationsGraph.containsEdge((Object)string, (Object)string2)) {
                DefaultWeightedEdge defaultWeightedEdge = new DefaultWeightedEdge();
                this.classRelationsGraph.addEdge((Object)string, (Object)string2, (Object)defaultWeightedEdge);
                this.classRelationsGraph.setEdgeWeight((Object)defaultWeightedEdge, 0.0);
                this.addEdgeInformation(defaultWeightedEdge, string3);
            } else {
                DefaultWeightedEdge defaultWeightedEdge = (DefaultWeightedEdge)this.classRelationsGraph.getEdge((Object)string, (Object)string2);
                this.updateEdgeInformation(defaultWeightedEdge, string3);
            }
        }
    }

    protected void addEdgeInformation(DefaultWeightedEdge defaultWeightedEdge, String string) {
        ClassRelationType classRelationType = new ClassRelationType();
        this.edgeTypeMap.put(defaultWeightedEdge, classRelationType);
        this.updateRelationType(defaultWeightedEdge, string);
    }

    protected void updateEdgeInformation(DefaultWeightedEdge defaultWeightedEdge, String string) {
        if (this.edgeTypeMap.containsKey(defaultWeightedEdge)) {
            this.updateRelationType(defaultWeightedEdge, string);
        }
    }

    protected void updateRelationType(DefaultWeightedEdge defaultWeightedEdge, String string) {
        if (string.equals("Association")) {
            this.edgeTypeMap.get(defaultWeightedEdge).increaseAssociationCount();
            this.edgeTypeMap.get(defaultWeightedEdge).setAssociationTrue();
        } else if (string.equals("Generalization")) {
            this.edgeTypeMap.get(defaultWeightedEdge).increaseGeneralizationCount();
            this.edgeTypeMap.get(defaultWeightedEdge).setGeneralizationTrue();
        } else if (string.equals("Realization")) {
            this.edgeTypeMap.get(defaultWeightedEdge).increaseRealizationCount();
            this.edgeTypeMap.get(defaultWeightedEdge).setRealizationTrue();
        } else if (string.equals("OpInputParType")) {
            this.edgeTypeMap.get(defaultWeightedEdge).increaseOpInputParTypeTCount();
            this.edgeTypeMap.get(defaultWeightedEdge).setOpInputParTypeTrue();
        } else if (string.equals("OpReturnType")) {
            this.edgeTypeMap.get(defaultWeightedEdge).increaseOpReturnTypeCount();
            this.edgeTypeMap.get(defaultWeightedEdge).setOpReturnTypeTrue();
        } else if (string.equals("UsageDepedency")) {
            this.edgeTypeMap.get(defaultWeightedEdge).increaseUsageDepedencyCount();
            this.edgeTypeMap.get(defaultWeightedEdge).setUsageDepedencyTrue();
        } else if (string.equals("TagValue")) {
            this.edgeTypeMap.get(defaultWeightedEdge).increaseTagValueCount();
            this.edgeTypeMap.get(defaultWeightedEdge).setTagValueTrue();
        }
    }

    public void readClassRelationships(IXMLElement iXMLElement, boolean bl) {
        String string;
        Object object;
        Object object2;
        String string2;
        String string3 = iXMLElement.getAttribute("name", "");
        if (string3.contains("<")) {
            string2 = "[<]";
            object2 = string3.split(string2);
            string3 = object2[0].trim();
        }
        string2 = "";
        if (iXMLElement.getParent().getAttribute("xmi:type", "").equals("uml:Package")) {
            object2 = iXMLElement.getParent().getAttribute("name", "");
            string2 = (String)object2 + "." + string3;
        } else if (iXMLElement.getName().equals("nestedClassifier")) {
            boolean bl2 = false;
            for (object = iXMLElement.getParent(); object != null && !bl2; object = object.getParent()) {
                if (!object.getParent().getAttribute("xmi:type", "").equals("uml:Package")) continue;
                string = object.getParent().getAttribute("name", "");
                string2 = string + "." + string3;
                bl2 = true;
            }
        }
        if (string2.equals("")) {
            string2 = string3;
        }
        if (!this.classRelationsGraph.containsVertex((Object)string2)) {
            this.classRelationsGraph.addVertex((Object)string2);
        }
        if (bl && (string3.toLowerCase().endsWith("test") || string3.toLowerCase().endsWith("testcase") || string3.toLowerCase().startsWith("test"))) {
            this.testClasses.add(string2);
        }
        if (iXMLElement.hasChildren()) {
            Enumeration enumeration = iXMLElement.enumerateChildren();
            object = iXMLElement.enumerateChildren();
            while (enumeration.hasMoreElements()) {
                Object object3;
                string = (IXMLElement)enumeration.nextElement();
                if (string.getName().equals("generalization") && (object3 = this.classIDMapper.get(string.getAttribute("general", ""))) != null) {
                    ++numGeralization;
                    this.addEdgeInCRG(string2, (String)object3, "Generalization");
                    if (!((String)object3).toLowerCase().contains("test") && !string2.toLowerCase().contains("test")) {
                        this.addEdgeInCRG((String)object3, string2, "Generalization");
                    }
                }
                if (string.getName().equals("interfaceRealization") && (object3 = this.classIDMapper.get(string.getAttribute("supplier", ""))) != null) {
                    ++numRealization;
                    this.addEdgeInCRG(string2, (String)object3, "Realization");
                    if (!((String)object3).toLowerCase().contains("test") && !string2.toLowerCase().contains("test")) {
                        this.addEdgeInCRG((String)object3, string2, "Realization");
                    }
                }
                if (string.getName().equals("ownedAttribute") && (object3 = this.classIDMapper.get(string.getAttribute("type", ""))) != null) {
                    ++numAssociation;
                    this.addEdgeInCRG(string2, (String)object3, "Association");
                }
                if (!string.getName().equals("ownedOperation") || !string.hasChildren()) continue;
                object3 = string.enumerateChildren();
                while (object3.hasMoreElements()) {
                    String string4;
                    IXMLElement iXMLElement2 = (IXMLElement)object3.nextElement();
                    if (iXMLElement2.getName().equals("ownedParameter") && iXMLElement2.getAttribute("direction", "").equals("return") && (string4 = this.classIDMapper.get(iXMLElement2.getAttribute("type", ""))) != null) {
                        ++numOpReturnType;
                        this.addEdgeInCRG(string2, string4, "OpReturnType");
                    }
                    if (!iXMLElement2.getName().equals("ownedParameter") || iXMLElement2.getAttribute("direction", "").equals("return") || (string4 = this.classIDMapper.get(iXMLElement2.getAttribute("type", ""))) == null) continue;
                    ++numOpInputPar;
                    this.addEdgeInCRG(string2, string4, "OpInputParType");
                }
            }
        }
    }

    public void obtainClassIDs(IXMLElement iXMLElement) throws IOException, XMLException {
        if (iXMLElement.getName() != null && iXMLElement.hasChildren()) {
            Object object;
            String string;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            Object object6;
            Enumeration enumeration = iXMLElement.enumerateChildren();
            while (enumeration.hasMoreElements()) {
                object6 = (IXMLElement)enumeration.nextElement();
                this.obtainClassIDs((IXMLElement)object6);
            }
            if (iXMLElement.getAttribute("xmi:type", "").toString().equals("uml:Class") || iXMLElement.getAttribute("xmi:type", "").toString().equals("uml:Interface") || iXMLElement.getAttribute("xmi:type", "").toString().equals("uml:Enumeration")) {
                object6 = "";
                if (iXMLElement.getParent().getAttribute("xmi:type", "").equals("uml:Package")) {
                    object6 = iXMLElement.getParent().getAttribute("name", "");
                } else if (iXMLElement.getName().equals("nestedClassifier")) {
                    boolean bl = false;
                    for (object5 = iXMLElement.getParent(); object5 != null && !bl; object5 = object5.getParent()) {
                        if (!object5.getParent().getAttribute("xmi:type", "").equals("uml:Package")) continue;
                        object6 = object5.getParent().getAttribute("name", "");
                        bl = true;
                    }
                }
                object4 = iXMLElement.getAttribute("name", "");
                if (((String)object4).contains("<")) {
                    object5 = "[<]";
                    object3 = ((String)object4).split((String)object5);
                    object4 = object3[0].trim();
                }
                if (!((String)object4).equals("")) {
                    if (!((String)object6).equals("")) {
                        this.classIDMapper.put(iXMLElement.getAttribute("xmi:id", ""), (String)object6 + "." + (String)object4);
                    } else {
                        this.classIDMapper.put(iXMLElement.getAttribute("xmi:id", ""), (String)object4);
                    }
                }
            } else {
                object6 = iXMLElement.getChildren();
                object4 = ((Vector)object6).iterator();
                while (object4.hasNext()) {
                    object5 = (IXMLElement)object4.next();
                    if (!object5.getAttribute("xmi:type", "").toString().equals("uml:Class") && !object5.getAttribute("xmi:type", "").toString().equals("uml:Interface")) continue;
                    object3 = "";
                    if (object5.getParent().getAttribute("xmi:type", "").equals("uml:Package")) {
                        object3 = object5.getParent().getAttribute("name", "");
                    } else {
                        boolean bl = false;
                        for (object2 = object5.getParent(); object2 != null && !bl; object2 = object2.getParent()) {
                            if (!object2.getAttribute("xmi:type", "").equals("uml:Package")) continue;
                            object3 = object2.getParent().getAttribute("name", "");
                            bl = true;
                        }
                    }
                    string = object5.getAttribute("name", "");
                    if (string.contains("<")) {
                        object2 = "[<]";
                        object = string.split((String)object2);
                        string = object[0].trim();
                    }
                    if (string.equals("")) continue;
                    if (!object3.equals("")) {
                        this.classIDMapper.put(object5.getAttribute("xmi:id", ""), (String)object3 + "." + string);
                        this.classRelationsGraph.addVertex((Object)((String)object3 + "." + string));
                        continue;
                    }
                    this.classIDMapper.put(object5.getAttribute("xmi:id", ""), string);
                    this.classRelationsGraph.addVertex((Object)string);
                }
            }
            object6 = iXMLElement.getChildren();
            object4 = ((Vector)object6).iterator();
            while (object4.hasNext()) {
                object5 = (IXMLElement)object4.next();
                if (object5.getAttribute("base_Class", "") == null || object5.getAttribute("base_Class", "").toString().isEmpty()) continue;
                object3 = object5.getAttribute("base_Class", "").toString();
                string = object5.getAttribute("xmi:id", "").toString();
                this.stereoTypeID2BaseClass.put(string, (String)object3);
                object2 = object5.getAttributes();
                object = ((Properties)object2).propertyNames();
                while (object.hasMoreElements()) {
                    String string2 = (String)object.nextElement();
                    if (string2.equals("xmi:id")) continue;
                    this.tageValue2stereoTypeBaseClass.put(object5.getAttribute(string2, "").toString(), (String)object3);
                }
            }
        }
    }
}

