#!/bin/env bash

PATH_TO_REVISIONS_DIR=$1  # path to the directory that contains the code-level revisions

_PitestFLiRTS__PROFILE=$(cat <<EOF
        <profile>
            <id>fpitestp</id>
            <activation>
                <property>
                    <name>pitest</name>
                </property>
            </activation>
            <build>
                <plugins>
                         <plugin>
                  <groupId>org.pitest</groupId>
                  <artifactId>pitest-maven</artifactId>
                  <version>1.3.1</version>
                  <configuration>
                        <targetClasses>
                                trgClasses
                        </targetClasses>
                                
                        <targetTests>
                                trgTestClasses
                        </targetTests>
                        <mutators>
                                <mutator>CONSTRUCTOR_CALLS</mutator>
                                <mutator>NON_VOID_METHOD_CALLS</mutator>
                                <mutator>INLINE_CONSTS</mutator>
                                <mutator>REMOVE_CONDITIONALS</mutator>
                                <mutator>EXPERIMENTAL_MEMBER_VARIABLE</mutator>
                                <mutator>EXPERIMENTAL_SWITCH</mutator>
                                <mutator>CONDITIONALS_BOUNDARY</mutator>
                                <mutator>INCREMENTS</mutator>
                                <mutator>INVERT_NEGS</mutator>
                                <mutator>MATH</mutator>
                                <mutator>NEGATE_CONDITIONALS</mutator>
                                <mutator>RETURN_VALS</mutator>
                                <mutator>VOID_METHOD_CALLS</mutator>
                        </mutators>
                  </configuration>
           </plugin>
                </plugins>
            </build>
        </profile>
EOF
)
_PitestFLiRTS__PROFILE=$(echo ${_PitestFLiRTS__PROFILE} | sed 's/ //g')


_PitestSTARTS__PROFILE=$(cat <<EOF
        <profile>
            <id>spitestp</id>
            <activation>
                <property>
                    <name>pitest</name>
                </property>
            </activation>
            <build>
                <plugins>
                         <plugin>
                  <groupId>org.pitest</groupId>
                  <artifactId>pitest-maven</artifactId>
                  <version>1.3.1</version>
                  <configuration>
                        <targetClasses>
                                trgClasses
                        </targetClasses>
                                
                        <targetTests>
                                trgTestClasses
                        </targetTests>
                        <mutators>
                                <mutator>CONSTRUCTOR_CALLS</mutator>
                                <mutator>NON_VOID_METHOD_CALLS</mutator>
                                <mutator>INLINE_CONSTS</mutator>
                                <mutator>REMOVE_CONDITIONALS</mutator>
                                <mutator>EXPERIMENTAL_MEMBER_VARIABLE</mutator>
                                <mutator>EXPERIMENTAL_SWITCH</mutator>
                                <mutator>CONDITIONALS_BOUNDARY</mutator>
                                <mutator>INCREMENTS</mutator>
                                <mutator>INVERT_NEGS</mutator>
                                <mutator>MATH</mutator>
                                <mutator>NEGATE_CONDITIONALS</mutator>
                                <mutator>RETURN_VALS</mutator>
                                <mutator>VOID_METHOD_CALLS</mutator>
                        </mutators>
                  </configuration>
           </plugin>
                </plugins>
            </build>
        </profile>
EOF
)
_PitestSTARTS__PROFILE=$(echo ${_PitestSTARTS__PROFILE} | sed 's/ //g')


_PitestEkstazi__PROFILE=$(cat <<EOF
        <profile>
            <id>epitestp</id>
            <activation>
                <property>
                    <name>pitest</name>
                </property>
            </activation>
            <build>
                <plugins>
                         <plugin>
                  <groupId>org.pitest</groupId>
                  <artifactId>pitest-maven</artifactId>
                  <version>1.3.1</version>
                  <configuration>
                        <targetClasses>
                                trgClasses
                        </targetClasses>
                                
                        <targetTests>
                                trgTestClasses
                        </targetTests>
                        <mutators>
                                <mutator>CONSTRUCTOR_CALLS</mutator>
                                <mutator>NON_VOID_METHOD_CALLS</mutator>
                                <mutator>INLINE_CONSTS</mutator>
                                <mutator>REMOVE_CONDITIONALS</mutator>
                                <mutator>EXPERIMENTAL_MEMBER_VARIABLE</mutator>
                                <mutator>EXPERIMENTAL_SWITCH</mutator>
                                <mutator>CONDITIONALS_BOUNDARY</mutator>
                                <mutator>INCREMENTS</mutator>
                                <mutator>INVERT_NEGS</mutator>
                                <mutator>MATH</mutator>
                                <mutator>NEGATE_CONDITIONALS</mutator>
                                <mutator>RETURN_VALS</mutator>
                                <mutator>VOID_METHOD_CALLS</mutator>
                        </mutators>
                  </configuration>
           </plugin>
                </plugins>
            </build>
        </profile>
EOF
)
_PitestEkstazi__PROFILE=$(echo ${_PitestEkstazi__PROFILE} | sed 's/ //g')


_PitestOrig__PROFILE=$(cat <<EOF
        <profile>
            <id>opitestp</id>
            <activation>
                <property>
                    <name>pitest</name>
                </property>
            </activation>
            <build>
                <plugins>
                         <plugin>
                  <groupId>org.pitest</groupId>
                  <artifactId>pitest-maven</artifactId>
                  <version>1.3.1</version>
                  <configuration>
                        <targetClasses>
                                trgClasses
                        </targetClasses>
                        <targetTests>
                             <param>*</param>
                        </targetTests>
                        <mutators>
                                <mutator>CONSTRUCTOR_CALLS</mutator>
                                <mutator>NON_VOID_METHOD_CALLS</mutator>
                                <mutator>INLINE_CONSTS</mutator>
                                <mutator>REMOVE_CONDITIONALS</mutator>
                                <mutator>EXPERIMENTAL_MEMBER_VARIABLE</mutator>
                                <mutator>EXPERIMENTAL_SWITCH</mutator>
                                <mutator>CONDITIONALS_BOUNDARY</mutator>
                                <mutator>INCREMENTS</mutator>
                                <mutator>INVERT_NEGS</mutator>
                                <mutator>MATH</mutator>
                                <mutator>NEGATE_CONDITIONALS</mutator>
                                <mutator>RETURN_VALS</mutator>
                                <mutator>VOID_METHOD_CALLS</mutator>
                        </mutators>
                  </configuration>
           </plugin>
                </plugins>
            </build>
        </profile>
EOF
)
_PitestOrig__PROFILE=$(echo ${_PitestOrig__PROFILE} | sed 's/ //g')




function Pitest.integrate() {

        
        local repo="${1}"
        local replacement="${2}"
       # echo ${repo}
       # echo ${replacement}
        ( cd ${repo};
                for pom in $(find -name "pom.xml"); do
                        local has_profiles=$( grep 'profiles' ${pom} | wc -l )
                        if [ ${has_profiles} -eq 0 ]; then
                                sed -i 's%</project>%<profiles>'${replacement}'</profiles></project>%g' ${pom}
                        else
                                sed -i 's%</profiles>%'${replacement}'</profiles>%g' ${pom}
                        fi
                done
        )
}




for i in $PATH_TO_REVISIONS_DIR/*; do

if [ -d "$i" ]; then

  
  if [[ ! -e "$i/pitFLiRTSResult.txt" ]] && [[ -e "$i/flirtsTestClassesForPIT.txt" ]] && [[ -e "$i/startsTestClassesForPIT.txt" ]] && [[ -e "$i/ekstaziTestClassesForPIT.txt" ]]  && [[ -e "$i/adaptedClassesForPIT.txt" ]]; then
      
       adaptedClasses=$(cat "$i/adaptedClassesForPIT.txt")
 
       flirtsTargetTests=$(cat "$i/flirtsTestClassesForPIT.txt")
       flirtsProfile=$_PitestFLiRTS__PROFILE
       flirtsProfile=${flirtsProfile/trgClasses/$adaptedClasses}
       flirtsProfile=${flirtsProfile/trgTestClasses/$flirtsTargetTests}
       flirtsProfile=$(echo ${flirtsProfile} | sed 's/ //g')

       startsTargetTests=$(cat "$i/startsTestClassesForPIT.txt")
       startsProfile=$_PitestSTARTS__PROFILE
       startsProfile=${startsProfile/trgClasses/$adaptedClasses}
       startsProfile=${startsProfile/trgTestClasses/$startsTargetTests}
       startsProfile=$(echo ${startsProfile} | sed 's/ //g')

       ekstaziTargetTests=$(cat "$i/ekstaziTestClassesForPIT.txt")
       ekstaziProfile=$_PitestEkstazi__PROFILE
       ekstaziProfile=${ekstaziProfile/trgClasses/$adaptedClasses}
       ekstaziProfile=${ekstaziProfile/trgTestClasses/$ekstaziTargetTests}
       ekstaziProfile=$(echo ${ekstaziProfile} | sed 's/ //g')



       origProfile=$_PitestOrig__PROFILE
       origProfile=${origProfile/trgClasses/$adaptedClasses}
       origProfile=$(echo ${origProfile} | sed 's/ //g')

        if grep -q "<name>pitest</name>" "$i/pom.xml"; then
          echo "Running PIT with  $i"
        else
           echo "Integrating PIT and run it with  $i"
          (cd "$i/" &&  Pitest.integrate   "$(pwd)/"   "$flirtsProfile")  
          (cd "$i/" &&  Pitest.integrate   "$(pwd)/"   "$startsProfile") 
          (cd "$i/" &&  Pitest.integrate   "$(pwd)/"   "$ekstaziProfile")
          (cd "$i/" &&  Pitest.integrate   "$(pwd)/"   "$origProfile")
        fi
 
       (cd "$i"  && mvn clean &>/dev/null)
       (cd "$i"  && mvn compile &>/dev/null)
       (cd "$i"  && mvn test-compile &>/dev/null)


       (cd "$i"  && mvn org.pitest:pitest-maven:mutationCoverage -Pfpitestp 1> "$(pwd)/pitFLiRTSResult.txt" 2>> "$(pwd)/stderr.txt")


       (cd "$i"  && mvn org.pitest:pitest-maven:mutationCoverage -Pspitestp 1> "$(pwd)/pitSTARTSResult.txt" 2>> "$(pwd)/stderr.txt")


       (cd "$i" && mvn org.pitest:pitest-maven:mutationCoverage -Pepitestp 1> "$(pwd)/pitEkstaziResult.txt" 2>> "$(pwd)/stderr.txt")

       (cd "$i"  && mvn org.pitest:pitest-maven:mutationCoverage -Popitestp 1> "$(pwd)/pitAllTestsResult.txt" 2>> "$(pwd)/stderr.txt")       
   fi
 fi
done


