#!/bin/env bash

DIR=$(dirname "$(readlink -f "$0")")

PATH_TO_SHA_FILES=$1

PATH_TO_REVISIONS_DIR=$2

rm -f SafetyPrecisionReductionResults.txt

export CLASSPATH=$CLASSPATH:$DIR/lib/*

for rev in $PATH_TO_SHA_FILES/*; do

IFS=$'\n' read -d '' -r -a subject_Hashes < "$rev"

baseNamePrev=""
for ((index =0 ;  index<=${#subject_Hashes[@]}-1 ; index += 1));  do

    # Find the folder (of the code-level revision) that contains the SHA in its name
    revisionName="$(find "$PATH_TO_REVISIONS_DIR"  -maxdepth  1 -name "*${subject_Hashes[$index]}*")"
    revisionBaseName=$(basename "$revisionName")


  if [[ -d "$PATH_TO_REVISIONS_DIR/$revisionBaseName/" ]]; then


     if [[ -n "$baseNamePrev" && -e "$PATH_TO_REVISIONS_DIR/$revisionBaseName/AdaptedClassesSet.txt" ]]; then
             # echo "previous base name is  " $baseNamePrev;
              echo "current base name is  "  $revisionBaseName;

(cd "$DIR/" &&  java utils.SPRCalculator "$PATH_TO_REVISIONS_DIR/$revisionBaseName/RetestableTestClasses.txt"   "$PATH_TO_REVISIONS_DIR/$revisionBaseName/ReusableTestClasses.txt" "$PATH_TO_REVISIONS_DIR/$revisionBaseName/AdaptedClassesSet.txt" "$PATH_TO_REVISIONS_DIR/$baseNamePrev/.ekstazi" "$PATH_TO_REVISIONS_DIR/$revisionBaseName/.ekstazi" "$PATH_TO_REVISIONS_DIR/$baseNamePrev/.starts" "$PATH_TO_REVISIONS_DIR/$revisionBaseName/.starts" "$baseNamePrev to $revisionBaseName" "$PATH_TO_REVISIONS_DIR/$revisionBaseName/")

     fi

     baseNamePrev=$revisionBaseName;
 fi

done
done



