#!/usr/bin/env python3

from sys import argv
from os import listdir
from os.path import join, isfile
from subprocess import run
from re import compile
from multiprocessing import Pool
from xml.etree import ElementTree
from glob import iglob
from itertools import chain

REVISIONS = argv[1]
TOOLS = ['ekstazi', 'starts', 'flirts']
FILE = 'TestClassesForPIT.txt'
FILES = [t + FILE for t in TOOLS]
TIME = compile(r'\[INFO\] Total time: (.+)')
OUTPUT = 'testingTimes.txt'
POM = 'pom.xml'
POM_TESTS = './/{http://maven.apache.org/POM/4.0.0}plugin/{http://maven.apache.org/POM/4.0.0}configuration/{http://maven.apache.org/POM/4.0.0}includes/{http://maven.apache.org/POM/4.0.0}include'

def test(dir_name):
	rev_dir = join(REVISIONS, dir_name)
	output = join(rev_dir, OUTPUT)

	if True:#not isfile(output):
		tools_tests = []
		files = (join(rev_dir, f)for f in FILES)

		try:
			for f in files:
				with open(f, 'r') as f:
					tools_tests.append(f.read().split('\n'))
			pom = ElementTree.parse(join(rev_dir, POM))
		except FileNotFoundError:
			pass
		else:
			tools_tests = ((test.replace('<param>', '').replace('</param>', '') for test in tests if test) for tests in tools_tests)

			pom_tests = set(chain(*(iglob(join(rev_dir, 'src', 'test', test.text)) for test in pom.findall(POM_TESTS))))
			if pom_tests: tests = (pom_tests.intersection(tests) for tests in tools_tests)

			tests = (','.join(t) for t in tools_tests)

			def get_time(command):
				res = run(command, cwd=rev_dir, capture_output=True)
				if res.returncode:
					return ''
				else:
					return TIME.search(str(res.stdout, encoding='utf-8'))[1]

			times = [get_time(['mvn', '-Dtest='+t, 'test']) if t else '0 s' for t in tests]
			times.append(get_time(['mvn', 'test']))

			keys = TOOLS + ['all']
			lines = (k + ',' + t for k,t in zip(keys, times))
			lines = '\n'.join(lines) + '\n'

			with open(output, 'w') as output:
				output.write(lines)

			print('{} '.format(times), end='')

	print(rev_dir)

if __name__ == '__main__':
	revisions = listdir(REVISIONS)
	tot = len(revisions)
	with Pool() as p:
		for i, _ in enumerate(p.imap_unordered(test, revisions), 1):
			print('#################### {}% ####################'.format(int(i*100/tot)))
