#!/bin/env bash


PATH_TO_SHA_FILES=$1

PATH_TO_CLASSMODELS_DIR=$2

PATH_TO_REVISIONS_DIR=$3

FLIRTS2_HOME=$4

rm -f Output.txt

# loop through the text files in revSHAs directory 
for rev in $PATH_TO_SHA_FILES/*; do
  
# Read all the SHAs of the subjects into an array
IFS=$'\n' read -d '' -r -a subject_Hashes < "$rev"

# Loop through the SHAs
for ((index =0 ;  index<=${#subject_Hashes[@]}-1 ; index += 1));  do

    # Find the class model (.emx file) that contains the SHA in its name (the SHA is appended in the class diagram name)
    className="$(find "$PATH_TO_CLASSMODELS_DIR"  -name "*${subject_Hashes[$index]}*")"
    classNameBase=$(basename "$className")

    # Find the folder (of the code-level revision) that contains the SHA in its name
    revisionName="$(find "$PATH_TO_REVISIONS_DIR"  -maxdepth 1 -name "*${subject_Hashes[$index]}*")"
    revisionNameBase=$(basename "$revisionName")

  # If there is a revision with the same name as the class diagram
  if [[ -d "$PATH_TO_REVISIONS_DIR/$revisionNameBase/" ]]; then

     # If the revision is not the earliest revision of the subject
     if [ -e "$PATH_TO_REVISIONS_DIR/$revisionNameBase/AdaptedClassesSet.txt" ]; then

    echo "$revisionNameBase"
printf 'Flirts time: ' >> "$PATH_TO_REVISIONS_DIR/$revisionNameBase/times.txt"

(time "$FLIRTS2_HOME/flirts2.sh" "$PATH_TO_CLASSMODELS_DIR/$classNameBase" "$PATH_TO_REVISIONS_DIR/$revisionNameBase/DirectInvocationsFromTestClasses.txt"   "$PATH_TO_REVISIONS_DIR/$revisionNameBase/AdaptedClassesSet.txt" "$PATH_TO_REVISIONS_DIR/$revisionNameBase/") 2>&1 | awk '/real/ {print substr($2, 3, 5)}' >> "$PATH_TO_REVISIONS_DIR/$revisionNameBase/times.txt"

     fi
 fi


done

done
