#!/bin/env python3

from sys import argv
from os.path import join
from os import walk
from operator import itemgetter
from itertools import groupby, chain
from numpy import nanmean, nanmedian, nan
from re import search, compile
from filecmp import dircmp
from datetime import datetime as dt

revisionsPath = argv[1]
spr = argv[2]
ST = compile(r'\[INFO\] Total time: (.+) s')

def count_changed(dcmp):
	return len(dcmp.diff_files) + sum(count_changed(sub_dcmp) for sub_dcmp in dcmp.subdirs.values()) + sum(len(f) for right in dcmp.right_only for r, d, f in walk(right))

def parse_time(time):
	if ' min' in time:
		time = time.replace(' min', '')
		time = dt.strptime(time, '%M:%S')
		time = time.minute * 60 + time.second
	elif ' s' in time:
		time = time.replace(' s', '')
		time = float(time)
	else:
		time = nan
	return time

x = 0
with open(spr, 'r') as spr:
	revisions = []
	for rev in spr.readlines():
		x+=1
		#if x > 100: break
		rev = rev.split(',')[:-1]
		rev = rev[0].split(' to ') + rev[1:]
		rev = [v.strip() for v in rev]
		folder = join(revisionsPath, rev[1])
		prev_folder = join(revisionsPath, rev[0])
		subject = rev[1].split('_')[0]
		version = int(subject[subject.rfind('V')+1:])
		subject = subject[:subject.rfind('V')]
		rev = [v.split('_')[1] for v in rev[:2]] + rev[2:]
		rev = [subject, version] + rev
		with open(join(folder, 'times.txt'), 'r') as times,\
			open(join(folder, 'StartsResult.txt'), 'r') as starts_time,\
			open(join(folder, 'AdaptedClassesSet.txt'), 'r') as adapted:
			times = times.readlines()
			times = times[:2] + times[-1:]
			times = [t.split(': ')[1].strip() for t in times]
			times[1] = ST.search(starts_time.read())[1]
			rev += times
			rev.append(sum(1 for l in adapted.read().split('\n') if l))
			test_folder0 = join(prev_folder, 'src', 'test')
			test_folder1 = join(folder, 'src', 'test')
			rev.append(count_changed(dircmp(test_folder0, test_folder1)))
			try:
				with open(join(folder, 'testingTimes.txt'), 'r') as testingTimes:
					testingTimes = [parse_time(time.split(',')[1]) for time in testingTimes.read().split('\n')[:4]]
					testingTimes.insert(0, testingTimes.pop())
					if nan in testingTimes: testingTimes = [nan] * 4
			except FileNotFoundError:
				testingTimes = [nan] * 4
			rev += testingTimes
			try:
				with open(join(folder, 'pitAllTestsResult.txt'), 'r') as pit0,\
					open(join(folder, 'pitEkstaziResult.txt'), 'r') as pit1,\
					open(join(folder, 'pitSTARTSResult.txt'), 'r') as pit2,\
					open(join(folder, 'pitFLiRTSResult.txt'), 'r') as pit3:
					pits = [pit0, pit1, pit2, pit3]
					pits = [search(r'Generated [0-9]+ mutations Killed [0-9]+ \([0-9]+(?=%\))', v.read()) for v in pits]
					pits = [int(v.group(0).split('(')[1]) if v else nan for v in pits]
					pits = [0 if v is nan and rev[4+i]==0 else v for i, v in enumerate(pits)]
					if nan in pits: pits = [nan] * 4
					if any(v>pits[0] if v else False for v in pits):
						#print(rev[:2], pits)
						pits = [nan] * 4
			except FileNotFoundError:
				pits = [nan] * 4
			rev += pits
			rev = rev[:4] + [int(v) for v in rev[4:8]] + [float(v) for v in rev[8:18]] + rev[18:]
			rev = rev[:8] + [v/100.0 for v in rev[8:15]] + rev[15:]#-4] + [v/100.0 for v in rev[-4:]]
			revisions.append(rev)
			print(rev)
	revision = sorted(revisions, key=itemgetter(0))
	subjects = groupby(revisions, key=itemgetter(0))
	subjects = [[k,[v[4:] for v in g]] for k,g in subjects]
	subjects = [[k,len(g)] + list(chain(*zip(nanmean(g, axis=0), nanmedian(g, axis=0)))) for k,g in subjects]
	subjects = sorted(subjects, key=itemgetter(0))
	for s in subjects:
		s += [0]*4
		for r in revisions:
			if s[0] == r[0] and r[-1] is not nan:
				s[-4]+=1
				if r[-1] >= r[-4]: s[-3]+=1
				if r[-1] >= r[-3]: s[-2]+=1
				if r[-1] >= r[-2]: s[-1]+=1
	print(subjects)
	total = [v[4:]for v in revisions]
	total = [len(revisions)] + list(chain(*zip(nanmean(total, axis=0), nanmedian(total, axis=0))))
	print(total)
	with open('revisions.txt', 'w') as out:
		revisions = [[str(v) for v in rev] for rev in revisions]
		revisions = [','.join(rev) for rev in revisions]
		revisions = '\n'.join(revisions) + '\n'
		revisions = 'subject,n,hash1,hash2,tests_t,tests_e,tests_s,tests_f,sv_fe,pv_fe,sv_fs,pv_fs,r_e,r_s,r_f,time_e,time_s,time_f,adapted_classes,adapted_tests,all_tests_time,ekstazi_tests_time,starts_tests_time,flirts_tests_time,all_mutation_score,e_mutation_score,s_mutation_score,f_mutation_score\n' + revisions
		out.write(revisions)
	with open('subjects.txt', 'w') as out:
		subjects = [[str(v) for v in sub] for sub in subjects]
		subjects = [','.join(sub) for sub in subjects]
		subjects = '\n'.join(subjects) + '\n'
		subjects = 'subject,tot_rev,mean_tests_t,median_tests_t,mean_tests_e,median_tests_e,mean_tests_s,median_tests_s,mean_tests_f,median_tests_f,mean_sv_fe,median_sv_fe,mean_pv_fe,median_pv_fe,mean_sv_fs,median_sv_fs,mean_pv_fs,median_pv_fs,mean_r_e,median_r_e,mean_r_s,median_r_s,mean_r_f,median_r_f,mean_time_e,median_time_e,mean_time_s,median_time_s,mean_time_f,median_time_f,mean_adapted_classes,median_adapted_classes,mean_adapted_tests,median_adapted_tests,mean_all_tests_time,median_all_tests_time,mean_ekstazi_tests_time,median_ekstazi_tests_time,mean_starts_tests_time,median_starts_tests_time,mean_flirts_tests_time,median_flirts_tests_time,mean_all_mutation_score,median_all_mutation_score,mean_e_mutation_score,median_e_mutation_score,mean_s_mutation_score,median_s_mutation_score,mean_f_mutation_score,median_f_mutation_score,n_rev_pit_worked,f>=a,f>=e,f>=s\n' + subjects
		out.write(subjects)
	with open('total.txt', 'w') as out:
		total = [str(v) for v in total]
		total = ','.join(total) + '\n'
		total = 'tot_rev,mean_tests_t,median_tests_t,mean_tests_e,median_tests_e,mean_tests_s,median_tests_s,mean_tests_f,median_tests_f,mean_sv_fe,median_sv_fe,mean_pv_fe,median_pv_fe,mean_sv_fs,median_sv_fs,mean_pv_fs,median_pv_fs,mean_r_e,median_r_e,mean_r_s,median_r_s,mean_r_f,median_r_f,mean_time_e,median_time_e,mean_time_s,median_time_s,mean_time_f,median_time_f,mean_adapted_classes,median_adapted_classes,mean_adapted_tests,median_adapted_tests,mean_all_tests_time,median_all_tests_time,mean_ekstazi_tests_time,median_ekstazi_tests_time,mean_starts_tests_time,median_starts_tests_time,mean_flirts_tests_time,median_flirts_tests_time,mean_all_mutation_score,median_alll_mutation_score,mean_e_mutation_score,median_e_mutation_score,mean_s_mutation_score,median_s_mutation_score,mean_f_mutation_score,median_f_mutation_score\n' + total
		out.write(total)
