#!/bin/env bash

export JAVA_HOME='/usr/lib/jvm/java-1.8.0-openjdk-1.8.0.242.b08-0.fc30.x86_64/'

ROOTDIR=$(dirname "$(readlink -f "$0")")  # the directory that contains this script file and the folders: repositories, revisions, and workingDir

PATH_TO_SHA_FILES=$1

REPOSITORIES_DIR="$ROOTDIR/repositories"
REVISIONS_DIR="$ROOTDIR/revisions"
WORKING_DIR="$ROOTDIR/workingDir"
STARTS_DIFF="$ROOTDIR/startsDiff"
LOG="$ROOTDIR/log.txt"

rm -rf "$REVISIONS_DIR"
rm -rf "$REPOSITORIES_DIR"
rm -rf "$WORKING_DIR"
rm -rf "$STARTS_DIFF"
rm -rm "$LOG"

mkdir "$REVISIONS_DIR" # contains the cloned repositories
mkdir "$REPOSITORIES_DIR"    # contains the checked-out revisions of each subject
mkdir "$WORKING_DIR"   # working directory to run Ekstazi and STARTS 

# add bcel to the class path 
export CLASSPATH=$CLASSPATH:$ROOTDIR/lib/*

# Ekstazi Plugin
_Ekstazi__PROFILE=$(cat <<EOF
        <profile>
            <id>ekstazip</id>
            <activation>
                <property>
                    <name>ekstazi</name>
                </property>
            </activation>
            <build>
                <plugins>
                  <plugin>
                      <groupId>org.ekstazi</groupId>
                      <artifactId>ekstazi-maven-plugin</artifactId>
                      <version>5.2.0</version>
                      <executions>
                          <execution>
                              <id>ekstazi</id>
                              <goals>
                                  <goal>select</goal>
                              </goals>
                          </execution>
                      </executions>
                  </plugin>
<!-- EKSTAZI -->
                </plugins>
            </build>
        </profile>
EOF
)
_Ekstazi__PROFILE=$(echo ${_Ekstazi__PROFILE} | sed 's/ //g')

# Integrating Ekstazi Plugin in pom.xml
function Ekstazi.integrate() {
        local repo="${1}"; shift
        #echo "repo is" ${repo}
        ( cd ${repo};
                for pom in $(find -name "pom.xml"); do
                        local has_profiles=$( grep 'profiles' ${pom} | wc -l )
                        if [ ${has_profiles} -eq 0 ]; then
                                sed -i 'sX</project>X<profiles>'${_Ekstazi__PROFILE}'</profiles></project>Xg' ${pom}
                        else
                                sed -i 'sX</profiles>X'${_Ekstazi__PROFILE}'</profiles>Xg' ${pom}
                        fi
                done
        )



        #project.xml
        ( cd ${repo};
                for proj in $(find -name "project.xml"); do
                        local has_profiles=$( grep 'profiles' ${proj} | wc -l )
                        if [ ${has_profiles} -eq 0 ]; then
                                sed -i 'sX</project>X<profiles>'${_Ekstazi__PROFILE}'</profiles></project>Xg' ${proj}
                        else
                                sed -i 'sX</profiles>X'${_Ekstazi__PROFILE}'</profiles>Xg' ${proj}
                        fi
                done
        )
}








# STARTS Plugin

_Starts__PROFILE=$(cat <<EOF
        <profile>
            <id>startsp</id>
            <activation>
                <property>
                    <name>starts</name>
                </property>
            </activation>
            <build>
                <plugins>
                         <plugin>
                                <groupId>edu.illinois</groupId>
                                <artifactId>starts-maven-plugin</artifactId>
                                <version>1.3</version>
                         </plugin>
                </plugins>
            </build>
        </profile>
EOF
)
_Starts__PROFILE=$(echo ${_Starts__PROFILE} | sed 's/ //g')

# Integrating STARTS Plugin in pom.xml
function Starts.integrate() {
        local repo="${1}"; shift
        ( cd ${repo};
                for pom in $(find -name "pom.xml"); do
                        local has_profiles=$( grep 'profiles' ${pom} | wc -l )
                        if [ ${has_profiles} -eq 0 ]; then
                                sed -i 'sX</project>X<profiles>'${_Starts__PROFILE}'</profiles></project>Xg' ${pom}
                        else
                                sed -i 'sX</profiles>X'${_Starts__PROFILE}'</profiles>Xg' ${pom}
                        fi
                done
        )
}





IFS=$'\n' read -d '' -r -a repos < "$ROOTDIR/repositories.txt"
echo "number of GIT repositories is: "  ${#repos[@]}

echo "git clone all repositories inside the $REPOSITORIES_DIR"
for ((numRepo=0;  numRepo < ${#repos[@]} ; numRepo += 1)); do
        (cd "$REPOSITORIES_DIR" && git clone "${repos[$numRepo]}")
done

# iterate through the cloned repositories to download all of their revisions
for i in $REPOSITORIES_DIR/*; do
if [ -d "$i" ]; then
      subjectName=$(basename $i)
      # copy the the SHA file to the corresponding subject directory
      cp "$PATH_TO_SHA_FILES/$subjectName.txt"  "$i/"

      # read the subject hashes to an array
      IFS=$'\n' read -d '' -r -a subject_Hashes < "$i/$subjectName.txt"

      #echo ${#subject_Hashes[@]}

      previous_hash=""
      current_hash=""

      rm -rf "$STARTS_DIFF"
      mkdir "$STARTS_DIFF"

      for ((num=0;  num<${#subject_Hashes[@]} ; num += 1))
       do
          current_hash="${subject_Hashes[$num]}"  # store the current hash
	  echo "$subjectName $num $current_hash" >> "$LOG"

          (cd "$i" && git checkout "$current_hash") # check out the current revision
          (cp -r -f -a "$i/."  "$WORKING_DIR/") # copy the current revision to the working directory, where Ekstazi and STARTS will be applied.
          (cp -r -f -a "$i/."  "$STARTS_DIFF/")
          # run Ekstazi with the current revision
          (cp -f -a "$ROOTDIR/.ekstazirc" "$WORKING_DIR/")
          (cd "$WORKING_DIR" && Ekstazi.integrate "$WORKING_DIR/")
          (cd "$WORKING_DIR" && mvn ekstazi:select -Pekstazip &> "$WORKING_DIR/EkstaziSelect.txt")
          (cd "$WORKING_DIR" && mvn ekstazi:ekstazi -Pekstazip &> "$WORKING_DIR/EkstaziResult.txt")
          # run STARTS with the current revision
          (cd "$WORKING_DIR" && mvn clean &> "$WORKING_DIR/cleanResult.txt")
          (cd "$WORKING_DIR" && Starts.integrate "$WORKING_DIR/")
	  (cd "$WORKING_DIR" && mvn starts:select -DupdateSelectChecksums=true -DdepFormat=CLZ -Pstartsp &> "$WORKING_DIR/StartsResult.txt")
          (cd "$STARTS_DIFF" && mvn clean &> /dev/null)
          (cd "$STARTS_DIFF" && Starts.integrate "$STARTS_DIFF/")
          (cd "$STARTS_DIFF" && mvn starts:diff -Pstartsp &> "$WORKING_DIR/StartsDiff.txt")
	  (cd "$STARTS_DIFF"  && mvn starts:run -Pstartsp &> "$WORKING_DIR/StartsRun.txt")
          (cd "$WORKING_DIR" && printf 'Ekstazi time: ' > times.txt)
          (cd "$WORKING_DIR" && awk '/time:/ {print $4}' EkstaziSelect.txt >> times.txt)
          (cd "$WORKING_DIR" && printf 'Starts time: ' >> times.txt)
          (cd "$WORKING_DIR" && awk '/time:/ {print $4}' StartsResult.txt >> times.txt)
          if grep -q "BUILD SUCCESS" "$WORKING_DIR/EkstaziResult.txt"; then
            if grep -q "BUILD SUCCESS" "$WORKING_DIR/StartsResult.txt"; then
                   # record direct invocations of test classes                                  
                   (cd "$ROOTDIR" && java utils.DirectInvocationsRecorder "$WORKING_DIR/")
                      
                   if [[ -n "$previous_hash" ]]; then
                      # process Git diff result to convert it to the format that is readable by FLiRTS 2
                     (cd "$ROOTDIR" && ./lib/formatStartsDiff.py "$WORKING_DIR/StartsDiff.txt" "$WORKING_DIR/AdaptedClassesSet.txt")
                   fi                   
                     # create a folder to store the current revision in it                                     
                     mkdir "$REVISIONS_DIR/${subjectName}V${num}_${current_hash}"
                     # copy the current revision to the new folder 
                     cp -r -f -a "$WORKING_DIR/."  "$REVISIONS_DIR/${subjectName}V${num}_${current_hash}"
            else
                   echo "Running STARTS with the revision $i did not produce BUILD SUCCESS, so this revision is discarded"
            fi
         else
            echo "Running Ekstazi with the revision $i did not produce BUILD SUCCESS, so this revision is discarded"
         fi

        previous_hash="$current_hash"
       (cd "$WORKING_DIR" && rm -r -f {*,.*} &>/dev/null)
       (cd "$STARTS_DIFF" && git ls-files -z | xargs -0 rm -f)
	
  done       

fi
done

rm -rf "$STARTS_DIFF"
