# 1. Viewing Experiments Folder

Contents of the Experiments folder
* downloadRevisions folder. Contains the materials needed to download the code-level revisions, and for each revision run Ekstazi and STARTS, and record the direct invocations of the test and obtain the adapted class names.
 
* runFLiRTS2 folder. Contains the script to run FLiRTS 2 with the revisions of the subjects.

* calculateSPR folder. Contains the script to calculate safety violations, precision violations, and test suite reductions for the revisions.

* pit folder. Contains the script to run the PIT mutation testing tool (http://pitest.org/quickstart/maven/) with each code-level revision.

* revisionsSHAs folder. Contains 21 text files that store all the revision SHAs (hashes) used in our experiment. Each text file stores the SHAs of one of the 21 subjects.

* timeTests folder. Contains a python script to execute and time the test cases selected by each tool.

* finalizaData folder. Contains a python script to aggregate all the data from the experiments, computing means and medians and generating csv files.

# 2. Downloading Revisions

The downloadRevisions folder contains the following

* repositories.txt. Contains the GitHub URLs of the subjects that were used in the experiment.

* download.sh. Check out the revisions used in our experiment. For each downloaded revision, the script runs Ekstazi (http://ekstazi.org/) and STARTS (https://github.com/TestingResearchIllinois/starts) with it, records the direct invocations of the test classes in a text file, and records the names of the adapted classes in a text file.

* .ekstazirc file. Used by download.sh while running Ekstazi.

* lib folder. Contains utils.jar that we implemented. This jar file is used to obtain the following information from each downloaded code-level revision: 
 * the direct invocations from the test classes.
 * the names of the adapted classes (by reading the Git Diff command results).


Instructions for running download.sh 

* The files repositories.txt,  .ekstazirc,  and the lib folder must be in the same source folder of the download.sh script file.

* Download bcel-x.y.jar from (https://commons.apache.org/proper/commons-bcel/download_bcel.cgi) and save it inside the lib folder. The bcel-x.y.jar file is used by utils.jar to record the direct invocations from test classes.
 
* Run the command ./download.sh <"path to revisionsSHAs/">. 

The script will checkout the code-level revisions of the subject programs based on the provided SHAs (the SHA files inside the revisionsSHAs folder). The downloaded revisions are stored in the generated "revisions/" folder inside the "downloadRevisions" folder.

After downloading each revision, the script does the following: 

 * Adds Ekstazi and STARTS plugins to the revision (inside the pom.xml file).

 * Runs Ekstazi and STARTS with the revision, which produces for each revision the .ekstazi and .starts folders that store the test class dependencies. Each test class contains a .clz file inside the .ekstazi and .starts folders. These .clz files are used in a later step to get the names of the test classes selected by Ekstazi and STARTS.

 * Stores the direct invocations from test classes in a text file called DirectInvocationsFromTestClasses.txt.

 * Stores the names of the adapted classes in a text file called AdaptedClassesSet.txt.

 The folder of each revision contains the files DirectInvocationsFromTestClasses.txt and AdaptedClassesSet.txt.  


# 3. Running FLiRTS 2 with the Downloaded Revisions

Folder runFLiRTS2 contains runFLiRTS2.sh, which runs FLiRTS 2 with the revisions specified in the revisionsSHAs folder. To run the script, do the following:

 * Ensure that FLiRTS 2 is downloaded and installed as described in **Section 1. Getting FLiRTS 2**.
 * Download the UML class diagrams provided in the website (http://www.cs.colostate.edu/flirts/).  
 * Run the command:
 ./runFLiRTS2.sh <"path to revisionsSHAs/"> <"path to the folder that contains the class diagram files"> <"path to the folder that contains the code-level revisions"> 

The script runFLiRTS2.sh runs FLiRTS 2 with each revision. FLiRTS 2 stores inside the folder of each revision the files RetestableTestClasses.txt and ReusableTestClasses.txt.


# 4. Calculating Safety and Precision Violations, and Test Suite Reductions

The calculateSPR folder contains

* lib folder. Contains the utils.jar file, which also has a class to calculate the safety and precision violations of FLiRTS 2 with respect to Ekstazi and STARTS, and calculates the test suite reduction.

* calculateSPR.sh. Uses utils.jar to calculate the safety and precision violations, and test suite reduction for each revision. To run the script, do the following:

  * Make sure that the lib folder that contains utils.jar is in the same source folder of calculateSPR.sh.
  * Run the command   ./calculateSPR.sh <"path to revisionsSHAs/"> <"path to the folder that contains the code-level revisions">

The script reads from each folder of a code-level revision the following: 
  * RetestableTestClasses.txt
  * ReusableTestClasses.txt
  * DirectInvocationsFromTestClasses.txt
  * AdaptedClassesSet.txt
  * .ekstazi and .starts (reads them from the folders of the current revision and its previous revision)

Running calculateSPR.sh outputs SafetyPrecisionReductionResults.txt file inside the same folder as the calculateSPR.sh script. This file stores the safety and precision violations, and test suite reduction results for each revision. Each line in the file contains the following comma-separated information:
* Hashes of the revisions pair
* Number of baseline test classes
* Number of test classes selected by Ekstazi
* Number of test classes selected by STARTS
* Number of test classes selected by FLiRTS 2
* Safety of FLiRTS 2 with respect to Ekstazi
* Precision of FLiRTS 2 with respect to Ekstazi
* Safety of FLiRTS 2 with respect to STARTS
* Precision of FLiRTS 2 with respect to STARTS
* Test suite reduction achieved by Ekstazi
* Test suite reduction achieved by STARTS
* Test suite reduction achieved by FLiRTS 2 

Running runFLiRTS2.sh also prepares files to be used by the PIT tool for evaluating fault detection ability. The following files are created inside the folder of each code-level revision:
 
 * ekstaziTestClassesForPIT.txt. Lists the names of test classes selected by Ekstazi.

 * startsTestClassesForPIT.txt. Lists the names of test classes selected by STARTS.

 * adaptedClassesForPIT.txt. Lists the names of the adapted classes.

 * flirtsTestClassesForPIT.txt. Lists the names of test classes selected by FLiRTS 2.

Each of these files contains the fully qualified names of the classes in the format that is readable by the PIT tool when it is launched from maven (http://pitest.org/quickstart/maven/). Each class name starts with <"param"> and ends with <"/param">. These files will be used by the pit.sh script that is described in the following part of the readme file. 


# 5. Running PIT with the code-level revisions

The pit folder contains the following:

* pit.sh. Adds the PIT plugin to each code-level revision (inside the pom.xml file), and runs PIT with the full test suite, the test classes selected by FLiRTS 2, Ekstazi, and STARTS. The script reads the files flirtsTestClassesForPIT.txt, ekstaziTestClassesForPIT.txt, startsTestClassesForPIT.txt, and adaptedClassesForPIT.txt from the folder of each code-level revision.

To run the script, use the command

./pit.sh <"path to the folder that contains the code-level revisions">

Running pit.sh with each code-level revision outputs the following files that store the mutation testing results achieved by the test classes selected by FLiRTS 2, Ekstazi, STARTS, and the full test suites:

 * pitFLiRTSResult.txt.

 * pitEkstaziResult.txt.

 * pitSTARTSResult.txt. 

 * pitAllTestsResult.txt.

These four files are created for each code-level revision and stored inside its folder. Note that PIT may not work for all the revisions because of JUnit version compatibility issues.


#6. Timing test execution

The timeTests folder contains the script timeTests.py, which executes and times the test cases selected by each tool. It then saves the results in a file called testingTimes.txt located in each revision folder.
To execute the script run: 
./timeTests.py <"path to the folder that contains the code-level revisions"> 


# 7. Getting all the data

The finalizeData folder contains the script finalizeData.py, which collects all the data from all the revisions and computes averages and medians. It then stores the results into 3 csv files:
* revisions.txt,
* subjects.txt
* total.txt.

To execute the script run: 
./finalizeData.py <"path to the folder that contains the code-level revisions"> <"path to the calculateSPR folder"> 
