/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashSet;
import java.util.Scanner;

public class GitDiffOutputProcessor {
    HashSet<String> adaptedClassesSet = new HashSet();

    public void readAdaptedClasses(File adaptedClassesFile) throws Exception {
        String sCurrentLine = "";
        boolean modifiedClasses = false;
        BufferedReader reader = new BufferedReader(new FileReader(adaptedClassesFile));
        Scanner s = new Scanner(sCurrentLine);
        while ((sCurrentLine = reader.readLine()) != null) {
            if (sCurrentLine.contains("<modified classes>")) {
                modifiedClasses = true;
                continue;
            }
            if (!modifiedClasses || !(sCurrentLine = sCurrentLine.replace("/", ".")).contains(".java")) continue;
            sCurrentLine = sCurrentLine.replace("src.main.java.", "");
            sCurrentLine = sCurrentLine.replace("src.test.java.", "");
            sCurrentLine = sCurrentLine.replace("src.main.", "");
            sCurrentLine = sCurrentLine.replace("src.java.", "");
            sCurrentLine = sCurrentLine.replace("src.test.", "");
            sCurrentLine = sCurrentLine.replace(".java.", "");
            sCurrentLine = sCurrentLine.replace(".java", "");
            sCurrentLine = sCurrentLine.trim();
            this.adaptedClassesSet.add(sCurrentLine);
        }
        reader.close();
        try {
            FileWriter file = new FileWriter(String.valueOf(adaptedClassesFile.getParent()) + "/AdaptedClassesSet.txt", false);
            for (String tc : this.adaptedClassesSet) {
                file.write(tc);
                file.write("\n");
            }
            file.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) throws Exception {
        String path = args[0];
        File file = new File(path);
        GitDiffOutputProcessor obj = new GitDiffOutputProcessor();
        obj.readAdaptedClasses(file);
    }
}

