/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.apache.bcel.classfile.ClassFormatException;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.ConstantMethodref;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.DescendingVisitor;
import org.apache.bcel.classfile.EmptyVisitor;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Visitor;

public class DirectInvocationsRecorder
extends EmptyVisitor {
    private JavaClass javaClass;
    private static String className;
    private static ArrayList<String> testCaseToClass;

    static {
        testCaseToClass = new ArrayList();
    }

    public DirectInvocationsRecorder(JavaClass javaClass) {
        this.javaClass = javaClass;
    }

    public void visitConstantMethodref(ConstantMethodref obj) {
        ConstantPool cp = this.javaClass.getConstantPool();
        String bytes = obj.getClass(cp);
        testCaseToClass.add(String.valueOf(className) + " --> " + bytes.toString());
    }

    public static void processFiles(File[] files) throws Exception {
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                DirectInvocationsRecorder.processFiles(file.listFiles());
            } else if (file.getName().contains(".class")) {
                DirectInvocationsRecorder.visitMethodCalls(file);
            }
            ++n2;
        }
    }

    private static void visitMethodCalls(File file) throws ClassFormatException, IOException {
        FileInputStream is = new FileInputStream(file);
        ClassParser parser = new ClassParser((InputStream)is, file.getName());
        JavaClass javaClass = parser.parse();
        className = javaClass.getClassName();
        if (className.toLowerCase().contains("test")) {
            DirectInvocationsRecorder visitor = new DirectInvocationsRecorder(javaClass);
            DescendingVisitor classWalker = new DescendingVisitor(javaClass, (Visitor)visitor);
            classWalker.visit();
        }
    }

    public static void main(String[] args) throws Exception {
        String path = args[0];
        File[] f = new File(String.valueOf(path) + "/target").listFiles();
        DirectInvocationsRecorder.processFiles(f);
        try {
            FileWriter file = new FileWriter(String.valueOf(path) + "/DirectInvocationsFromTestClasses.txt");
            for (String str : testCaseToClass) {
                file.write(str);
                file.write("\n");
            }
            file.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        testCaseToClass.clear();
    }
}

