/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.math.BigDecimal;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.HashSet;
import java.util.Scanner;

public class SPRCalculator {
    protected HashSet<String> fliRTSReusableTestCases = new HashSet();
    protected HashSet<String> fliRTSRetestableTestCases = new HashSet();
    protected HashSet<String> allTestCases = new HashSet();
    protected HashSet<String> startsReTestableTestCases = new HashSet();
    protected HashSet<String> ekstaziReTestableTestCases = new HashSet();
    protected HashSet<String> adaptedClasses = new HashSet();

    protected void compute(String verionNames, String dir) {
        verionNames = String.valueOf(verionNames) + "  ,  " + this.allTestCases.size() + " , " + this.ekstaziReTestableTestCases.size() + " , " + this.startsReTestableTestCases.size() + " , " + this.fliRTSRetestableTestCases.size() + " , ";
        double flirtSafetyEkstazi = this.calculateSafetyWithRespectToEkstazi(this.fliRTSRetestableTestCases);
        double flirtPrecisionEkstazi = this.calculatePrecisionWithRespectToEkstazi(this.fliRTSRetestableTestCases);
        double flirtSafetyStarts = this.calculateSafetyWithRespectToSTARTS(this.fliRTSRetestableTestCases);
        double flirtPrecisionStarts = this.calculatePrecisionWithRespectToSTARTS(this.fliRTSRetestableTestCases);
        double ekstaziReduction = (double)(this.allTestCases.size() - this.ekstaziReTestableTestCases.size()) / (double)this.allTestCases.size() * 100.0;
        double startsReduction = (double)(this.allTestCases.size() - this.startsReTestableTestCases.size()) / (double)this.allTestCases.size() * 100.0;
        double flirtsReduction = (double)(this.allTestCases.size() - this.fliRTSRetestableTestCases.size()) / (double)this.allTestCases.size() * 100.0;
        verionNames = String.valueOf(verionNames) + new BigDecimal(String.valueOf(flirtSafetyEkstazi)).setScale(2, 3) + " , " + new BigDecimal(String.valueOf(flirtPrecisionEkstazi)).setScale(2, 3) + " , " + new BigDecimal(String.valueOf(flirtSafetyStarts)).setScale(2, 3) + " , " + new BigDecimal(String.valueOf(flirtPrecisionStarts)).setScale(2, 3) + " , " + new BigDecimal(String.valueOf(ekstaziReduction)).setScale(2, 3) + " , " + new BigDecimal(String.valueOf(startsReduction)).setScale(2, 3) + " , " + new BigDecimal(String.valueOf(flirtsReduction)).setScale(2, 3) + " , ";
        try {
            FileWriter file = new FileWriter("SafetyPrecisionReductionResults.txt", true);
            file.write(verionNames);
            file.write("\n");
            file.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.writeClassNamesForPitest(this.fliRTSRetestableTestCases, String.valueOf(dir) + "/flirtsTestClassesForPIT.txt");
        this.writeClassNamesForPitest(this.ekstaziReTestableTestCases, String.valueOf(dir) + "/ekstaziTestClassesForPIT.txt");
        this.writeClassNamesForPitest(this.startsReTestableTestCases, String.valueOf(dir) + "/startsTestClassesForPIT.txt");
        this.writeClassNamesForPitest(this.adaptedClasses, String.valueOf(dir) + "/adaptedClassesForPIT.txt");
    }

    public HashSet<String> compareCLZFilesInSTARTSDirs(String file1, String file2) throws Exception {
        File[] files2;
        File[] fileArray = files2 = new File(file2.toString()).listFiles();
        int n = files2.length;
        int n2 = 0;
        while (n2 < n) {
            File f2 = fileArray[n2];
            if (f2.getName().contains(".clz")) {
                File f1 = new File(String.valueOf(file1) + "/" + f2.getName());
                if (f1.exists()) {
                    boolean fileIsDifferent = SPRCalculator.compareFiles(f1.getAbsolutePath(), f2.getAbsolutePath());
                    if (!fileIsDifferent && this.allTestCases.contains(f2.getName().replace(".clz", ""))) {
                        this.startsReTestableTestCases.add(f2.getName().replace(".clz", ""));
                    }
                } else if (this.allTestCases.contains(f2.getName().replace(".clz", ""))) {
                    this.startsReTestableTestCases.add(f2.getName().replace(".clz", ""));
                }
            }
            ++n2;
        }
        return this.startsReTestableTestCases;
    }

    public HashSet<String> compareCLZFilesInEkstaziDirs(String file1, String file2) throws Exception {
        File[] files2;
        File[] fileArray = files2 = new File(file2.toString()).listFiles();
        int n = files2.length;
        int n2 = 0;
        while (n2 < n) {
            File f2 = fileArray[n2];
            if (f2.getName().contains(".clz")) {
                File f1 = new File(String.valueOf(file1) + "/" + f2.getName());
                if (f1.exists()) {
                    boolean fileIsDifferent = SPRCalculator.compareFiles(f1.getAbsolutePath(), f2.getAbsolutePath());
                    if (!fileIsDifferent && this.allTestCases.contains(f2.getName().replace(".clz", ""))) {
                        this.ekstaziReTestableTestCases.add(f2.getName().replace(".clz", ""));
                    }
                } else if (this.allTestCases.contains(f2.getName().replace(".clz", ""))) {
                    this.ekstaziReTestableTestCases.add(f2.getName().replace(".clz", ""));
                }
            }
            ++n2;
        }
        return this.ekstaziReTestableTestCases;
    }

    public static boolean compareFiles(String f1, String f2) throws IOException {
        long start = System.nanoTime();
        FileChannel ch1 = new RandomAccessFile(f1, "r").getChannel();
        FileChannel ch2 = new RandomAccessFile(f2, "r").getChannel();
        if (ch1.size() != ch2.size()) {
            return false;
        }
        long size = ch1.size();
        MappedByteBuffer m1 = ch1.map(FileChannel.MapMode.READ_ONLY, 0L, size);
        MappedByteBuffer m2 = ch2.map(FileChannel.MapMode.READ_ONLY, 0L, size);
        int pos = 0;
        while ((long)pos < size) {
            if (m1.get(pos) != m2.get(pos)) {
                return false;
            }
            ++pos;
        }
        return true;
    }

    protected void writeClassNamesForPitest(HashSet<String> set, String fileName) {
        StringBuilder allClassNames = new StringBuilder();
        for (String st : set) {
            allClassNames.append("<param>").append(st).append("</param>").append("\n");
        }
        try {
            FileWriter file = new FileWriter(fileName, false);
            file.write(allClassNames.toString());
            file.write("\n");
            file.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected double calculateSafetyWithRespectToEkstazi(HashSet<String> fliRTS_RetestableTestCases) {
        HashSet<String> testCasesSelectedByEkstaziButNotByFLiRTS = new HashSet<String>();
        testCasesSelectedByEkstaziButNotByFLiRTS.addAll(this.ekstaziReTestableTestCases);
        testCasesSelectedByEkstaziButNotByFLiRTS.removeAll(fliRTS_RetestableTestCases);
        double flirtSafety = 0.0;
        HashSet<String> unionOfEkstaziFLiRTS = new HashSet<String>();
        unionOfEkstaziFLiRTS.addAll(this.ekstaziReTestableTestCases);
        unionOfEkstaziFLiRTS.addAll(fliRTS_RetestableTestCases);
        flirtSafety = (double)testCasesSelectedByEkstaziButNotByFLiRTS.size() / (double)unionOfEkstaziFLiRTS.size() * 100.0;
        if (Double.isNaN(flirtSafety)) {
            flirtSafety = 0.0;
        }
        return flirtSafety;
    }

    protected double calculateSafetyWithRespectToSTARTS(HashSet<String> fliRTS_RetestableTestCases) {
        HashSet<String> testCasesSelectedBySTARTSButNotByFLiRTS = new HashSet<String>();
        testCasesSelectedBySTARTSButNotByFLiRTS.addAll(this.startsReTestableTestCases);
        testCasesSelectedBySTARTSButNotByFLiRTS.removeAll(fliRTS_RetestableTestCases);
        double flirtSafety = 0.0;
        HashSet<String> unionOfSTARTSFLiRTS = new HashSet<String>();
        unionOfSTARTSFLiRTS.addAll(this.startsReTestableTestCases);
        unionOfSTARTSFLiRTS.addAll(fliRTS_RetestableTestCases);
        flirtSafety = (double)testCasesSelectedBySTARTSButNotByFLiRTS.size() / (double)unionOfSTARTSFLiRTS.size() * 100.0;
        if (Double.isNaN(flirtSafety)) {
            flirtSafety = 0.0;
        }
        return flirtSafety;
    }

    protected double calculatePrecisionWithRespectToEkstazi(HashSet<String> fliRTS_RetestableTestCases) {
        HashSet<String> testCasesSelectedByFLiRTSButNotByEkstazi = new HashSet<String>();
        testCasesSelectedByFLiRTSButNotByEkstazi.addAll(fliRTS_RetestableTestCases);
        testCasesSelectedByFLiRTSButNotByEkstazi.removeAll(this.ekstaziReTestableTestCases);
        double flirtPrecision = 0.0;
        HashSet<String> unionOfEkstaziFLiRTS = new HashSet<String>();
        unionOfEkstaziFLiRTS.addAll(this.ekstaziReTestableTestCases);
        unionOfEkstaziFLiRTS.addAll(fliRTS_RetestableTestCases);
        flirtPrecision = (double)testCasesSelectedByFLiRTSButNotByEkstazi.size() / (double)unionOfEkstaziFLiRTS.size() * 100.0;
        if (Double.isNaN(flirtPrecision)) {
            flirtPrecision = 0.0;
        }
        return flirtPrecision;
    }

    protected double calculatePrecisionWithRespectToSTARTS(HashSet<String> fliRTS_RetestableTestCases) {
        HashSet<String> testCasesSelectedByFLiRTSButNotBySTARTS = new HashSet<String>();
        testCasesSelectedByFLiRTSButNotBySTARTS.addAll(fliRTS_RetestableTestCases);
        testCasesSelectedByFLiRTSButNotBySTARTS.removeAll(this.startsReTestableTestCases);
        double flirtPrecision = 0.0;
        HashSet<String> unionOfSTARTSFLiRTS = new HashSet<String>();
        unionOfSTARTSFLiRTS.addAll(this.startsReTestableTestCases);
        unionOfSTARTSFLiRTS.addAll(fliRTS_RetestableTestCases);
        flirtPrecision = (double)testCasesSelectedByFLiRTSButNotBySTARTS.size() / (double)unionOfSTARTSFLiRTS.size() * 100.0;
        if (Double.isNaN(flirtPrecision)) {
            flirtPrecision = 0.0;
        }
        return flirtPrecision;
    }

    public void readEkstaziResults(String ekstazifile) throws IOException {
        String sCurrentLine = "";
        BufferedReader reader = new BufferedReader(new FileReader(ekstazifile));
        Scanner s = new Scanner(sCurrentLine);
        String foldersDelim = "[/]+";
        String clzDelim = ".clz";
        while ((sCurrentLine = reader.readLine()) != null) {
            String[] tkns;
            String[] stringArray = tkns = sCurrentLine.split(foldersDelim);
            int n = tkns.length;
            int n2 = 0;
            while (n2 < n) {
                String tc = stringArray[n2];
                if (tc.contains(".clz")) {
                    String[] tcParts = tc.split(clzDelim);
                    tc = tcParts[0];
                    tc = tc.replace(".ekstazi:", "");
                    if (this.allTestCases.contains(tc = tc.trim())) {
                        this.ekstaziReTestableTestCases.add(tc);
                    }
                }
                ++n2;
            }
        }
        reader.close();
    }

    public void readStartsResults(String startsFile) throws IOException {
        String sCurrentLine = "";
        BufferedReader reader = new BufferedReader(new FileReader(startsFile));
        Scanner s = new Scanner(sCurrentLine);
        String foldersDelim = "[/]+";
        String clzDelim = ".clz";
        while ((sCurrentLine = reader.readLine()) != null) {
            String[] tkns;
            String[] stringArray = tkns = sCurrentLine.split(foldersDelim);
            int n = tkns.length;
            int n2 = 0;
            while (n2 < n) {
                String tc = stringArray[n2];
                if (tc.contains(".clz")) {
                    String[] tcParts = tc.split(clzDelim);
                    tc = tcParts[0];
                    tc = tc.replace(".starts:", "");
                    if (this.allTestCases.contains(tc = tc.trim())) {
                        this.startsReTestableTestCases.add(tc);
                    }
                }
                ++n2;
            }
        }
        reader.close();
    }

    private void readFLiRTS2ReusableTestCases(String allTestClasses) throws IOException {
        String sCurrentLine = "";
        BufferedReader reader = new BufferedReader(new FileReader(allTestClasses));
        Scanner s = new Scanner(sCurrentLine);
        while ((sCurrentLine = reader.readLine()) != null) {
            sCurrentLine = sCurrentLine.trim();
            this.fliRTSReusableTestCases.add(sCurrentLine);
        }
        reader.close();
    }

    private void readAdaptedClasses(String adaptedClassesFile) throws IOException {
        String sCurrentLine = "";
        BufferedReader reader = new BufferedReader(new FileReader(adaptedClassesFile));
        Scanner s = new Scanner(sCurrentLine);
        while ((sCurrentLine = reader.readLine()) != null) {
            sCurrentLine = sCurrentLine.trim();
            this.adaptedClasses.add(sCurrentLine);
        }
        reader.close();
    }

    private void readFLiRTS2RetestableTestCases(String flirtsFile) throws IOException {
        String sCurrentLine = "";
        BufferedReader reader = new BufferedReader(new FileReader(flirtsFile));
        Scanner s = new Scanner(sCurrentLine);
        while ((sCurrentLine = reader.readLine()) != null) {
            sCurrentLine = sCurrentLine.trim();
            this.fliRTSRetestableTestCases.add(sCurrentLine);
        }
        reader.close();
    }

    private void AddAllTestCases() {
        this.allTestCases.addAll(this.fliRTSRetestableTestCases);
        this.allTestCases.addAll(this.fliRTSReusableTestCases);
    }

    public static void main(String[] args) throws Exception {
        SPRCalculator evaluator = new SPRCalculator();
        evaluator.readFLiRTS2RetestableTestCases(args[0]);
        evaluator.readFLiRTS2ReusableTestCases(args[1]);
        evaluator.AddAllTestCases();
        evaluator.readAdaptedClasses(args[2]);
        evaluator.compareCLZFilesInEkstaziDirs(args[3], args[4]);
        evaluator.compareCLZFilesInSTARTSDirs(args[5], args[6]);
        evaluator.compute(args[7], args[8]);
    }
}

