/*
 * Decompiled with CFR 0.152.
 */
package atjavac.parser.util;

import atjavac.parser.util.BlockAnnotationData;
import atjavac.parser.util.ExpressionAnnotationData;
import atjavac.parser.util.StringIntInt;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodData {
    private String methodDeclaration = "";
    private int startLine = 0;
    private int startCol = 0;
    private int endLine = 0;
    private int endCol = 0;
    private boolean isConstructor = false;
    private ArrayList<StringIntInt> methodAnnotations = new ArrayList();
    private TreeSet<BlockAnnotationData> blockAnnotations = new TreeSet();
    private ArrayList<ExpressionAnnotationData> expressionAnnotations = new ArrayList();
    private ArrayList<ExpressionAnnotationData> expressionAnnotationsDividedByLevel;

    public MethodData(String string, int n, int n2, boolean bl) {
        this.methodDeclaration = string;
        this.startLine = n;
        this.startCol = n2;
        this.isConstructor = bl;
    }

    public void endMethod(int n, int n2) {
        this.endLine = n;
        this.endCol = n2;
    }

    public void addBlockAnnotation(String string, int n, int n2, int n3, int n4, int n5, int n6, int n7, String string2, int n8, int n9, boolean bl) {
        this.blockAnnotations.add(new BlockAnnotationData(string, n, n2, n3, n4, n5, n6, n7, string2, n8, n9, bl));
    }

    public void addExpressionAnnotation(String string, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        this.expressionAnnotations.add(new ExpressionAnnotationData(string, n, n2, n3, n4, n5, n6, n7, n8));
    }

    public void addMethodAnnotations(ArrayList<StringIntInt> arrayList) {
        this.methodAnnotations = arrayList;
    }

    public String getMethodDeclaration() {
        return this.methodDeclaration;
    }

    public TreeSet<BlockAnnotationData> getBlockAnnotations() {
        return this.blockAnnotations;
    }

    public ArrayList<ExpressionAnnotationData> getExpressionAnnotations() {
        return this.expressionAnnotations;
    }

    public ArrayList<ExpressionAnnotationData> getExpressionAnnotationsDividedByLevel() {
        if (this.expressionAnnotationsDividedByLevel == null) {
            int n = 0;
            ArrayList<ExpressionAnnotationData> arrayList = new ArrayList<ExpressionAnnotationData>();
            for (ExpressionAnnotationData expressionAnnotationData : this.expressionAnnotations) {
                if (expressionAnnotationData.getExpressionLevel() == 0) {
                    arrayList.add(expressionAnnotationData);
                }
                n = Math.max(n, expressionAnnotationData.getExpressionLevel());
            }
            Object object = new int[++n];
            for (int i = 0; i < n; ++i) {
                object[i] = false;
            }
            for (ExpressionAnnotationData expressionAnnotationData : this.expressionAnnotations) {
                Object object2 = object;
                int n2 = expressionAnnotationData.getExpressionLevel();
                object2[n2] = object2[n2] + true;
            }
            ExpressionAnnotationData[][] expressionAnnotationDataArrayArray = new ExpressionAnnotationData[n][];
            for (int i = 0; i < n; ++i) {
                expressionAnnotationDataArrayArray[i] = new ExpressionAnnotationData[object[i]];
            }
            int[] nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                nArray[i] = 0;
            }
            Iterator<ExpressionAnnotationData> iterator = this.expressionAnnotations.iterator();
            while (iterator.hasNext()) {
                ExpressionAnnotationData[] expressionAnnotationDataArray;
                expressionAnnotationDataArrayArray[expressionAnnotationDataArray.getExpressionLevel()][nArray[expressionAnnotationDataArray.getExpressionLevel()]] = expressionAnnotationDataArray = iterator.next();
                int n3 = expressionAnnotationDataArray.getExpressionLevel();
                nArray[n3] = nArray[n3] + 1;
            }
            this.expressionAnnotationsDividedByLevel = arrayList;
            for (int i = 0; i < n; ++i) {
                for (ExpressionAnnotationData expressionAnnotationData : expressionAnnotationDataArrayArray[i]) {
                    for (ExpressionAnnotationData expressionAnnotationData2 : this.expressionAnnotationsDividedByLevel) {
                        expressionAnnotationData2.addExpressionAnnotation(expressionAnnotationData);
                    }
                }
            }
        }
        return this.expressionAnnotationsDividedByLevel;
    }

    public ArrayList<StringIntInt> getMethodAnnotations() {
        return this.methodAnnotations;
    }

    public int getNumCodeAnnotations() {
        return this.blockAnnotations.size() + this.expressionAnnotations.size();
    }

    public int getNumBlockAnnotations() {
        return this.blockAnnotations.size();
    }

    public int getNumExpressionAnnotations() {
        return this.expressionAnnotations.size();
    }

    public int getStartLine() {
        return this.startLine;
    }

    public int getStartColumn() {
        return this.startCol;
    }

    public int getEndLine() {
        return this.endLine;
    }

    public int getEndColumn() {
        return this.endCol;
    }

    public boolean isConstructor() {
        return this.isConstructor;
    }

    public void print() {
        for (BlockAnnotationData blockAnnotationData : this.blockAnnotations) {
            System.out.println("ANNOTAZIONE: " + blockAnnotationData.getAnnotationDeclaration() + "\n             Level: " + blockAnnotationData.getLevel() + "\tAnnotationStartLine: " + blockAnnotationData.getAnnotationStartLine() + "\tAnnotationStartColumn: " + blockAnnotationData.getAnnotationStartColumn() + "");
        }
    }
}

