/*
 * Decompiled with CFR 0.152.
 */
package atjavac.parser.util;

import atjavac.parser.util.CodeAnnotationData;
import atjavac.parser.util.FieldData;
import atjavac.parser.util.FieldExpressionAnnotationData;
import atjavac.parser.util.MethodData;
import atjavac.parser.util.StringIntInt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassData {
    private String classDeclaration;
    private String className;
    private int startRowClassDeclaration;
    private int startColumnClassDeclaration;
    private int endRowClassBlock;
    private int endColumnClassBlock;
    private HashSet<String> innerAnnotationsTypeFound = new HashSet();
    private HashSet<String> blockAnnotationsTypeFound = new HashSet();
    private HashSet<String> expressionAnnotationsTypeFound = new HashSet();
    private HashSet<String> methodAnnotationsTypeFound = new HashSet();
    private ArrayList<StringIntInt> innerAnnotationsFound = new ArrayList();
    private ArrayList<StringIntInt> blockAnnotationsFound = new ArrayList();
    private ArrayList<StringIntInt> expressionAnnotationsFound = new ArrayList();
    private ArrayList<StringIntInt> methodAnnotationsFound = new ArrayList();
    private ArrayList<MethodData> methods = new ArrayList();
    private int level = 0;
    private boolean isAnnotation = false;
    private boolean existElementTypeBlock = false;
    private boolean existElementTypeExpression = false;
    private int startLineElementTypeBlock;
    private int startColumnElementTypeBlock;
    private int startLineElementTypeExpression;
    private int startColumnElementTypeExpression;
    private int endLineElementTypeBlock;
    private int endColumnElementTypeBlock;
    private int endLineElementTypeExpression;
    private int endColumnElementTypeExpression;
    private boolean existElementTypeMethod = false;
    private ArrayList<StringIntInt> standardElementTypeFound;
    ArrayList<FieldData> fields = new ArrayList();
    private ArrayList<FieldExpressionAnnotationData> staticFEAs = new ArrayList();
    private ArrayList<FieldExpressionAnnotationData> staticFEAsDividedByLevel;
    private ArrayList<FieldExpressionAnnotationData> notStaticFEAs = new ArrayList();
    private ArrayList<FieldExpressionAnnotationData> notStaticFEAsDividedByLevel;

    public ClassData(String string, String string2, int n, int n2, int n3) {
        this.classDeclaration = string;
        this.className = string2;
        this.startRowClassDeclaration = n;
        this.startColumnClassDeclaration = n2;
        this.level = n3;
    }

    public void setEndClass(int n, int n2) {
        this.endRowClassBlock = n;
        this.endColumnClassBlock = n2;
    }

    public void addField(String string, boolean bl) {
        this.fields.add(new FieldData(string, bl));
    }

    public void startMethod(String string, int n, int n2, boolean bl) {
        this.methods.add(new MethodData(string, n, n2, bl));
    }

    public void setAsAnnotation() {
        this.isAnnotation = true;
    }

    public void endMethod(int n, int n2) {
        this.methods.get(this.methods.size() - 1).endMethod(n, n2);
    }

    public void addElementTypeBlock(int n, int n2, int n3, int n4) {
        this.existElementTypeBlock = true;
        this.startLineElementTypeBlock = n;
        this.startColumnElementTypeBlock = n2;
        this.endLineElementTypeBlock = n3;
        this.endColumnElementTypeBlock = n4;
    }

    public void addElementTypeExpression(int n, int n2, int n3, int n4) {
        this.existElementTypeExpression = true;
        this.startLineElementTypeExpression = n;
        this.startColumnElementTypeExpression = n2;
        this.endLineElementTypeExpression = n3;
        this.endColumnElementTypeExpression = n4;
    }

    public void addElementTypeList(ArrayList<StringIntInt> arrayList) {
        this.standardElementTypeFound = arrayList;
        for (StringIntInt stringIntInt : arrayList) {
            if (!stringIntInt.getString().equals("METHOD")) continue;
            this.existElementTypeMethod = true;
            break;
        }
    }

    public void addBlockAnnotation(String string, int n, int n2, int n3, int n4, int n5, int n6, int n7, String string2, int n8, int n9, boolean bl) {
        this.methods.get(this.methods.size() - 1).addBlockAnnotation(string, n, n2, n3, n4, n5, n6, n7, string2, n8, n9, bl);
        int n10 = string.indexOf("(");
        String string3 = n10 > 1 ? string.substring(1, n10) : string.substring(1);
        if (!this.innerAnnotationsTypeFound.contains(string3)) {
            this.innerAnnotationsTypeFound.add(string3);
            this.innerAnnotationsFound.add(new StringIntInt(string3, n2, n3));
        }
        if (!this.blockAnnotationsTypeFound.contains(string3)) {
            this.blockAnnotationsTypeFound.add(string3);
            this.blockAnnotationsFound.add(new StringIntInt(string3, n2, n3));
        }
    }

    public void addExpressionAnnotation(String string, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        if (this.methods.size() == 0) {
            if (this.fields.get(this.fields.size() - 1).isStatic()) {
                this.staticFEAs.add(new FieldExpressionAnnotationData(this.fields.get(this.fields.size() - 1).getName(), true, string, n, n2, n3, n4, n5, n6, n7, n8));
            } else {
                this.notStaticFEAs.add(new FieldExpressionAnnotationData(this.fields.get(this.fields.size() - 1).getName(), false, string, n, n2, n3, n4, n5, n6, n7, n8));
            }
        } else {
            this.methods.get(this.methods.size() - 1).addExpressionAnnotation(string, n, n2, n3, n4, n5, n6, n7, n8);
        }
        int n9 = string.indexOf("(");
        String string2 = n9 > 1 ? string.substring(1, n9) : string.substring(1);
        if (!this.innerAnnotationsTypeFound.contains(string2)) {
            this.innerAnnotationsTypeFound.add(string2);
            this.innerAnnotationsFound.add(new StringIntInt(string2, n2, n3));
        }
        if (!this.expressionAnnotationsTypeFound.contains(string2)) {
            this.expressionAnnotationsTypeFound.add(string2);
            this.expressionAnnotationsFound.add(new StringIntInt(string2, n2, n3));
        }
    }

    public void addMethodAnnotations(ArrayList<StringIntInt> arrayList) {
        if (!this.methods.get(this.methods.size() - 1).isConstructor()) {
            this.methods.get(this.methods.size() - 1).addMethodAnnotations(arrayList);
            for (StringIntInt stringIntInt : arrayList) {
                if (this.methodAnnotationsTypeFound.contains(stringIntInt.getString())) continue;
                this.methodAnnotationsTypeFound.add(stringIntInt.getString());
                this.methodAnnotationsFound.add(stringIntInt);
            }
        }
    }

    public String getDeclaration() {
        return this.classDeclaration;
    }

    public String getName() {
        return this.className;
    }

    public ArrayList<MethodData> getMethods() {
        return this.methods;
    }

    public ArrayList<FieldExpressionAnnotationData> getStaticFieldExpressionAnnotations() {
        return this.staticFEAs;
    }

    public ArrayList<FieldExpressionAnnotationData> getStaticFieldExpressionAnnotationsDividedByLevel() {
        if (this.staticFEAsDividedByLevel == null) {
            Object[] objectArray = new FieldExpressionAnnotationData[this.staticFEAs.size()];
            for (int i = 0; i < this.staticFEAs.size(); ++i) {
                objectArray[i] = this.staticFEAs.get(i);
            }
            Arrays.sort(objectArray);
            this.staticFEAsDividedByLevel = new ArrayList();
            for (Object object : objectArray) {
                if (((CodeAnnotationData)object).getLevel() == 0) {
                    this.staticFEAsDividedByLevel.add((FieldExpressionAnnotationData)object);
                    continue;
                }
                this.staticFEAsDividedByLevel.get(this.staticFEAsDividedByLevel.size() - 1).addFieldExpressionAnnotation((FieldExpressionAnnotationData)object);
            }
        }
        return this.staticFEAsDividedByLevel;
    }

    public ArrayList<FieldExpressionAnnotationData> getNotStaticFieldExpressionAnnotations() {
        return this.notStaticFEAs;
    }

    public ArrayList<FieldExpressionAnnotationData> getNotStaticFieldExpressionAnnotationsDividedByLevel() {
        if (this.notStaticFEAsDividedByLevel == null) {
            Object[] objectArray = new FieldExpressionAnnotationData[this.notStaticFEAs.size()];
            for (int i = 0; i < this.notStaticFEAs.size(); ++i) {
                objectArray[i] = this.notStaticFEAs.get(i);
            }
            Arrays.sort(objectArray);
            this.notStaticFEAsDividedByLevel = new ArrayList();
            for (Object object : objectArray) {
                if (((CodeAnnotationData)object).getLevel() == 0) {
                    this.notStaticFEAsDividedByLevel.add((FieldExpressionAnnotationData)object);
                    continue;
                }
                this.notStaticFEAsDividedByLevel.get(this.notStaticFEAsDividedByLevel.size() - 1).addFieldExpressionAnnotation((FieldExpressionAnnotationData)object);
            }
        }
        return this.notStaticFEAsDividedByLevel;
    }

    public int getStartRow() {
        return this.startRowClassDeclaration;
    }

    public int getStartColumn() {
        return this.startColumnClassDeclaration;
    }

    public int getEndRow() {
        return this.endRowClassBlock;
    }

    public int getEndColumn() {
        return this.endColumnClassBlock;
    }

    public boolean isAnnotation() {
        return this.isAnnotation;
    }

    public boolean existTarget() {
        return this.isTargetDefined();
    }

    public boolean existElementTypeBlock() {
        return this.existElementTypeBlock;
    }

    public int getElementTypeBlockStartLine() {
        return this.startLineElementTypeBlock;
    }

    public int getElementTypeBlockStartColumn() {
        return this.startColumnElementTypeBlock;
    }

    public int getElementTypeBlockEndLine() {
        return this.endLineElementTypeBlock;
    }

    public int getElementTypeBlockEndColumn() {
        return this.endColumnElementTypeBlock;
    }

    public boolean existElementTypeExpression() {
        return this.existElementTypeExpression;
    }

    public int getElementTypeExpressionStartLine() {
        return this.startLineElementTypeExpression;
    }

    public int getElementTypeExpressionStartColumn() {
        return this.startColumnElementTypeExpression;
    }

    public int getElementTypeExpressionEndLine() {
        return this.endLineElementTypeExpression;
    }

    public int getElementTypeExpressionEndColumn() {
        return this.endColumnElementTypeExpression;
    }

    public boolean existElementTypeMethod() {
        return this.existElementTypeMethod;
    }

    public boolean isTargetDefined() {
        return this.existElementTypeBlock || this.existElementTypeExpression || this.standardElementTypeFound != null && this.standardElementTypeFound.size() > 0;
    }

    public ArrayList<StringIntInt> getStandardElementTypes() {
        return this.standardElementTypeFound;
    }

    public int getLevel() {
        return this.level;
    }

    public ArrayList<StringIntInt> getAllInnerAnnotationsWithoutDuplicates() {
        return this.innerAnnotationsFound;
    }

    public ArrayList<StringIntInt> getAllBlockAnnotationsWithoutDuplicates() {
        return this.blockAnnotationsFound;
    }

    public ArrayList<StringIntInt> getAllExpressionAnnotationsWithoutDuplicates() {
        return this.expressionAnnotationsFound;
    }

    public ArrayList<StringIntInt> getAllMethodAnnotationsWithoutDuplicates() {
        return this.methodAnnotationsFound;
    }

    public void print() {
        for (MethodData methodData : this.methods) {
            System.out.println("METODO: '" + methodData.getMethodDeclaration() + "':");
            methodData.print();
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("{");
        StringBuffer stringBuffer2 = new StringBuffer("");
        stringBuffer.append("[CLASS=" + this.className + ", level=" + this.level + ", start=(" + this.startRowClassDeclaration + "," + this.startColumnClassDeclaration + "), end=(" + this.endRowClassBlock + "," + this.endColumnClassBlock + "), ");
        stringBuffer.append("isAnnotation: " + this.isAnnotation + ", ");
        if (!this.isAnnotation) {
            int n;
            stringBuffer.append("blockAnnotationsTypeFound: " + this.blockAnnotationsTypeFound + ", ");
            stringBuffer.append("expressionAnnotationsTypeFound: " + this.expressionAnnotationsTypeFound + ", ");
            stringBuffer.append("methodAnnotationsTypeFound: " + this.methodAnnotationsTypeFound + ", ");
            stringBuffer.append("methodAnnotationsTypeFound: " + this.methodAnnotationsTypeFound + ", ");
            stringBuffer2 = new StringBuffer("{");
            for (n = 0; n < this.methods.size(); ++n) {
                if (n < this.methods.size() - 1) {
                    stringBuffer2.append(this.methods.get(n).getMethodDeclaration()).append(",");
                    continue;
                }
                stringBuffer2.append(this.methods.get(n).getMethodDeclaration());
            }
            stringBuffer2.append("}");
            stringBuffer.append("methods: " + stringBuffer2.toString() + ", ");
            stringBuffer2 = new StringBuffer("{");
            for (n = 0; n < this.fields.size(); ++n) {
                if (n < this.fields.size() - 1) {
                    stringBuffer2.append(this.fields.get(n).getName()).append(",");
                    continue;
                }
                stringBuffer2.append(this.fields.get(n).getName());
            }
            stringBuffer2.append("}");
            stringBuffer.append("fields: " + stringBuffer2.toString() + "]");
        } else {
            stringBuffer.append("existElementTypeBlock: " + this.existElementTypeBlock + ", ");
            stringBuffer.append("existElementTypeExpression: " + this.existElementTypeExpression + ", ");
            stringBuffer.append("existElementTypeMethod: " + this.existElementTypeMethod + ", ");
            stringBuffer.append("standardElementTypeFound: " + this.standardElementTypeFound + ", ");
            stringBuffer.append("existElementTypeBlock: " + this.existElementTypeBlock + "]");
        }
        return stringBuffer.toString();
    }
}

