/*
 * Decompiled with CFR 0.152.
 */
package atjavac.bcel.extensions;

import atjavac.bcel.extensions.Conversion;
import atjavac.bcel.extensions.FieldExpressionAnnotation;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.Visitor;
import org.apache.bcel.generic.ConstantPoolGen;

public class FieldExpressionAnnotationsAttribute
extends Attribute {
    protected FieldExpressionAnnotation[] fieldExpressionAnnotations;
    private int name_index;

    public FieldExpressionAnnotationsAttribute(byte by, int n, int n2, ConstantPool constantPool, FieldExpressionAnnotation[] fieldExpressionAnnotationArray) {
        super(by, n, n2, constantPool);
        this.fieldExpressionAnnotations = fieldExpressionAnnotationArray;
        this.name_index = n;
    }

    public FieldExpressionAnnotationsAttribute(int n, ConstantPool constantPool, FieldExpressionAnnotation[] fieldExpressionAnnotationArray) {
        super((byte)-1, n, 0, constantPool);
        this.fieldExpressionAnnotations = fieldExpressionAnnotationArray;
        this.name_index = n;
        int n2 = 2;
        for (FieldExpressionAnnotation fieldExpressionAnnotation : fieldExpressionAnnotationArray) {
            n2 += fieldExpressionAnnotation.getLength(constantPool);
        }
        super.setLength(n2);
    }

    public FieldExpressionAnnotation[] getFieldExpressionAnnotations() {
        return this.fieldExpressionAnnotations;
    }

    public void accept(Visitor visitor) {
        throw new UnsupportedOperationException();
    }

    public int getLength(ConstantPool constantPool) {
        int n = 0;
        for (FieldExpressionAnnotation fieldExpressionAnnotation : this.fieldExpressionAnnotations) {
            n += fieldExpressionAnnotation.getLength(constantPool);
        }
        return 2 + n;
    }

    public void dump(DataOutputStream dataOutputStream) throws IOException {
        ConstantPoolGen constantPoolGen = new ConstantPoolGen(this.getConstantPool());
        dataOutputStream.writeShort(this.getNameIndex());
        dataOutputStream.writeInt(this.getLength(this.getConstantPool()));
        dataOutputStream.writeShort(this.fieldExpressionAnnotations.length);
        for (FieldExpressionAnnotation fieldExpressionAnnotation : this.fieldExpressionAnnotations) {
            fieldExpressionAnnotation.dump(dataOutputStream, constantPoolGen);
        }
    }

    public ByteArrayOutputStream getBytecode() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ConstantPoolGen constantPoolGen = new ConstantPoolGen(this.getConstantPool());
        byteArrayOutputStream.write(Conversion.get2BytesFromInt(this.getNameIndex()), 0, 2);
        byteArrayOutputStream.write(Conversion.get4BytesFromInt(this.getLength(this.getConstantPool())), 0, 2);
        byteArrayOutputStream.write(Conversion.get2BytesFromInt(this.fieldExpressionAnnotations.length), 0, 2);
        for (FieldExpressionAnnotation fieldExpressionAnnotation : this.fieldExpressionAnnotations) {
            byteArrayOutputStream = fieldExpressionAnnotation.getBytecode(byteArrayOutputStream, constantPoolGen);
        }
        return byteArrayOutputStream;
    }

    public ByteArrayOutputStream getBytecodeAsAnnotationAttributeWhithoutHeader() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ConstantPoolGen constantPoolGen = new ConstantPoolGen(this.getConstantPool());
        byteArrayOutputStream.write(Conversion.get2BytesFromInt(this.fieldExpressionAnnotations.length), 0, 2);
        for (FieldExpressionAnnotation fieldExpressionAnnotation : this.fieldExpressionAnnotations) {
            byteArrayOutputStream = fieldExpressionAnnotation.getAnnotationBytecode(byteArrayOutputStream, constantPoolGen);
        }
        return byteArrayOutputStream;
    }

    public ByteArrayOutputStream getBytecodeAsAnnotationAttributeWhithoutHeaderWithOnlyOneAnnotation(int n) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ConstantPoolGen constantPoolGen = new ConstantPoolGen(this.getConstantPool());
        byteArrayOutputStream.write(Conversion.get2BytesFromInt(1), 0, 2);
        byteArrayOutputStream = this.fieldExpressionAnnotations[n].getAnnotationBytecode(byteArrayOutputStream, constantPoolGen);
        return byteArrayOutputStream;
    }

    public int getLengthAsAnnotationAttrinute(ConstantPool constantPool) {
        int n = 0;
        for (FieldExpressionAnnotation fieldExpressionAnnotation : this.fieldExpressionAnnotations) {
            n += fieldExpressionAnnotation.getLengthAsAnnotation(constantPool);
        }
        return 2 + n;
    }

    public int getNumBlockAnnotations() {
        return this.fieldExpressionAnnotations.length;
    }

    public Attribute copy(ConstantPool constantPool) {
        return this;
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        stringBuffer.append(this.getConstantPool().constantToString(this.getConstantPool().getConstant(this.name_index)));
        stringBuffer.append(" ([");
        for (n = 0; n < this.fieldExpressionAnnotations.length - 1; ++n) {
            stringBuffer.append(this.fieldExpressionAnnotations[n].toString());
            if (n2 < this.fieldExpressionAnnotations.length) {
                stringBuffer.append(", ");
            }
            ++n2;
        }
        if (this.fieldExpressionAnnotations.length > 0) {
            stringBuffer.append(this.fieldExpressionAnnotations[n].toString());
        }
        stringBuffer.append("])");
        return stringBuffer.toString();
    }

    public String toStringExpanded() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        stringBuffer.append(this.getConstantPool().constantToString(this.getConstantPool().getConstant(this.name_index))).append("\n");
        for (FieldExpressionAnnotation fieldExpressionAnnotation : this.fieldExpressionAnnotations) {
            stringBuffer.append(fieldExpressionAnnotation.toStringExpanded());
            if (n < this.fieldExpressionAnnotations.length) {
                stringBuffer.append("\n");
            }
            ++n;
        }
        return stringBuffer.toString();
    }
}

