/*
 * Decompiled with CFR 0.152.
 */
package atjavac.bcel.extensions;

import atjavac.bcel.extensions.Annotation;
import atjavac.bcel.extensions.Conversion;
import atjavac.bcel.extensions.ExpressionAnnotation;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.generic.ConstantPoolGen;

public class FieldExpressionAnnotation
extends ExpressionAnnotation {
    private String fieldName;
    private boolean isStatic;

    public FieldExpressionAnnotation(int n, int n2, int n3, int n4, int n5, int n6, int n7, Annotation annotation, String string, boolean bl) {
        super(n, n2, n3, n4, n5, n6, n7, annotation);
        this.fieldName = string;
        this.isStatic = bl;
    }

    public FieldExpressionAnnotation(DataInputStream dataInputStream, ConstantPool constantPool) throws IOException {
        super(dataInputStream, constantPool);
        short s = dataInputStream.readShort();
        this.fieldName = constantPool.constantToString(constantPool.getConstant((int)s));
        this.isStatic = dataInputStream.readBoolean();
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public int getLength(ConstantPool constantPool) {
        return 3 + super.getLength(constantPool);
    }

    public void dump(DataOutputStream dataOutputStream, ConstantPoolGen constantPoolGen) throws IOException {
        super.dump(dataOutputStream, constantPoolGen);
        dataOutputStream.writeShort(constantPoolGen.lookupUtf8(this.fieldName));
        dataOutputStream.writeBoolean(this.isStatic);
    }

    public ByteArrayOutputStream getBytecode(ByteArrayOutputStream byteArrayOutputStream, ConstantPoolGen constantPoolGen) {
        byteArrayOutputStream = super.getBytecode(byteArrayOutputStream, constantPoolGen);
        byteArrayOutputStream.write(Conversion.get2BytesFromInt(constantPoolGen.lookupUtf8(this.fieldName)), 0, 2);
        if (this.isStatic) {
            byteArrayOutputStream.write(Conversion.get1ByteFromInt(1), 0, 1);
        } else {
            byteArrayOutputStream.write(Conversion.get1ByteFromInt(1), 0, 1);
        }
        return byteArrayOutputStream;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("FIELD EXPRESSION ANNOTATION - ");
        stringBuffer.append("fieldName: ").append(this.fieldName).append(" ");
        stringBuffer.append("isStatic: ").append(this.isStatic).append(" ");
        stringBuffer.append(super.toString());
        return stringBuffer.toString();
    }

    public String toStringExpanded() {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("--- FIELD EXPRESSION ANNOTATION ---").append("\n");
        stringBuffer.append("fieldName: ").append(this.fieldName).append("\n");
        stringBuffer.append("isStatic: ").append(this.isStatic).append("\n");
        stringBuffer.append(super.toStringExpanded());
        return stringBuffer.toString();
    }
}

