/*
 * Decompiled with CFR 0.152.
 */
package atjavac.bcel.extensions;

import atjavac.bcel.extensions.Conversion;
import atjavac.bcel.extensions.ExpressionAnnotation;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.Visitor;
import org.apache.bcel.generic.ConstantPoolGen;

public class ExpressionAnnotationsAttribute
extends Attribute {
    protected ExpressionAnnotation[] expressionAnnotations;
    private int name_index;

    public ExpressionAnnotationsAttribute(byte by, int n, int n2, ConstantPool constantPool, ExpressionAnnotation[] expressionAnnotationArray) {
        super(by, n, n2, constantPool);
        this.expressionAnnotations = expressionAnnotationArray;
        this.name_index = n;
    }

    public ExpressionAnnotationsAttribute(int n, ConstantPool constantPool, ExpressionAnnotation[] expressionAnnotationArray) {
        super((byte)-1, n, 0, constantPool);
        this.expressionAnnotations = expressionAnnotationArray;
        this.name_index = n;
        int n2 = 2;
        for (ExpressionAnnotation expressionAnnotation : expressionAnnotationArray) {
            n2 += expressionAnnotation.getLength(constantPool);
        }
        super.setLength(n2);
    }

    public ExpressionAnnotation[] getExpressionAnnotations() {
        return this.expressionAnnotations;
    }

    public void accept(Visitor visitor) {
        throw new UnsupportedOperationException();
    }

    public int getLength(ConstantPool constantPool) {
        int n = 0;
        for (ExpressionAnnotation expressionAnnotation : this.expressionAnnotations) {
            n += expressionAnnotation.getLength(constantPool);
        }
        return 2 + n;
    }

    public void dump(DataOutputStream dataOutputStream) throws IOException {
        ConstantPoolGen constantPoolGen = new ConstantPoolGen(this.getConstantPool());
        dataOutputStream.writeShort(this.getNameIndex());
        dataOutputStream.writeInt(this.getLength(this.getConstantPool()));
        dataOutputStream.writeShort(this.expressionAnnotations.length);
        for (ExpressionAnnotation expressionAnnotation : this.expressionAnnotations) {
            expressionAnnotation.dump(dataOutputStream, constantPoolGen);
        }
    }

    public ByteArrayOutputStream getBytecode() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ConstantPoolGen constantPoolGen = new ConstantPoolGen(this.getConstantPool());
        byteArrayOutputStream.write(Conversion.get2BytesFromInt(this.getNameIndex()), 0, 2);
        byteArrayOutputStream.write(Conversion.get4BytesFromInt(this.getLength(this.getConstantPool())), 0, 2);
        byteArrayOutputStream.write(Conversion.get2BytesFromInt(this.expressionAnnotations.length), 0, 2);
        for (ExpressionAnnotation expressionAnnotation : this.expressionAnnotations) {
            byteArrayOutputStream = expressionAnnotation.getBytecode(byteArrayOutputStream, constantPoolGen);
        }
        return byteArrayOutputStream;
    }

    public ByteArrayOutputStream getBytecodeAsAnnotationAttributeWhithoutHeader() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ConstantPoolGen constantPoolGen = new ConstantPoolGen(this.getConstantPool());
        byteArrayOutputStream.write(Conversion.get2BytesFromInt(this.expressionAnnotations.length), 0, 2);
        for (ExpressionAnnotation expressionAnnotation : this.expressionAnnotations) {
            byteArrayOutputStream = expressionAnnotation.getAnnotationBytecode(byteArrayOutputStream, constantPoolGen);
        }
        return byteArrayOutputStream;
    }

    public ByteArrayOutputStream getBytecodeAsAnnotationAttributeWhithoutHeaderWithOnlyOneAnnotation(int n) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ConstantPoolGen constantPoolGen = new ConstantPoolGen(this.getConstantPool());
        byteArrayOutputStream.write(Conversion.get2BytesFromInt(1), 0, 2);
        byteArrayOutputStream = this.expressionAnnotations[n].getAnnotationBytecode(byteArrayOutputStream, constantPoolGen);
        return byteArrayOutputStream;
    }

    public int getLengthAsAnnotationAttrinute(ConstantPool constantPool) {
        int n = 0;
        for (ExpressionAnnotation expressionAnnotation : this.expressionAnnotations) {
            n += expressionAnnotation.getLengthAsAnnotation(constantPool);
        }
        return 2 + n;
    }

    public int getNumBlockAnnotations() {
        return this.expressionAnnotations.length;
    }

    public Attribute copy(ConstantPool constantPool) {
        return this;
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        stringBuffer.append(this.getConstantPool().constantToString(this.getConstantPool().getConstant(this.name_index)));
        stringBuffer.append(" ([");
        for (n = 0; n < this.expressionAnnotations.length - 1; ++n) {
            stringBuffer.append(this.expressionAnnotations[n].toString());
            if (n2 < this.expressionAnnotations.length) {
                stringBuffer.append(", ");
            }
            ++n2;
        }
        if (this.expressionAnnotations.length > 0) {
            stringBuffer.append(this.expressionAnnotations[n].toString());
        }
        stringBuffer.append("])");
        return stringBuffer.toString();
    }

    public String toStringExpanded() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        stringBuffer.append(this.getConstantPool().constantToString(this.getConstantPool().getConstant(this.name_index))).append("\n");
        for (ExpressionAnnotation expressionAnnotation : this.expressionAnnotations) {
            stringBuffer.append(expressionAnnotation.toStringExpanded());
            if (n < this.expressionAnnotations.length) {
                stringBuffer.append("\n");
            }
            ++n;
        }
        return stringBuffer.toString();
    }
}

