/*
 * Decompiled with CFR 0.152.
 */
package atjavac.bcel.extensions;

import atjavac.bcel.extensions.Conversion;
import atjavac.bcel.extensions.ElementValue;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.generic.ConstantPoolGen;

public class ElementValuePair {
    private String name;
    private ElementValue elementValue;

    ElementValuePair(String string, ElementValue elementValue) {
        this.name = string;
        this.elementValue = elementValue;
    }

    public ElementValuePair(DataInputStream dataInputStream, ConstantPool constantPool) throws IOException {
        short s = dataInputStream.readShort();
        this.name = constantPool.constantToString(constantPool.getConstant((int)s));
        this.elementValue = new ElementValue(dataInputStream, constantPool);
    }

    public String getName() {
        return this.name;
    }

    public ElementValue getElementValue() {
        return this.elementValue;
    }

    public int getLength(ConstantPool constantPool) {
        return 2 + this.elementValue.getLength(constantPool);
    }

    public void dump(DataOutputStream dataOutputStream, ConstantPoolGen constantPoolGen) throws IOException {
        dataOutputStream.writeShort(constantPoolGen.lookupUtf8(this.name));
        this.elementValue.dump(dataOutputStream, constantPoolGen);
    }

    public ByteArrayOutputStream getBytecode(ByteArrayOutputStream byteArrayOutputStream, ConstantPoolGen constantPoolGen) {
        byteArrayOutputStream.write(Conversion.get2BytesFromInt(constantPoolGen.lookupUtf8(this.name)), 0, 2);
        byteArrayOutputStream = this.elementValue.getBytecode(byteArrayOutputStream, constantPoolGen);
        return byteArrayOutputStream;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.name).append("=").append(this.elementValue.toString());
        return stringBuffer.toString();
    }

    public String toStringExpanded() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n+ ").append(this.name).append(this.elementValue.toStringExpanded());
        return stringBuffer.toString();
    }
}

