/*
 * Decompiled with CFR 0.152.
 */
package atjavac.bcel.extensions;

import atjavac.bcel.extensions.Annotation;
import atjavac.bcel.extensions.Conversion;
import atjavac.bcel.extensions.StringEscapeUtils;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.bcel.classfile.ConstantObject;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.generic.ConstantPoolGen;

public class ElementValue {
    private byte tag;
    private Object value;

    public ElementValue(byte by, Object object) {
        this.tag = by;
        this.value = object;
    }

    public ElementValue(DataInputStream dataInputStream, ConstantPool constantPool) throws IOException {
        this.tag = dataInputStream.readByte();
        switch (this.tag) {
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 73: 
            case 74: 
            case 83: 
            case 90: {
                this.value = ((ConstantObject)constantPool.getConstant((int)dataInputStream.readShort())).getConstantValue(constantPool);
                break;
            }
            case 115: {
                this.value = constantPool.constantToString(constantPool.getConstant((int)dataInputStream.readShort()));
                break;
            }
            case 101: {
                Object[] objectArray;
                String string = constantPool.constantToString(constantPool.getConstant((int)dataInputStream.readShort()));
                String string2 = constantPool.constantToString(constantPool.getConstant((int)dataInputStream.readShort()));
                this.value = objectArray = new Object[]{string, string2};
                break;
            }
            case 99: {
                this.value = constantPool.constantToString(constantPool.getConstant((int)dataInputStream.readShort()));
                break;
            }
            case 64: {
                Annotation annotation = new Annotation(dataInputStream, constantPool);
                this.value = annotation;
                break;
            }
            case 91: {
                int n = dataInputStream.readShort();
                Object[] objectArray = new Object[n];
                for (int i = 0; i < n; ++i) {
                    objectArray[i] = new ElementValue(dataInputStream, constantPool);
                }
                this.value = objectArray;
                break;
            }
            default: {
                throw new UnsupportedOperationException("tag = " + (char)this.tag);
            }
        }
    }

    public void setTag(byte by) {
        this.tag = by;
    }

    public void setValue(Object object) {
        this.value = object;
    }

    public byte getTag() {
        return this.tag;
    }

    public Object getValue() {
        return this.value;
    }

    public int getLength(ConstantPool constantPool) {
        int n = 0;
        switch (this.tag) {
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 73: 
            case 74: 
            case 83: 
            case 90: 
            case 115: {
                n = 2;
                break;
            }
            case 101: {
                n = 4;
                break;
            }
            case 99: {
                n = 2;
                break;
            }
            case 64: {
                n = ((Annotation)this.value).getLength(constantPool);
                break;
            }
            case 91: {
                Object[] objectArray = (Object[])this.value;
                n = 2;
                for (int i = 0; i < objectArray.length; ++i) {
                    n += ((ElementValue)objectArray[i]).getLength(constantPool);
                }
                break;
            }
            default: {
                n = 0;
            }
        }
        return 1 + n;
    }

    public void dump(DataOutputStream dataOutputStream, ConstantPoolGen constantPoolGen) throws IOException {
        dataOutputStream.writeByte(this.tag);
        switch (this.tag) {
            case 66: 
            case 67: 
            case 73: 
            case 83: 
            case 90: {
                dataOutputStream.writeShort(constantPoolGen.lookupInteger(((Integer)this.value).intValue()));
                break;
            }
            case 68: {
                dataOutputStream.writeShort(constantPoolGen.lookupDouble(((Double)this.value).doubleValue()));
                break;
            }
            case 70: {
                dataOutputStream.writeShort(constantPoolGen.lookupFloat(((Float)this.value).floatValue()));
                break;
            }
            case 74: {
                dataOutputStream.writeShort(constantPoolGen.lookupLong(((Long)this.value).longValue()));
                break;
            }
            case 115: {
                dataOutputStream.writeShort(constantPoolGen.lookupUtf8((String)this.value));
                break;
            }
            case 101: {
                Object[] objectArray = (Object[])this.value;
                dataOutputStream.writeShort(constantPoolGen.lookupUtf8((String)objectArray[0]));
                dataOutputStream.writeShort(constantPoolGen.lookupUtf8((String)objectArray[1]));
                break;
            }
            case 99: {
                dataOutputStream.writeShort(constantPoolGen.lookupUtf8((String)this.value));
                break;
            }
            case 64: {
                ((Annotation)this.value).dump(dataOutputStream, constantPoolGen);
                break;
            }
            case 91: {
                Object[] objectArray = (Object[])this.value;
                dataOutputStream.writeShort(objectArray.length);
                for (int i = 0; i < objectArray.length; ++i) {
                    ((ElementValue)objectArray[i]).dump(dataOutputStream, constantPoolGen);
                }
                break;
            }
            default: {
                throw new UnsupportedOperationException("writing tag = " + (char)this.tag);
            }
        }
    }

    public ByteArrayOutputStream getBytecode(ByteArrayOutputStream byteArrayOutputStream, ConstantPoolGen constantPoolGen) {
        byteArrayOutputStream.write((byte)(this.tag & 0xFF));
        switch (this.tag) {
            case 66: 
            case 67: 
            case 73: 
            case 83: 
            case 90: {
                byteArrayOutputStream.write(Conversion.get2BytesFromInt(constantPoolGen.lookupInteger(((Integer)this.value).intValue())), 0, 2);
                break;
            }
            case 68: {
                byteArrayOutputStream.write(Conversion.get2BytesFromInt(constantPoolGen.lookupDouble(((Double)this.value).doubleValue())), 0, 2);
                break;
            }
            case 70: {
                byteArrayOutputStream.write(Conversion.get2BytesFromInt(constantPoolGen.lookupFloat(((Float)this.value).floatValue())), 0, 2);
                break;
            }
            case 74: {
                byteArrayOutputStream.write(Conversion.get2BytesFromInt(constantPoolGen.lookupLong(((Long)this.value).longValue())), 0, 2);
                break;
            }
            case 115: {
                byteArrayOutputStream.write(Conversion.get2BytesFromInt(constantPoolGen.lookupUtf8((String)this.value)), 0, 2);
                break;
            }
            case 101: {
                Object[] objectArray = (Object[])this.value;
                byteArrayOutputStream.write(Conversion.get2BytesFromInt(constantPoolGen.lookupUtf8((String)objectArray[0])), 0, 2);
                byteArrayOutputStream.write(Conversion.get2BytesFromInt(constantPoolGen.lookupUtf8((String)objectArray[1])), 0, 2);
                break;
            }
            case 99: {
                byteArrayOutputStream.write(Conversion.get2BytesFromInt(constantPoolGen.lookupUtf8((String)this.value)), 0, 2);
                break;
            }
            case 64: {
                byteArrayOutputStream = ((Annotation)this.value).getBytecode(byteArrayOutputStream, constantPoolGen);
                break;
            }
            case 91: {
                Object[] objectArray = (Object[])this.value;
                byteArrayOutputStream.write(Conversion.get2BytesFromInt(objectArray.length), 0, 2);
                for (int i = 0; i < objectArray.length; ++i) {
                    byteArrayOutputStream = ((ElementValue)objectArray[i]).getBytecode(byteArrayOutputStream, constantPoolGen);
                }
                break;
            }
        }
        return byteArrayOutputStream;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        switch (this.tag) {
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 73: 
            case 74: 
            case 83: 
            case 90: {
                stringBuffer.append(this.value);
                break;
            }
            case 115: {
                stringBuffer.append("\"").append(StringEscapeUtils.escapeJava(this.value.toString())).append("\"");
                break;
            }
            case 101: {
                Object[] objectArray = (Object[])this.value;
                String string = (String)objectArray[0];
                stringBuffer.append(string.substring(string.lastIndexOf("/") + 1, string.length() - 1));
                stringBuffer.append(".").append(objectArray[1]);
                break;
            }
            case 99: {
                String string = (String)this.value;
                stringBuffer.append(string.substring(string.lastIndexOf("/") + 1, string.length() - 1));
                stringBuffer.append(".class");
                break;
            }
            case 64: {
                stringBuffer.append(((Annotation)this.value).toString());
                break;
            }
            case 91: {
                Object[] objectArray = (Object[])this.value;
                stringBuffer.append("{");
                for (int i = 0; i < objectArray.length; ++i) {
                    String string = ((ElementValue)objectArray[i]).toString();
                    stringBuffer.append(string.replaceAll("\n", "\n\t"));
                    if (i >= objectArray.length - 1) continue;
                    stringBuffer.append(",");
                }
                stringBuffer.append("}");
                break;
            }
            default: {
                throw new UnsupportedOperationException("writing tag = " + (char)this.tag);
            }
        }
        return stringBuffer.toString();
    }

    public String toStringExpanded() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ('").append((char)this.tag).append("') = ");
        switch (this.tag) {
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 73: 
            case 74: 
            case 83: 
            case 90: {
                stringBuffer.append(this.value);
                break;
            }
            case 115: {
                stringBuffer.append("\"").append(StringEscapeUtils.escapeJava(this.value.toString())).append("\"");
                break;
            }
            case 101: {
                Object[] objectArray = (Object[])this.value;
                stringBuffer.append("\n\tEnumType=").append(objectArray[0]);
                stringBuffer.append("\n\tEnumConst=").append(objectArray[1]);
                break;
            }
            case 99: {
                stringBuffer.append(this.value);
                break;
            }
            case 64: {
                String string = ((Annotation)this.value).toStringExpanded();
                stringBuffer.append(string.replaceAll("\n", "\n\t"));
                break;
            }
            case 91: {
                Object[] objectArray = (Object[])this.value;
                stringBuffer.append("\n\tArrayLength=").append(objectArray.length);
                for (int i = 0; i < objectArray.length; ++i) {
                    String string = ((ElementValue)objectArray[i]).toStringExpanded();
                    stringBuffer.append("\n\t+ Array[").append(i).append("]").append(string.replaceAll("\n", "\n\t"));
                }
                break;
            }
            default: {
                throw new UnsupportedOperationException("writing tag = " + (char)this.tag);
            }
        }
        return stringBuffer.toString();
    }
}

