/*
 * Decompiled with CFR 0.152.
 */
package atjavac.bcel.extensions;

import atjavac.bcel.extensions.BlockAnnotation;
import atjavac.bcel.extensions.Conversion;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.Visitor;
import org.apache.bcel.generic.ConstantPoolGen;

public class BlockAnnotationsAttribute
extends Attribute {
    protected BlockAnnotation[] blockAnnotations;
    private int name_index;

    public BlockAnnotationsAttribute(byte by, int n, int n2, ConstantPool constantPool, BlockAnnotation[] blockAnnotationArray) {
        super(by, n, n2, constantPool);
        this.blockAnnotations = blockAnnotationArray;
        this.name_index = n;
    }

    public BlockAnnotationsAttribute(int n, ConstantPool constantPool, BlockAnnotation[] blockAnnotationArray) {
        super((byte)-1, n, 0, constantPool);
        this.blockAnnotations = blockAnnotationArray;
        this.name_index = n;
        int n2 = 2;
        for (BlockAnnotation blockAnnotation : blockAnnotationArray) {
            n2 += blockAnnotation.getLength(constantPool);
        }
        super.setLength(n2);
    }

    public BlockAnnotation[] getBlockAnnotations() {
        return this.blockAnnotations;
    }

    public void accept(Visitor visitor) {
        throw new UnsupportedOperationException();
    }

    public int getLength(ConstantPool constantPool) {
        int n = 0;
        for (BlockAnnotation blockAnnotation : this.blockAnnotations) {
            n += blockAnnotation.getLength(constantPool);
        }
        return 2 + n;
    }

    public void dump(DataOutputStream dataOutputStream) throws IOException {
        ConstantPoolGen constantPoolGen = new ConstantPoolGen(this.getConstantPool());
        dataOutputStream.writeShort(this.getNameIndex());
        dataOutputStream.writeInt(this.getLength(this.getConstantPool()));
        dataOutputStream.writeShort(this.blockAnnotations.length);
        for (BlockAnnotation blockAnnotation : this.blockAnnotations) {
            blockAnnotation.dump(dataOutputStream, constantPoolGen);
        }
    }

    public ByteArrayOutputStream getBytecode() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ConstantPoolGen constantPoolGen = new ConstantPoolGen(this.getConstantPool());
        byteArrayOutputStream.write(Conversion.get2BytesFromInt(this.getNameIndex()), 0, 2);
        byteArrayOutputStream.write(Conversion.get4BytesFromInt(this.getLength(this.getConstantPool())), 0, 2);
        byteArrayOutputStream.write(Conversion.get2BytesFromInt(this.blockAnnotations.length), 0, 2);
        for (BlockAnnotation blockAnnotation : this.blockAnnotations) {
            byteArrayOutputStream = blockAnnotation.getBytecode(byteArrayOutputStream, constantPoolGen);
        }
        return byteArrayOutputStream;
    }

    public ByteArrayOutputStream getAnnotationsAttributeBytecodeWithoutHeaderOAllBlockAnnotations() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ConstantPoolGen constantPoolGen = new ConstantPoolGen(this.getConstantPool());
        byteArrayOutputStream.write(Conversion.get2BytesFromInt(this.blockAnnotations.length), 0, 2);
        for (BlockAnnotation blockAnnotation : this.blockAnnotations) {
            byteArrayOutputStream = blockAnnotation.getAnnotationBytecode(byteArrayOutputStream, constantPoolGen);
        }
        return byteArrayOutputStream;
    }

    public ByteArrayOutputStream getAnnotationsAttributeBytecodeWithoutHeaderOfBlockAnnotation(int n) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ConstantPoolGen constantPoolGen = new ConstantPoolGen(this.getConstantPool());
        byteArrayOutputStream.write(Conversion.get2BytesFromInt(1), 0, 2);
        byteArrayOutputStream = this.blockAnnotations[n].getAnnotationBytecode(byteArrayOutputStream, constantPoolGen);
        return byteArrayOutputStream;
    }

    public int getLengthAsAnnotationAttrinute(ConstantPool constantPool) {
        int n = 0;
        for (BlockAnnotation blockAnnotation : this.blockAnnotations) {
            n += blockAnnotation.getLengthAsAnnotation(constantPool);
        }
        return 2 + n;
    }

    public int getNumBlockAnnotations() {
        return this.blockAnnotations.length;
    }

    public Attribute copy(ConstantPool constantPool) {
        return this;
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        stringBuffer.append(this.getConstantPool().constantToString(this.getConstantPool().getConstant(this.name_index)));
        stringBuffer.append(" ([");
        for (n = 0; n < this.blockAnnotations.length - 1; ++n) {
            stringBuffer.append(this.blockAnnotations[n].toString());
            if (n2 < this.blockAnnotations.length) {
                stringBuffer.append(", ");
            }
            ++n2;
        }
        if (this.blockAnnotations.length > 0) {
            stringBuffer.append(this.blockAnnotations[n].toString());
        }
        stringBuffer.append("])");
        return stringBuffer.toString();
    }

    public String toStringExpanded() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        stringBuffer.append(this.getConstantPool().constantToString(this.getConstantPool().getConstant(this.name_index))).append("\n");
        for (BlockAnnotation blockAnnotation : this.blockAnnotations) {
            stringBuffer.append(blockAnnotation.toStringExpanded());
            if (n < this.blockAnnotations.length) {
                stringBuffer.append("\n");
            }
            ++n;
        }
        return stringBuffer.toString();
    }
}

