/*
 * Decompiled with CFR 0.152.
 */
package atjavac;

import atjavac.ClassElementTypeInfo;
import atjavac.ClassFileMethodInfo;
import atjavac.ElementTypeBlockException;
import atjavac.ElementTypeExpressionException;
import atjavac.ElementTypeMethodException;
import atjavac.SourceCodeReplacement;
import atjavac.StreamGobbler;
import atjavac.StringEscapeUtils;
import atjavac.bcel.extensions.Annotation;
import atjavac.bcel.extensions.AnnotationsAttribute;
import atjavac.bcel.extensions.AnnotationsAttributeReader;
import atjavac.bcel.extensions.BlockAnnotation;
import atjavac.bcel.extensions.BlockAnnotationsAttribute;
import atjavac.bcel.extensions.BlockAnnotationsAttributeReader;
import atjavac.bcel.extensions.ElementTypeBLOCKAttribute;
import atjavac.bcel.extensions.ElementTypeBLOCKAttributeReader;
import atjavac.bcel.extensions.ElementTypeEXPRESSIONAttribute;
import atjavac.bcel.extensions.ElementTypeEXPRESSIONAttributeReader;
import atjavac.bcel.extensions.ElementValue;
import atjavac.bcel.extensions.ExpressionAnnotation;
import atjavac.bcel.extensions.ExpressionAnnotationsAttribute;
import atjavac.bcel.extensions.ExpressionAnnotationsAttributeReader;
import atjavac.bcel.extensions.FieldExpressionAnnotation;
import atjavac.bcel.extensions.FieldExpressionAnnotationsAttribute;
import atjavac.bcel.extensions.FieldExpressionAnnotationsAttributeReader;
import atjavac.parser.JaParser;
import atjavac.parser.ParseException;
import atjavac.parser.TokenMgrError;
import atjavac.parser.util.BlockAnnotationData;
import atjavac.parser.util.ClassData;
import atjavac.parser.util.CodeAnnotationData;
import atjavac.parser.util.ExpressionAnnotationData;
import atjavac.parser.util.FieldExpressionAnnotationData;
import atjavac.parser.util.FileData;
import atjavac.parser.util.MethodData;
import atjavac.parser.util.StringIntInt;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Stack;
import java.util.TreeSet;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.AttributeReader;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.ConstantString;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.classfile.InnerClass;
import org.apache.bcel.classfile.InnerClasses;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.InstructionTargeter;
import org.apache.bcel.generic.LDC;
import org.apache.bcel.generic.LDC_W;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.ReturnInstruction;
import org.apache.bcel.generic.TargetLostException;
import org.apache.bcel.util.ClassPath;
import org.apache.bcel.util.SyntheticRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Main
extends Thread {
    private static final String ELEMENT_TYPE_BLOCK_ATTRIBUTE_NAME = "ElementTypeBLOCK";
    private static final String ELEMENT_TYPE_EXPRESSION_ATTRIBUTE_NAME = "ElementTypeEXPRESSION";
    private static String receivedClasspath = "\"" + System.getProperty("user.dir") + "\"" + System.getProperty("path.separator") + ClassPath.getClassPath();
    private static String receivedArguments = "";
    private static boolean debug = false;
    private static boolean verbose = false;
    private static boolean keepModified = false;
    private static boolean recompileAll = false;
    private StringBuffer threadOutput = new StringBuffer();
    private static long startTime;
    private static long endTime;
    private static SimpleDateFormat dateFormatter;
    private static String randomString;
    private static ArrayList<String> javaFilesToCompile;
    private static TreeSet<String> javaFilesToCompileAlreadyParsed;
    private static HashSet<String> classFilesToAnalize;
    private static HashMap<String, FileData> javaFilesTOfileInfo;
    private static HashMap<String, HashSet<String>> javaFilesTOimportedFilesWithoutExtension;
    private static ArrayList<String> typesOfLevel0;
    private static HashMap<String, String> typesOfLevel0TOjavaFiles;
    private static HashMap<String, ClassElementTypeInfo> annotationsTOelementTypeInfo;
    private static HashMap<String, Boolean> annotationsWithElementTypeBlockTOexistElementTypeMethod;
    private static HashMap<String, Boolean> annotationsWithElementTypeExpressionTOexistElementTypeMethod;
    private static ArrayList<String> annotationsClassFilesChangedToRestore;
    private static ArrayList<String> renamedJavaFiles;
    private static boolean isCompilationEnded;
    private static DecimalFormat decimalFormat;
    private HashMap<String, Annotation> runtimeVisibleAnnotationsStructures;
    private HashMap<String, Annotation> runtimeInvisibleAnnotationsStructures;
    private ArrayList<FieldExpressionAnnotation> vFeas = new ArrayList();
    private ArrayList<FieldExpressionAnnotation> invFeas = new ArrayList();
    private boolean isAnInitAlreadyVisited = false;
    private HashMap<String, Annotation> removedExpressionAnnotations;
    private HashMap<String, Annotation> removedFieldExpressionAnnotations;
    private String currFileNameOnThisThread = "";
    private static int status;

    private String randomString() {
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
        for (int i = 0; i < 20; ++i) {
            stringBuffer.append(cArray[(int)(Math.random() * 63.0 % 62.0)]);
        }
        return stringBuffer.toString();
    }

    private String addPath(String string) {
        if (string.indexOf("\\") == -1 && string.indexOf("/") == -1 && string.indexOf(File.separator) == -1) {
            return "." + File.separator + string;
        }
        return string;
    }

    private void printUsage() {
        System.out.println("Usage: atjavac <options> <javac options> <source file>");
        System.out.println("\twhere available options are:");
        System.out.println("\t-debug:         shows detailed compilation information");
        System.out.println("\t-verbose:       shows the compiler steps");
        System.out.println("\t-keep-modified: do not delete the temporary modified java files");
        System.out.println("\t-recompile-all: recompiles all the java files");
        System.out.println("all other switches are passed to javac compiler");
    }

    private void commandLineParse(String[] stringArray) {
        int n;
        if (stringArray.length == 0) {
            this.printUsage();
            System.exit(0);
        }
        for (n = 0; n < stringArray.length; ++n) {
            String string = stringArray[n];
            if (string.equals("-cp") || string.equals("-classpath")) {
                ++n;
                receivedClasspath = receivedClasspath + System.getProperty("path.separator") + string;
                continue;
            }
            if (string.equals("-debug")) {
                debug = true;
                continue;
            }
            if (string.equals("-keep-modified")) {
                keepModified = true;
                continue;
            }
            if (string.equals("-recompile-all")) {
                recompileAll = true;
                continue;
            }
            if (string.equals("-verbose")) {
                verbose = true;
                continue;
            }
            if (string.startsWith("-")) {
                receivedArguments = receivedArguments + " " + string;
                continue;
            }
            if (string.startsWith("-")) continue;
            if (string.endsWith(".java")) {
                javaFilesToCompile.add(this.addPath(string));
                continue;
            }
            System.out.println("atjavac: can only accept java source file as argument");
            System.exit(0);
        }
        if (javaFilesToCompile.size() == 0) {
            System.out.println("atjavac: no source file");
            this.printUsage();
            System.exit(0);
        }
        if (debug) {
            System.out.println("javaFilesToCompile =  ");
            for (n = 0; n < javaFilesToCompile.size(); ++n) {
                System.out.println(javaFilesToCompile.get(n));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void findAllRelatedClasses() throws ParseException {
        int n = 0;
        String string = "";
        for (n = 0; n < javaFilesToCompile.size(); ++n) {
            string = javaFilesToCompile.get(n);
            if (debug) {
                System.out.println("STARTED ANALYSIS OF: " + string);
            }
            if (string.endsWith("package-info.java")) {
                if (!debug) continue;
                System.out.println("skipping package-info.java");
                continue;
            }
            javaFilesToCompileAlreadyParsed.add(string);
            if (debug) {
                System.out.println("PARSING OF: " + string);
            }
            FileData fileData = new JaParser(string).CompilationUnit();
            javaFilesTOfileInfo.put(string, fileData);
            for (ClassData classData : fileData.getClasses()) {
                if (classData.getLevel() != 0) continue;
                String string2 = new File(string).getParent();
                if (string2 == null) {
                    string2 = ".";
                }
                Object object = typesOfLevel0;
                synchronized (object) {
                    if (!typesOfLevel0.contains(string2 + File.separator + classData.getName())) {
                        typesOfLevel0.add(string2 + File.separator + classData.getName());
                    }
                }
                object = classData.getName();
                HashMap<String, String> hashMap = typesOfLevel0TOjavaFiles;
                synchronized (hashMap) {
                    while (typesOfLevel0TOjavaFiles.containsKey(object)) {
                        object = "+" + (String)object;
                    }
                    typesOfLevel0TOjavaFiles.put((String)object, string);
                }
            }
            if (debug) {
                System.out.println("Types of level 0 (each of them will make a class file):\n\t" + typesOfLevel0);
            }
            if (debug) {
                System.out.println("FINDING ALL FILES USED BY: " + string);
            }
            Main.searchCorrelatedFiles(string, fileData);
        }
    }

    public static void main(String[] stringArray) throws Throwable {
        Main main = new Main(stringArray);
    }

    public Main(String string) {
        this.currFileNameOnThisThread = string;
    }

    public Main(String[] stringArray) {
        boolean bl = false;
        this.commandLineParse(stringArray);
        startTime = new Date().getTime();
        randomString = this.randomString();
        try {
            this.findAllRelatedClasses();
            this.compilerPhase1();
            this.compilerPhase2(stringArray);
            this.compilerPhase3();
        }
        catch (ParseException parseException) {
            if (parseException.getMessage().startsWith("\nPARSING ERROR:")) {
                System.out.println(parseException.getMessage());
                this.exceptionManagement("");
            } else {
                System.out.println("PARSING ERROR: " + parseException.getMessage());
                this.exceptionManagement("\nERROR: there was some error during the parsing of: ");
            }
        }
        catch (TokenMgrError tokenMgrError) {
            System.out.println("PARSING ERROR: " + tokenMgrError.getMessage());
            this.exceptionManagement("\nERROR: there was some error during the parsing of: ");
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            this.exceptionManagement("");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compilerPhase1() throws Exception {
        int n;
        status = 0;
        Main[] mainArray = new Main[javaFilesToCompile.size()];
        for (n = 0; n < javaFilesToCompile.size(); ++n) {
            mainArray[n] = new Main(javaFilesToCompile.get(n));
            mainArray[n].start();
        }
        for (n = 0; n < javaFilesToCompile.size(); ++n) {
            mainArray[n].join();
        }
        if (debug) {
            System.out.println("FINDING ALL THE ANNOTATIONS AND THEIR TYPE IN ALL CLASS FILES");
        }
        for (String string : typesOfLevel0) {
            if (!classFilesToAnalize.contains(string + ".class")) continue;
            classFilesToAnalize.remove(string + ".class");
        }
        for (String string : classFilesToAnalize) {
            if (debug) {
                System.out.println("ANALYZING FILE: " + string);
            }
            String string2 = ClassPath.getClassPath() + System.getProperty("path.separator") + ".";
            if (string.indexOf(File.separator) > 0) {
                string2 = string2 + System.getProperty("path.separator") + string.substring(0, string.lastIndexOf(File.separator));
            }
            ClassPath classPath = new ClassPath(string2);
            Repository.setRepository((org.apache.bcel.util.Repository)SyntheticRepository.getInstance((ClassPath)classPath));
            JavaClass javaClass = Repository.lookupClass((String)string.substring(0, string.length() - 6));
            ConstantPool constantPool = javaClass.getConstantPool();
            if ((javaClass.getAccessFlags() & 0x2000) == 8192) {
                Object object;
                ClassElementTypeInfo classElementTypeInfo;
                block35: {
                    int n2;
                    if (debug) {
                        System.out.println("is an annotation");
                    }
                    classElementTypeInfo = new ClassElementTypeInfo(string.substring(0, string.length() - 6));
                    Attribute[] attributeArray = javaClass.getAttributes();
                    for (n2 = 0; n2 < attributeArray.length && !constantPool.constantToString(constantPool.getConstant(attributeArray[n2].getNameIndex())).equals("RuntimeVisibleAnnotations"); ++n2) {
                    }
                    if (n2 < attributeArray.length) {
                        int n3;
                        object = (AnnotationsAttribute)attributeArray[n2];
                        for (n3 = 0; n3 < ((AnnotationsAttribute)((Object)object)).getAnnotations().length && !((AnnotationsAttribute)((Object)object)).getAnnotations()[n3].getCleanedType().equals("Target"); ++n3) {
                        }
                        if (n3 < ((AnnotationsAttribute)((Object)object)).getAnnotations().length) {
                            int n4;
                            classElementTypeInfo.setExistTarget();
                            Object[] objectArray = (Object[])((AnnotationsAttribute)((Object)object)).getAnnotations()[n3].getElementValuePair(0).getElementValue().getValue();
                            for (n4 = 0; n4 < objectArray.length; ++n4) {
                                if (!((Object[])((ElementValue)objectArray[n4]).getValue())[1].equals("METHOD")) continue;
                                classElementTypeInfo.setExistElementTypeMethod();
                                break;
                            }
                            for (n4 = 0; n4 < attributeArray.length && !constantPool.constantToString(constantPool.getConstant(attributeArray[n4].getNameIndex())).equals(ELEMENT_TYPE_BLOCK_ATTRIBUTE_NAME); ++n4) {
                            }
                            if (n4 < attributeArray.length) {
                                classElementTypeInfo.setExistElementTypeBlock();
                            }
                            for (n4 = 0; n4 < attributeArray.length && !constantPool.constantToString(constantPool.getConstant(attributeArray[n4].getNameIndex())).equals(ELEMENT_TYPE_EXPRESSION_ATTRIBUTE_NAME); ++n4) {
                            }
                            if (n4 < attributeArray.length) {
                                classElementTypeInfo.setExistElementTypeExpression();
                            }
                            if (debug) {
                                if (classElementTypeInfo.existElementTypeBlock()) {
                                    System.out.println("It has ElementType.BLOCK");
                                }
                                if (classElementTypeInfo.existElementTypeExpression()) {
                                    System.out.println("It has ElementType.EXPRESSION");
                                }
                                if (classElementTypeInfo.existElementTypeMethod()) {
                                    System.out.println("It has ElementType.METHOD");
                                }
                            }
                            if ((classElementTypeInfo.existElementTypeBlock() || classElementTypeInfo.existElementTypeExpression()) && !classElementTypeInfo.existElementTypeMethod()) {
                                if (debug) {
                                    System.out.println("It has only ElementType.BLOCK or EXPRESSION: ElementType.METHOD will be temporary added to allow the compilation of the modified source code");
                                }
                                annotationsClassFilesChangedToRestore.add(string);
                                ConstantPoolGen constantPoolGen = new ConstantPoolGen(javaClass.getConstantPool());
                                constantPoolGen.addUtf8("Ljava/lang/annotation/ElementType;");
                                constantPoolGen.addUtf8("METHOD");
                                javaClass.setConstantPool(constantPoolGen.getFinalConstantPool());
                                constantPool = javaClass.getConstantPool();
                                objectArray = (Object[])((AnnotationsAttribute)((Object)object)).getAnnotations()[n3].getElementValuePair(0).getElementValue().getValue();
                                Object[] objectArray2 = new Object[objectArray.length + 1];
                                for (int i = 0; i < objectArray.length; ++i) {
                                    objectArray2[i] = objectArray[i];
                                }
                                Object[] objectArray3 = new Object[]{"Ljava/lang/annotation/ElementType;", "METHOD"};
                                objectArray2[objectArray.length] = new ElementValue(101, objectArray3);
                                object.setConstantPool(constantPoolGen.getConstantPool());
                                ((AnnotationsAttribute)((Object)object)).getAnnotations()[n3].getElementValuePair(0).getElementValue().setValue(objectArray2);
                                attributeArray[n2] = object;
                                javaClass.setAttributes(attributeArray);
                                constantPool = javaClass.getConstantPool();
                                try {
                                    javaClass.dump(string);
                                    if (debug) {
                                        System.out.println("Insertion completed with success");
                                    }
                                }
                                catch (IOException iOException) {
                                    iOException.printStackTrace();
                                    if (debug) {
                                        this.exceptionManagement("ERROR: the insertion is failed");
                                        break block35;
                                    }
                                    this.exceptionManagement("ERROR: is failed the insertion of ElementType.METHOD in '" + string + "'");
                                }
                            }
                        } else if (debug) {
                            System.out.println("It doesn't contain @Target: you can use this annotation everywhere, also as BlockAnnotations");
                        }
                    }
                }
                object = string.indexOf(File.separator) > 0 ? string.substring(string.lastIndexOf(File.separator) + 1, string.length() - 6) : string.substring(0, string.length() - 6);
                HashMap<String, ClassElementTypeInfo> hashMap = annotationsTOelementTypeInfo;
                synchronized (hashMap) {
                    while (annotationsTOelementTypeInfo.containsKey(object)) {
                        object = "+" + (String)object;
                    }
                    annotationsTOelementTypeInfo.put((String)object, classElementTypeInfo);
                    continue;
                }
            }
            if (!debug) continue;
            System.out.println("This class file doesn't define an annotation");
        }
    }

    private void compilerPhase2(String[] stringArray) throws Exception {
        if (debug) {
            System.out.println("\n\n--------------------------------------------------------------------------------");
            System.out.println("CHECK OF THE USE OF ANNOTATIONS WITH ElementType.BLOCK");
        }
        status = 2;
        Main[] mainArray = new Main[javaFilesToCompileAlreadyParsed.size()];
        int n = 0;
        for (String object2 : javaFilesToCompileAlreadyParsed) {
            mainArray[n] = new Main(object2);
            mainArray[n].start();
            ++n;
        }
        for (int i = 0; i < n; ++i) {
            mainArray[i].join();
        }
        if (verbose) {
            endTime = new Date().getTime();
            System.out.println("END OF THE FIRST FASE: modification of the source code (after " + dateFormatter.format(new Date(endTime - startTime)) + ")");
        }
        Runtime runtime = Runtime.getRuntime();
        if (debug) {
            System.out.println("COMPILATION: javac -cp " + receivedClasspath + receivedArguments + " " + stringArray[stringArray.length - 1] + "\n");
        }
        Process process = runtime.exec("javac -cp " + receivedClasspath + receivedArguments + " " + stringArray[stringArray.length - 1]);
        StreamGobbler streamGobbler = new StreamGobbler(process.getErrorStream());
        StreamGobbler streamGobbler2 = new StreamGobbler(process.getInputStream());
        streamGobbler.start();
        streamGobbler2.start();
        int n2 = process.waitFor();
        isCompilationEnded = true;
        if (verbose) {
            endTime = new Date().getTime();
            System.out.println("END OF THE SECOND FASE: compilation with javac (after " + dateFormatter.format(new Date(endTime - startTime)) + ")\n");
        }
    }

    private void compilerPhase3() throws Exception {
        for (int i = 0; i < typesOfLevel0.size(); ++i) {
            if (debug) {
                System.out.println("\n\n--------------------------------------------------------------------------------");
            }
            Stack<String> stack = new Stack<String>();
            HashSet<String> hashSet = new HashSet<String>();
            stack.push(typesOfLevel0.get(i));
            hashSet.add(typesOfLevel0.get(i));
            this.changeBytecode(stack, hashSet);
        }
        if (debug) {
            System.out.println("RESTORATION OF ANNOTATION CLASS FILES PREVIOUSLY MODIFIED (adding ElementType.METHOD)");
        }
        this.classFilesNotRecompiledButModifiedRestoration(true);
        this.restoreOriginalFiles(keepModified);
        if (verbose) {
            endTime = new Date().getTime();
            System.out.println("END OF THE THIRD FASE: modification of the class files (after " + dateFormatter.format(new Date(endTime - startTime)) + ")");
            System.out.println("COMPILATION COMPLETED WITH SUCCESS");
        }
    }

    @Override
    public void run() {
        String string = this.currFileNameOnThisThread;
        try {
            if (status == 0) {
                this.run_status0(string);
            } else if (status == 2) {
                this.run_status2(string);
            }
            System.out.print(this.threadOutput.toString());
        }
        catch (ElementTypeMethodException elementTypeMethodException) {
            this.exceptionManagement("");
        }
        catch (ElementTypeBlockException elementTypeBlockException) {
            this.exceptionManagement("");
        }
        catch (ElementTypeExpressionException elementTypeExpressionException) {
            this.exceptionManagement("");
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            this.exceptionManagement("");
        }
    }

    private void run_status0(String string) throws Exception {
        Object[] objectArray;
        Object object;
        String string2 = "";
        try {
            if (debug) {
                this.threadOutput.append("STARTED MODIFICATION OF THE SOURCE CODE OF: " + string + "\n");
                this.threadOutput.append("READING OF THE SOURCE CODE OF: " + string + "\n");
            }
            object = new FileInputStream(string).getChannel();
            objectArray = ByteBuffer.allocate((int)((FileChannel)object).size());
            ((FileChannel)object).read((ByteBuffer)objectArray);
            ((AbstractInterruptibleChannel)object).close();
            objectArray.flip();
            string2 = new String(objectArray.array());
            if (debug) {
                this.threadOutput.append("FILE READ SUCCESFULLY\n");
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            this.exceptionManagement("\nERROR: reading file: " + string + "\n");
        }
        object = new File(string.substring(0, string.lastIndexOf(".")) + "_ORIGINAL_by_atjavac.tmp");
        new File(string).renameTo((File)object);
        renamedJavaFiles.add(string);
        if (debug) {
            this.threadOutput.append("MODIFICATION OF THE SOURCE CODE OF: " + string + "\n");
        }
        objectArray = this.getSourceCodeReplacement(string, string2, javaFilesTOfileInfo.get(string));
        Arrays.sort(objectArray);
        StringBuffer stringBuffer = new StringBuffer(string2);
        for (Object object2 : objectArray) {
            if (((SourceCodeReplacement)object2).getEndInsert() == 0 || ((SourceCodeReplacement)object2).getStartInsert() == ((SourceCodeReplacement)object2).getEndInsert()) {
                stringBuffer = stringBuffer.insert(((SourceCodeReplacement)object2).getStartInsert(), ((SourceCodeReplacement)object2).getText());
                continue;
            }
            String string3 = "";
            for (int i = 0; i < ((SourceCodeReplacement)object2).getNumLine(); ++i) {
                string3 = string3 + "\n";
            }
            stringBuffer = new StringBuffer().append(stringBuffer.substring(0, ((SourceCodeReplacement)object2).getStartInsert()) + ((SourceCodeReplacement)object2).getText() + string3 + stringBuffer.substring(((SourceCodeReplacement)object2).getEndInsert()));
        }
        string2 = stringBuffer.toString();
        try {
            if (debug) {
                this.threadOutput.append("INSERTION OF THE NEW SOURCE CODE INTO: " + string + "\n");
            }
            FileChannel fileChannel = new FileOutputStream(string).getChannel();
            ByteBuffer byteBuffer = ByteBuffer.wrap(string2.getBytes());
            fileChannel.write(byteBuffer);
            fileChannel.close();
            if (debug) {
                this.threadOutput.append("Creation completed with success\n");
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            this.exceptionManagement("\nERROR: writing file: " + string + "\n");
        }
    }

    private void run_status2(String string) throws Exception {
        String string2 = "";
        if (debug) {
            this.threadOutput.append("Checking the file: " + string + "\n");
        }
        FileData fileData = javaFilesTOfileInfo.get(string);
        for (ClassData classData : fileData.getClasses()) {
            Object object;
            FileData fileData2;
            Object object2;
            String string3;
            for (StringIntInt stringIntInt : classData.getAllMethodAnnotationsWithoutDuplicates()) {
                if (stringIntInt.getString().indexOf(".") > -1) {
                    string3 = stringIntInt.getString().replace(".", File.separator);
                    object2 = stringIntInt.getString().substring(stringIntInt.getString().lastIndexOf(".") + 1);
                    fileData2 = javaFilesTOfileInfo.get(string3 + ".java");
                    if (fileData2 != null) {
                        if (!fileData2.getClass((String)object2).isTargetDefined() || fileData2.getClass((String)object2).existElementTypeMethod()) continue;
                        throw new ElementTypeMethodException(string, stringIntInt.getInt1(), stringIntInt.getInt2(), (String)object2, fileData2.getFileName());
                    }
                    object = object2;
                    while (annotationsTOelementTypeInfo.containsKey(object) && !annotationsTOelementTypeInfo.get(object).getNameWithPath().equals(string3)) {
                        object = "+" + (String)object;
                    }
                    if (!annotationsTOelementTypeInfo.containsKey(object) || !annotationsTOelementTypeInfo.get(object).existTarget() || annotationsTOelementTypeInfo.get(object).existElementTypeMethod()) continue;
                    throw new ElementTypeMethodException(string, stringIntInt.getInt1(), stringIntInt.getInt2(), (String)object2, string3);
                }
                string3 = stringIntInt.getString();
                while (typesOfLevel0TOjavaFiles.containsKey(string3) && !typesOfLevel0TOjavaFiles.get(string3).equals(string) && !javaFilesTOimportedFilesWithoutExtension.get(string).contains(typesOfLevel0TOjavaFiles.get(string3).substring(0, typesOfLevel0TOjavaFiles.get(string3).lastIndexOf(".")))) {
                    string3 = "+" + string3;
                }
                if (typesOfLevel0TOjavaFiles.containsKey(string3)) {
                    object2 = javaFilesTOfileInfo.get(typesOfLevel0TOjavaFiles.get(stringIntInt.getString()));
                    if (!((FileData)object2).getClass(stringIntInt.getString()).isTargetDefined() || ((FileData)object2).getClass(stringIntInt.getString()).existElementTypeMethod()) continue;
                    throw new ElementTypeMethodException(string, stringIntInt.getInt1(), stringIntInt.getInt2(), stringIntInt.getString(), ((FileData)object2).getFileName());
                }
                string3 = stringIntInt.getString();
                while (annotationsTOelementTypeInfo.containsKey(string3) && !javaFilesTOimportedFilesWithoutExtension.get(string).contains(annotationsTOelementTypeInfo.get(string3).getNameWithPath())) {
                    string3 = "+" + string3;
                }
                if (!annotationsTOelementTypeInfo.containsKey(string3) || !annotationsTOelementTypeInfo.get(string3).existTarget() || annotationsTOelementTypeInfo.get(string3).existElementTypeMethod()) continue;
                throw new ElementTypeMethodException(string, stringIntInt.getInt1(), stringIntInt.getInt2(), stringIntInt.getString(), annotationsTOelementTypeInfo.get(string3).getNameWithPath());
            }
            for (StringIntInt stringIntInt : classData.getAllBlockAnnotationsWithoutDuplicates()) {
                if (stringIntInt.getString().indexOf(".") > -1) {
                    string3 = stringIntInt.getString().replace(".", File.separator);
                    object2 = stringIntInt.getString().substring(stringIntInt.getString().lastIndexOf(".") + 1);
                    fileData2 = javaFilesTOfileInfo.get(string3 + ".java");
                    if (fileData2 != null) {
                        if (!fileData2.getClass((String)object2).existTarget() || fileData2.getClass((String)object2).existElementTypeBlock()) continue;
                        throw new ElementTypeBlockException(string, stringIntInt.getInt1(), stringIntInt.getInt2(), (String)object2, string3);
                    }
                    object = object2;
                    while (annotationsTOelementTypeInfo.containsKey(object) && !annotationsTOelementTypeInfo.get(object).getNameWithPath().equals(string3)) {
                        object = "+" + (String)object;
                    }
                    if (annotationsTOelementTypeInfo.containsKey(object)) {
                        if (!annotationsTOelementTypeInfo.get(object).existTarget() || annotationsTOelementTypeInfo.get(object).existElementTypeBlock()) continue;
                        throw new ElementTypeBlockException(string, stringIntInt.getInt1(), stringIntInt.getInt2(), (String)object2, string3);
                    }
                    throw new ElementTypeBlockException("ERROR: " + string + ", row " + stringIntInt.getInt1() + ", column " + stringIntInt.getInt2() + ": the annotation '" + string3 + "', used as BlockAnnotation, it wasn't found by this compiler");
                }
                string3 = stringIntInt.getString();
                while (typesOfLevel0TOjavaFiles.containsKey(string3) && !typesOfLevel0TOjavaFiles.get(string3).equals(string) && !javaFilesTOimportedFilesWithoutExtension.get(string).contains(typesOfLevel0TOjavaFiles.get(string3).substring(0, typesOfLevel0TOjavaFiles.get(string3).lastIndexOf(".")))) {
                    string3 = "+" + string3;
                }
                if (typesOfLevel0TOjavaFiles.containsKey(string3)) {
                    object2 = javaFilesTOfileInfo.get(typesOfLevel0TOjavaFiles.get(stringIntInt.getString()));
                    if (!((FileData)object2).getClass(stringIntInt.getString()).existTarget() || ((FileData)object2).getClass(stringIntInt.getString()).existElementTypeBlock()) continue;
                    throw new ElementTypeBlockException(string, stringIntInt.getInt1(), stringIntInt.getInt2(), stringIntInt.getString(), ((FileData)object2).getFileName());
                }
                string3 = stringIntInt.getString();
                while (annotationsTOelementTypeInfo.containsKey(string3) && !javaFilesTOimportedFilesWithoutExtension.get(string).contains(annotationsTOelementTypeInfo.get(string3).getNameWithPath())) {
                    string3 = "+" + string3;
                }
                if (annotationsTOelementTypeInfo.containsKey(string3)) {
                    if (!annotationsTOelementTypeInfo.get(string3).existTarget() || annotationsTOelementTypeInfo.get(string3).existElementTypeBlock()) continue;
                    throw new ElementTypeBlockException(string, stringIntInt.getInt1(), stringIntInt.getInt2(), stringIntInt.getString(), annotationsTOelementTypeInfo.get(string3).getNameWithPath());
                }
                throw new ElementTypeBlockException("ERROR: " + string + ", row " + stringIntInt.getInt1() + ", column " + stringIntInt.getInt2() + ": the annotation '" + stringIntInt.getString() + "', used as BlockAnnotation, it wasn't found by this compiler");
            }
            for (StringIntInt stringIntInt : classData.getAllExpressionAnnotationsWithoutDuplicates()) {
                if (stringIntInt.getString().indexOf(".") > -1) {
                    string3 = stringIntInt.getString().replace(".", File.separator);
                    object2 = stringIntInt.getString().substring(stringIntInt.getString().lastIndexOf(".") + 1);
                    fileData2 = javaFilesTOfileInfo.get(string3 + ".java");
                    if (fileData2 != null) {
                        if (!fileData2.getClass((String)object2).existTarget() || fileData2.getClass((String)object2).existElementTypeExpression()) continue;
                        throw new ElementTypeExpressionException(string, stringIntInt.getInt1(), stringIntInt.getInt2(), (String)object2, string3);
                    }
                    object = object2;
                    while (annotationsTOelementTypeInfo.containsKey(object) && !annotationsTOelementTypeInfo.get(object).getNameWithPath().equals(string3)) {
                        object = "+" + (String)object;
                    }
                    if (annotationsTOelementTypeInfo.containsKey(object)) {
                        if (!annotationsTOelementTypeInfo.get(object).existTarget() || annotationsTOelementTypeInfo.get(object).existElementTypeExpression()) continue;
                        throw new ElementTypeExpressionException(string, stringIntInt.getInt1(), stringIntInt.getInt2(), (String)object2, string3);
                    }
                    throw new ElementTypeExpressionException("ERROR: " + string + ", row " + stringIntInt.getInt1() + ", column " + stringIntInt.getInt2() + ": the annotation '" + string3 + "', used as ExpressionAnnotation, it wasn't found by this compiler");
                }
                string3 = stringIntInt.getString();
                while (typesOfLevel0TOjavaFiles.containsKey(string3) && !typesOfLevel0TOjavaFiles.get(string3).equals(string) && !javaFilesTOimportedFilesWithoutExtension.get(string).contains(typesOfLevel0TOjavaFiles.get(string3).substring(0, typesOfLevel0TOjavaFiles.get(string3).lastIndexOf(".")))) {
                    string3 = "+" + string3;
                }
                if (typesOfLevel0TOjavaFiles.containsKey(string3)) {
                    object2 = javaFilesTOfileInfo.get(typesOfLevel0TOjavaFiles.get(stringIntInt.getString()));
                    if (!((FileData)object2).getClass(stringIntInt.getString()).existTarget() || ((FileData)object2).getClass(stringIntInt.getString()).existElementTypeExpression()) continue;
                    throw new ElementTypeExpressionException(string, stringIntInt.getInt1(), stringIntInt.getInt2(), stringIntInt.getString(), ((FileData)object2).getFileName());
                }
                string3 = stringIntInt.getString();
                while (annotationsTOelementTypeInfo.containsKey(string3) && !javaFilesTOimportedFilesWithoutExtension.get(string).contains(annotationsTOelementTypeInfo.get(string3).getNameWithPath())) {
                    string3 = "+" + string3;
                }
                if (annotationsTOelementTypeInfo.containsKey(string3)) {
                    if (!annotationsTOelementTypeInfo.get(string3).existTarget() || annotationsTOelementTypeInfo.get(string3).existElementTypeExpression()) continue;
                    throw new ElementTypeExpressionException(string, stringIntInt.getInt1(), stringIntInt.getInt2(), stringIntInt.getString(), annotationsTOelementTypeInfo.get(string3).getNameWithPath());
                }
                throw new ElementTypeExpressionException("ERROR: " + string + ", row " + stringIntInt.getInt1() + ", column " + stringIntInt.getInt2() + ": the annotation '" + string3.replace("+", "") + "', used as ExpressionAnnotation, it wasn't found by this compiler");
            }
        }
    }

    private static int searchIndexOfPosition(String string, int n, int n2) {
        int n3;
        --n;
        --n2;
        int n4 = 0;
        if (string.charAt(0) == '\n') {
            --n;
        }
        for (n3 = 0; n3 < n; ++n3) {
            n4 = string.indexOf("\n", n4 + 1);
        }
        ++n4;
        n3 = 0;
        for (int i = 0; i < n2 - n3; ++i) {
            if (string.charAt(n4 + i) != '\t') continue;
            n3 += 7 - (n3 + i) % 8;
        }
        return n4 + n2 - n3;
    }

    /*
     * WARNING - void declaration
     */
    private SourceCodeReplacement[] getSourceCodeReplacement(String string, String string2, FileData fileData) {
        Object object;
        int n = fileData.getNumBlockAnnotations() * 3 + fileData.getNumBlockAnnotationsWithReturnAsLastStatement() + fileData.getNumExpressionAndFieldExpressionAnnotations() + fileData.numExpressionAndFieldExpressionAnnotationsOfLevel0() + fileData.getNumClassWithElementTypeBlockOrElementTypeExpression();
        SourceCodeReplacement[] sourceCodeReplacementArray = new SourceCodeReplacement[n];
        int n2 = 0;
        for (ClassData classData : fileData.getClasses()) {
            int n3;
            int n4;
            String string3;
            Iterator<MethodData> iterator = classData.getStaticFieldExpressionAnnotationsDividedByLevel();
            object = ((ArrayList)((Object)iterator)).iterator();
            while (object.hasNext()) {
                FieldExpressionAnnotationData fieldExpressionAnnotationData = object.next();
                string3 = "";
                n4 = Main.searchIndexOfPosition(string2, fieldExpressionAnnotationData.getAnnotationStartLine(), fieldExpressionAnnotationData.getAnnotationStartColumn());
                n3 = Main.searchIndexOfPosition(string2, fieldExpressionAnnotationData.getBlockEndLine(), fieldExpressionAnnotationData.getBlockEndColumn());
                string3 = Main.getFeaReplacementString(fieldExpressionAnnotationData, string2, "SFEA");
                sourceCodeReplacementArray[n2] = new SourceCodeReplacement(string3, n4, n3 + 1, fieldExpressionAnnotationData.getAnnotationStartLine() - fieldExpressionAnnotationData.getBlockEndLine());
                ++n2;
            }
            iterator = classData.getNotStaticFieldExpressionAnnotationsDividedByLevel();
            object = ((ArrayList)((Object)iterator)).iterator();
            while (object.hasNext()) {
                FieldExpressionAnnotationData fieldExpressionAnnotationData = object.next();
                string3 = "";
                n4 = Main.searchIndexOfPosition(string2, fieldExpressionAnnotationData.getAnnotationStartLine(), fieldExpressionAnnotationData.getAnnotationStartColumn());
                n3 = Main.searchIndexOfPosition(string2, fieldExpressionAnnotationData.getBlockEndLine(), fieldExpressionAnnotationData.getBlockEndColumn());
                string3 = Main.getFeaReplacementString(fieldExpressionAnnotationData, string2, "NSFEA");
                sourceCodeReplacementArray[n2] = new SourceCodeReplacement(string3, n4, n3 + 1, fieldExpressionAnnotationData.getAnnotationStartLine() - fieldExpressionAnnotationData.getBlockEndLine());
                ++n2;
            }
            for (MethodData methodData : classData.getMethods()) {
                int n5;
                if (methodData.getNumCodeAnnotations() == 0) continue;
                int n6 = 0;
                BlockAnnotationData[] blockAnnotationDataArray = new BlockAnnotationData[methodData.getNumBlockAnnotations()];
                Iterator<CodeAnnotationData> iterator2 = methodData.getBlockAnnotations().iterator();
                while (iterator2.hasNext()) {
                    int n7;
                    void var17_51;
                    BlockAnnotationData blockAnnotationData;
                    blockAnnotationDataArray[n6] = blockAnnotationData = iterator2.next();
                    String string4 = "";
                    String string5 = blockAnnotationData.getAnnotationDeclaration();
                    n5 = blockAnnotationData.getLevel();
                    int n8 = blockAnnotationData.getAnnotationStartLine();
                    int n9 = blockAnnotationData.getAnnotationStartColumn();
                    int n10 = blockAnnotationData.getBlockStartLine();
                    int n11 = blockAnnotationData.getBlockStartColumn();
                    int n12 = blockAnnotationData.getBlockEndLine();
                    int n13 = blockAnnotationData.getBlockEndColumn();
                    String string6 = n8 + "-" + n9 + "-" + n12 + "-" + n13 + "-" + n5 + "-" + blockAnnotationData.isLastStatementAReturn() + "-" + StringEscapeUtils.escapeJava(string5.replace("\n", ""));
                    int n14 = Main.searchIndexOfPosition(string2, n8, n9);
                    int n15 = Main.searchIndexOfPosition(string2, n10, n11) + 1;
                    if (blockAnnotationData.isDoubleSquaresRequired()) {
                        String string7 = "{";
                    }
                    String string8 = (String)var17_51 + "atjavac.parser.util.CodeAnnotationCall.callStartBlockAnnotation(\"startBA-" + randomString + "-" + string6 + "\");";
                    sourceCodeReplacementArray[n2] = new SourceCodeReplacement(string8, n14, n15, n10 - n8);
                    ++n2;
                    if (!blockAnnotationData.isLastStatementAReturn()) {
                        void var17_55;
                        n7 = Main.searchIndexOfPosition(string2, blockAnnotationData.getBlockEndLine(), blockAnnotationData.getBlockEndColumn());
                        String string9 = "atjavac.parser.util.CodeAnnotationCall.callEndBlockAnnotation(\"endBA-" + randomString + "-" + string6 + "\");";
                        if (blockAnnotationData.isDoubleSquaresRequired()) {
                            String string10 = string9 + "}";
                        }
                        sourceCodeReplacementArray[n2] = new SourceCodeReplacement((String)var17_55, n7, n7 + 1, 0);
                        ++n2;
                    } else {
                        void var17_58;
                        n7 = Main.searchIndexOfPosition(string2, blockAnnotationData.getLastStatementStartLine(), blockAnnotationData.getLastStatementStartColumn());
                        String string11 = "atjavac.parser.util.CodeAnnotationCall.callEndBlockAnnotation(\"endBA-" + randomString + "-" + string6 + "\");";
                        if (blockAnnotationData.isDoubleSquaresRequired()) {
                            String string12 = string11 + "}";
                        }
                        sourceCodeReplacementArray[n2] = new SourceCodeReplacement((String)var17_58, n7, n7, 0);
                        int n16 = Main.searchIndexOfPosition(string2, blockAnnotationData.getBlockEndLine(), blockAnnotationData.getBlockEndColumn());
                        sourceCodeReplacementArray[++n2] = new SourceCodeReplacement("", n16, n16 + 1, 0);
                        ++n2;
                    }
                    ++n6;
                }
                ArrayList<ExpressionAnnotationData> arrayList = methodData.getExpressionAnnotationsDividedByLevel();
                for (ExpressionAnnotationData expressionAnnotationData : arrayList) {
                    String string13 = "";
                    int n17 = Main.searchIndexOfPosition(string2, expressionAnnotationData.getAnnotationStartLine(), expressionAnnotationData.getAnnotationStartColumn());
                    n5 = Main.searchIndexOfPosition(string2, expressionAnnotationData.getBlockEndLine(), expressionAnnotationData.getBlockEndColumn());
                    String string14 = Main.getEaReplacementString(expressionAnnotationData, string2);
                    sourceCodeReplacementArray[n2] = new SourceCodeReplacement(string14, n17, n5 + 1, expressionAnnotationData.getAnnotationStartLine() - expressionAnnotationData.getBlockEndLine());
                    ++n2;
                }
            }
        }
        for (ClassData classData : fileData.getClasses()) {
            for (FieldExpressionAnnotationData fieldExpressionAnnotationData : classData.getNotStaticFieldExpressionAnnotations()) {
                object = fieldExpressionAnnotationData.getAnnotationDeclaration() + " private void NSFEA_" + randomString + "_" + decimalFormat.format(fieldExpressionAnnotationData.getAnnotationStartLine()) + "_" + decimalFormat.format(fieldExpressionAnnotationData.getAnnotationStartColumn()) + "(){} ";
                int n18 = Main.searchIndexOfPosition(string2, classData.getEndRow(), classData.getEndColumn()) - 1;
                sourceCodeReplacementArray[n2] = new SourceCodeReplacement((String)object, n18, n18, 0);
                ++n2;
            }
            for (FieldExpressionAnnotationData fieldExpressionAnnotationData : classData.getStaticFieldExpressionAnnotations()) {
                object = fieldExpressionAnnotationData.getAnnotationDeclaration() + " private void SFEA_" + randomString + "_" + decimalFormat.format(fieldExpressionAnnotationData.getAnnotationStartLine()) + "_" + decimalFormat.format(fieldExpressionAnnotationData.getAnnotationStartColumn()) + "(){} ";
                int n19 = Main.searchIndexOfPosition(string2, classData.getEndRow(), classData.getEndColumn()) - 1;
                sourceCodeReplacementArray[n2] = new SourceCodeReplacement((String)object, n19, n19, 0);
                ++n2;
            }
            for (MethodData methodData : classData.getMethods()) {
                int n20;
                String string15;
                for (BlockAnnotationData blockAnnotationData : methodData.getBlockAnnotations()) {
                    string15 = blockAnnotationData.getAnnotationDeclaration() + " private void BA_" + randomString + "_" + decimalFormat.format(blockAnnotationData.getAnnotationStartLine()) + "_" + decimalFormat.format(blockAnnotationData.getAnnotationStartColumn()) + "(){} ";
                    n20 = Main.searchIndexOfPosition(string2, methodData.getEndLine(), methodData.getEndColumn()) + 1;
                    sourceCodeReplacementArray[n2] = new SourceCodeReplacement(string15, n20, n20, 0);
                    ++n2;
                }
                for (ExpressionAnnotationData expressionAnnotationData : methodData.getExpressionAnnotations()) {
                    string15 = expressionAnnotationData.getAnnotationDeclaration() + " private void EA_" + randomString + "_" + decimalFormat.format(expressionAnnotationData.getAnnotationStartLine()) + "_" + decimalFormat.format(expressionAnnotationData.getAnnotationStartColumn()) + "(){} ";
                    n20 = Main.searchIndexOfPosition(string2, methodData.getEndLine(), methodData.getEndColumn()) + 1;
                    sourceCodeReplacementArray[n2] = new SourceCodeReplacement(string15, n20, n20, 0);
                    ++n2;
                }
            }
        }
        for (ClassData classData : fileData.getClasses()) {
            int n21;
            void var12_31;
            void var10_18;
            if (!classData.existElementTypeBlock() && !classData.existElementTypeExpression()) continue;
            int n22 = 0;
            int n23 = 0;
            int n24 = 0;
            int n25 = 0;
            if (classData.existElementTypeBlock()) {
                annotationsWithElementTypeBlockTOexistElementTypeMethod.put(new File(string).getParent() + File.separator + classData.getName(), classData.existElementTypeMethod());
                if (debug) {
                    this.threadOutput.append("Contain the annotation '" + classData.getName() + "' which has ElementType.BLOCK in his @Target\n");
                }
                n22 = Main.searchIndexOfPosition(string2, classData.getElementTypeBlockStartLine(), classData.getElementTypeBlockStartColumn());
                n23 = Main.searchIndexOfPosition(string2, classData.getElementTypeBlockEndLine(), classData.getElementTypeBlockEndColumn() + 1);
                n24 = classData.getElementTypeBlockStartLine();
                n25 = classData.getElementTypeBlockEndLine();
            }
            if (classData.existElementTypeExpression()) {
                annotationsWithElementTypeExpressionTOexistElementTypeMethod.put(new File(string).getParent() + File.separator + classData.getName(), classData.existElementTypeMethod());
                if (debug) {
                    this.threadOutput.append("Contain the annotation '" + classData.getName() + "' which has ElementType.EXPRESSION in his @Target\n");
                }
                n22 = Main.searchIndexOfPosition(string2, classData.getElementTypeExpressionStartLine(), classData.getElementTypeExpressionStartColumn());
                n23 = Main.searchIndexOfPosition(string2, classData.getElementTypeExpressionEndLine(), classData.getElementTypeExpressionEndColumn() + 1);
                n24 = classData.getElementTypeExpressionStartLine();
                n25 = classData.getElementTypeExpressionEndLine();
            }
            while (n22 > 0) {
                if (string2.charAt(n22) == '\n') {
                    --n24;
                } else if (string2.charAt(n22) == '{' || string2.charAt(n22) == '(') break;
                --n22;
            }
            while (var10_18 < string2.length()) {
                if (string2.charAt((int)var10_18) == '\n') {
                    ++var12_31;
                } else if (string2.charAt((int)var10_18) == '}' || string2.charAt((int)var10_18) == ')') break;
                ++var10_18;
            }
            if ((n21 = var12_31 - n24) < 0) {
                n21 = 0;
            }
            StringBuffer stringBuffer = new StringBuffer();
            String string16 = "ElementType.";
            if (fileData.isElementTypeStaticImported()) {
                string16 = "";
            }
            for (StringIntInt stringIntInt : classData.getStandardElementTypes()) {
                stringBuffer.append(string16).append(stringIntInt.getString()).append(",");
            }
            if (!classData.existElementTypeMethod()) {
                stringBuffer.append(string16).append("METHOD,");
            }
            stringBuffer.deleteCharAt(stringBuffer.length() - 1);
            sourceCodeReplacementArray[n2] = new SourceCodeReplacement(stringBuffer.toString(), n22 + 1, (int)var10_18, n21);
            ++n2;
        }
        return sourceCodeReplacementArray;
    }

    private static String getEaReplacementString(ExpressionAnnotationData expressionAnnotationData, String string) {
        int n;
        int n2 = Main.searchIndexOfPosition(string, expressionAnnotationData.getBlockStartLine(), expressionAnnotationData.getBlockStartColumn()) + 1;
        int n3 = Main.searchIndexOfPosition(string, expressionAnnotationData.getBlockEndLine(), expressionAnnotationData.getBlockEndColumn());
        String string2 = "";
        for (n = 0; n < expressionAnnotationData.getBlockStartLine() - expressionAnnotationData.getAnnotationStartLine(); ++n) {
            string2 = string2 + "\n";
        }
        n = n2 - 1;
        ArrayList<ExpressionAnnotationData> arrayList = expressionAnnotationData.getExpressionAnnotation();
        for (int i = 0; i < expressionAnnotationData.getNumExpressionAnnotation(); ++i) {
            int n4 = Main.searchIndexOfPosition(string, arrayList.get(i).getAnnotationStartLine(), arrayList.get(i).getAnnotationStartColumn());
            int n5 = Main.searchIndexOfPosition(string, arrayList.get(i).getBlockEndLine(), arrayList.get(i).getBlockEndColumn());
            string2 = string2 + string.substring(n + 1, n4) + Main.getEaReplacementString(arrayList.get(i), string);
            n = n5;
        }
        string2 = string2 + string.substring(n + 1, n3);
        String string3 = expressionAnnotationData.getAnnotationStartLine() + "-" + expressionAnnotationData.getAnnotationStartColumn() + "-" + expressionAnnotationData.getBlockEndLine() + "-" + expressionAnnotationData.getBlockEndColumn() + "-" + expressionAnnotationData.getLevel() + "-" + StringEscapeUtils.escapeJava(expressionAnnotationData.getAnnotationDeclaration().replace("\n", ""));
        string2 = "atjavac.parser.util.CodeAnnotationCall.wrapperExpressionAnnotation(\"startEA-" + randomString + "-" + string3 + "\", " + string2 + ", \"endEA-" + randomString + "-" + string3 + "\")";
        return string2;
    }

    private static String getFeaReplacementString(FieldExpressionAnnotationData fieldExpressionAnnotationData, String string, String string2) {
        int n;
        int n2 = Main.searchIndexOfPosition(string, fieldExpressionAnnotationData.getBlockStartLine(), fieldExpressionAnnotationData.getBlockStartColumn()) + 1;
        int n3 = Main.searchIndexOfPosition(string, fieldExpressionAnnotationData.getBlockEndLine(), fieldExpressionAnnotationData.getBlockEndColumn());
        String string3 = "";
        for (n = 0; n < fieldExpressionAnnotationData.getBlockStartLine() - fieldExpressionAnnotationData.getAnnotationStartLine(); ++n) {
            string3 = string3 + "\n";
        }
        n = n2 - 1;
        ArrayList<FieldExpressionAnnotationData> arrayList = fieldExpressionAnnotationData.getFieldExpressionAnnotation();
        for (int i = 0; i < fieldExpressionAnnotationData.getNumFieldExpressionAnnotation(); ++i) {
            int n4 = Main.searchIndexOfPosition(string, arrayList.get(i).getAnnotationStartLine(), arrayList.get(i).getAnnotationStartColumn());
            int n5 = Main.searchIndexOfPosition(string, arrayList.get(i).getBlockEndLine(), arrayList.get(i).getBlockEndColumn());
            string3 = string3 + string.substring(n + 1, n4) + Main.getFeaReplacementString(arrayList.get(i), string, string2);
            n = n5;
        }
        string3 = string3 + string.substring(n + 1, n3);
        String string4 = fieldExpressionAnnotationData.getAnnotationStartLine() + "-" + fieldExpressionAnnotationData.getAnnotationStartColumn() + "-" + fieldExpressionAnnotationData.getBlockEndLine() + "-" + fieldExpressionAnnotationData.getBlockEndColumn() + "-" + fieldExpressionAnnotationData.getLevel() + "-" + StringEscapeUtils.escapeJava(fieldExpressionAnnotationData.getAnnotationDeclaration().replace("\n", "")) + "-" + fieldExpressionAnnotationData.getFieldName();
        string3 = "atjavac.parser.util.CodeAnnotationCall.wrapperExpressionAnnotation(\"start" + string2 + "-" + randomString + "-" + string4 + "\", " + string3 + ", \"end" + string2 + "-" + randomString + "-" + string4 + "\")";
        return string3;
    }

    /*
     * WARNING - void declaration
     */
    private final void changeBytecode(Stack<String> stack, HashSet<String> hashSet) {
        block66: {
            String string = stack.pop();
            String string2 = string + "";
            if (debug) {
                System.out.println("CHANGE OF BYTECODE OF: " + string + ".class");
            }
            if (!new File(string + ".class").isFile()) {
                if (debug) {
                    System.out.println("The class wasn't been compiled (it is not used by the program).");
                }
            } else {
                String string3 = ClassPath.getClassPath() + System.getProperty("path.separator") + ".";
                if (string.indexOf(File.separator) > 0) {
                    string3 = string3 + System.getProperty("path.separator") + string.substring(0, string.lastIndexOf(File.separator));
                }
                ClassPath classPath = new ClassPath(string3);
                Repository.setRepository((org.apache.bcel.util.Repository)SyntheticRepository.getInstance((ClassPath)classPath));
                try {
                    MethodGen methodGen;
                    int n;
                    int n2;
                    InnerClass innerClass22;
                    int n3;
                    int n4;
                    JavaClass javaClass = Repository.lookupClass((String)string);
                    Method[] methodArray = javaClass.getMethods();
                    ConstantPool constantPool = javaClass.getConstantPool();
                    ConstantPoolGen constantPoolGen = new ConstantPoolGen(javaClass.getConstantPool());
                    Attribute[] attributeArray = javaClass.getAttributes();
                    for (n4 = 0; n4 < attributeArray.length && !constantPool.constantToString(constantPool.getConstant(attributeArray[n4].getNameIndex())).equals("InnerClasses"); ++n4) {
                    }
                    if (n4 < attributeArray.length) {
                        InnerClasses innerClasses = (InnerClasses)attributeArray[n4];
                        n3 = 0;
                        for (InnerClass innerClass22 : innerClasses.getInnerClasses()) {
                            String string4 = constantPool.constantToString(constantPool.getConstant(innerClass22.getInnerClassIndex())).replace(".", "/");
                            if (!hashSet.contains(string4)) {
                                stack.push(string4);
                                hashSet.add(string4);
                            }
                            ++n3;
                        }
                    }
                    int n5 = 0;
                    n3 = 0;
                    int n6 = 0;
                    int n7 = 0;
                    ArrayList<ClassFileMethodInfo> arrayList = new ArrayList<ClassFileMethodInfo>();
                    innerClass22 = new ArrayList();
                    int n8 = -1;
                    ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
                    ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
                    HashSet<Integer> hashSet2 = new HashSet<Integer>();
                    for (n2 = 0; n2 < methodArray.length; ++n2) {
                        if (methodArray[n2].getName().startsWith("BA_" + randomString)) {
                            ((ClassFileMethodInfo)arrayList.get(arrayList.size() - 1)).addBlockAnnotationMethodPosition(n2);
                            hashSet2.add(methodArray[n2].getNameIndex());
                            ++n5;
                            continue;
                        }
                        if (methodArray[n2].getName().startsWith("EA_" + randomString)) {
                            ((ClassFileMethodInfo)arrayList.get(arrayList.size() - 1)).addExpressionAnnotationMethodPosition(n2);
                            hashSet2.add(methodArray[n2].getNameIndex());
                            ++n3;
                            continue;
                        }
                        if (methodArray[n2].getName().startsWith("NSFEA_" + randomString)) {
                            arrayList2.add(n2);
                            hashSet2.add(methodArray[n2].getNameIndex());
                            ++n6;
                            continue;
                        }
                        if (methodArray[n2].getName().startsWith("SFEA_" + randomString)) {
                            arrayList3.add(n2);
                            hashSet2.add(methodArray[n2].getNameIndex());
                            ++n7;
                            continue;
                        }
                        if (methodArray[n2].getName().equals("<clinit>")) {
                            arrayList.add(new ClassFileMethodInfo(methodArray[n2].getName(), n2));
                            n8 = arrayList.size() - 1;
                            continue;
                        }
                        if (methodArray[n2].getName().equals("<init>")) {
                            arrayList.add(new ClassFileMethodInfo(methodArray[n2].getName(), n2));
                            innerClass22.add(arrayList.size() - 1);
                            continue;
                        }
                        arrayList.add(new ClassFileMethodInfo(methodArray[n2].getName(), n2));
                    }
                    if (arrayList3.size() != 0 && n8 != -1) {
                        ((ClassFileMethodInfo)arrayList.get(n8)).addFieldExpressionAnnotationMethodPositions(arrayList3);
                    }
                    if (arrayList2.size() != 0) {
                        Iterator iterator = innerClass22.iterator();
                        while (iterator.hasNext()) {
                            int n9 = (Integer)iterator.next();
                            ((ClassFileMethodInfo)arrayList.get(n9)).addFieldExpressionAnnotationMethodPositions(arrayList2);
                        }
                    }
                    if (n5 == 0 && n3 == 0 && n7 == 0 && n6 == 0 && !annotationsWithElementTypeBlockTOexistElementTypeMethod.containsKey(string) && !annotationsWithElementTypeExpressionTOexistElementTypeMethod.containsKey(string)) {
                        if (debug) {
                            System.out.println("The class doesn't contain Block/ExpressionAnnotations and ElementType.BLOCK/METHOD: the class file will not compiled");
                            System.out.println("--------------------------------------------------------------------------------");
                        }
                        break block66;
                    }
                    if (annotationsWithElementTypeBlockTOexistElementTypeMethod.containsKey(string) || annotationsWithElementTypeExpressionTOexistElementTypeMethod.containsKey(string)) {
                        Attribute[] attributeArray2 = javaClass.getAttributes();
                        for (n4 = 0; n4 < attributeArray2.length && !constantPool.constantToString(constantPool.getConstant(attributeArray2[n4].getNameIndex())).equals("RuntimeVisibleAnnotations"); ++n4) {
                        }
                        if (n4 < attributeArray2.length) {
                            AnnotationsAttribute annotationsAttribute = (AnnotationsAttribute)attributeArray2[n4];
                            for (n = 0; n < annotationsAttribute.getAnnotations().length && !annotationsAttribute.getAnnotations()[n].getCleanedType().equals("Target"); ++n) {
                            }
                            if (n < annotationsAttribute.getAnnotations().length) {
                                constantPoolGen.addUtf8("Ljava/lang/annotation/ElementType;");
                                constantPoolGen.addUtf8(ELEMENT_TYPE_BLOCK_ATTRIBUTE_NAME);
                                constantPoolGen.addUtf8(ELEMENT_TYPE_EXPRESSION_ATTRIBUTE_NAME);
                                javaClass.setConstantPool(constantPoolGen.getFinalConstantPool());
                                constantPool = javaClass.getConstantPool();
                                if (annotationsWithElementTypeBlockTOexistElementTypeMethod.containsKey(string) && !annotationsWithElementTypeBlockTOexistElementTypeMethod.get(string).booleanValue() || annotationsWithElementTypeExpressionTOexistElementTypeMethod.containsKey(string) && !annotationsWithElementTypeExpressionTOexistElementTypeMethod.get(string).booleanValue()) {
                                    methodGen = (Object[])annotationsAttribute.getAnnotations()[n].getElementValuePair(0).getElementValue().getValue();
                                    Object[] objectArray3 = new Object[((Attribute[])methodGen).length - 1];
                                    int n9 = 0;
                                    for (int i = 0; i < ((Attribute[])methodGen).length; ++i) {
                                        if (((Object[])((ElementValue)methodGen[i]).getValue())[1].equals("METHOD")) continue;
                                        objectArray3[n9] = methodGen[i];
                                        ++n9;
                                    }
                                    annotationsAttribute.setConstantPool(constantPoolGen.getConstantPool());
                                    annotationsAttribute.getAnnotations()[n].getElementValuePair(0).getElementValue().setValue(objectArray3);
                                    attributeArray2[n4] = annotationsAttribute;
                                    javaClass.setAttributes(attributeArray2);
                                    constantPool = javaClass.getConstantPool();
                                }
                                if (annotationsWithElementTypeBlockTOexistElementTypeMethod.containsKey(string)) {
                                    methodGen = new Attribute[attributeArray2.length + 1];
                                    boolean i = false;
                                    while (i < attributeArray2.length) {
                                        methodGen[i] = attributeArray2[i];
                                        ++i;
                                    }
                                    methodGen[attributeArray2.length] = new ElementTypeBLOCKAttribute(constantPoolGen.lookupUtf8(ELEMENT_TYPE_BLOCK_ATTRIBUTE_NAME), constantPool);
                                    attributeArray2 = methodGen;
                                    javaClass.setAttributes((Attribute[])methodGen);
                                    constantPool = javaClass.getConstantPool();
                                }
                                if (annotationsWithElementTypeExpressionTOexistElementTypeMethod.containsKey(string)) {
                                    void var27_52;
                                    methodGen = new Attribute[attributeArray2.length + 1];
                                    boolean bl = false;
                                    while (var27_52 < attributeArray2.length) {
                                        methodGen[var27_52] = attributeArray2[var27_52];
                                        ++var27_52;
                                    }
                                    methodGen[attributeArray2.length] = new ElementTypeEXPRESSIONAttribute(constantPoolGen.lookupUtf8(ELEMENT_TYPE_EXPRESSION_ATTRIBUTE_NAME), constantPool);
                                    attributeArray2 = methodGen;
                                    javaClass.setAttributes((Attribute[])methodGen);
                                    constantPool = javaClass.getConstantPool();
                                }
                            }
                        }
                    }
                    if (n5 + n3 + n7 + n6 > 0) {
                        Object[] objectArray2;
                        constantPoolGen.addUtf8("RuntimeVisibleBlockAnnotations");
                        constantPoolGen.addUtf8("RuntimeInvisibleBlockAnnotations");
                        constantPoolGen.addUtf8("RuntimeVisibleExpressionAnnotations");
                        constantPoolGen.addUtf8("RuntimeInvisibleExpressionAnnotations");
                        constantPoolGen.addUtf8("RuntimeVisibleFieldExpressionAnnotations");
                        constantPoolGen.addUtf8("RuntimeInvisibleFieldExpressionAnnotations");
                        javaClass.setConstantPool(constantPoolGen.getFinalConstantPool());
                        constantPool = javaClass.getConstantPool();
                        this.vFeas = new ArrayList();
                        this.invFeas = new ArrayList();
                        this.removedFieldExpressionAnnotations = new HashMap();
                        for (ClassFileMethodInfo classFileMethodInfo : arrayList) {
                            n = classFileMethodInfo.getPosition();
                            this.runtimeVisibleAnnotationsStructures = new HashMap();
                            this.runtimeInvisibleAnnotationsStructures = new HashMap();
                            this.removedExpressionAnnotations = new HashMap();
                            if (debug) {
                                if (classFileMethodInfo.getNumBlockAnnotation() + classFileMethodInfo.getNumExpressionAnnotation() == 0) {
                                    System.out.println("The method '" + methodArray[n].getName() + "' doesn't contain BlockAnnotations/ExpressionAnnotations");
                                } else {
                                    System.out.println("The method '" + methodArray[n].getName() + "' contain the following BlockAnnotations/ExpressionAnnotations:");
                                }
                            }
                            if (classFileMethodInfo.getNumBlockAnnotation() > 0) {
                                this.loadAnnotationsFromFictitiousMethodList(methodArray, constantPool, classFileMethodInfo.getBlockAnnotationMethodPosition(), "BA_");
                            }
                            if (classFileMethodInfo.getNumExpressionAnnotation() > 0) {
                                this.loadAnnotationsFromFictitiousMethodList(methodArray, constantPool, classFileMethodInfo.getExpressionAnnotationMethodPosition(), "EA_");
                            }
                            if (classFileMethodInfo.getNumFieldExpressionAnnotation() != 0) {
                                if (methodArray[n].getName().equals("<clinit>")) {
                                    if (debug) {
                                        System.out.println("The method '<clinit>' contain the initializations of the ExpressionAnnotations applied at the static fields of this class, that are:");
                                    }
                                    this.loadAnnotationsFromFictitiousMethodList(methodArray, constantPool, classFileMethodInfo.getFieldExpressionAnnotationMethodPosition(), "SFEA_");
                                } else if (methodArray[n].getName().equals("<init>")) {
                                    if (debug) {
                                        System.out.println("The method '<init>' contain the initializations of the ExpressionAnnotations applied at the not static fields of this class, that are:");
                                    }
                                    this.loadAnnotationsFromFictitiousMethodList(methodArray, constantPool, classFileMethodInfo.getFieldExpressionAnnotationMethodPosition(), "NSFEA_");
                                }
                            }
                            javaClass.setConstantPool(constantPoolGen.getFinalConstantPool());
                            methodGen = new MethodGen(methodArray[n], javaClass.getClassName(), constantPoolGen);
                            javaClass = this.removeCodeAnnotationsAndCreateAttribute(javaClass, methodGen, n, this.runtimeVisibleAnnotationsStructures, this.runtimeInvisibleAnnotationsStructures);
                            constantPool = javaClass.getConstantPool();
                            constantPoolGen = new ConstantPoolGen(constantPool);
                            if (this.removedExpressionAnnotations.size() <= 0) continue;
                            System.out.println("Class '" + string + "', method '" + methodArray[n].getName() + methodArray[n].getSignature() + "'\nThe following ExpressionAnnotations was been deleted by javac optimizations:");
                            Object[] objectArray = this.removedExpressionAnnotations.keySet().toArray();
                            Arrays.sort(objectArray);
                            for (Object object : objectArray) {
                                System.out.println("- line_column: " + object + "   -->   " + this.removedExpressionAnnotations.get(object));
                            }
                        }
                        if (this.removedFieldExpressionAnnotations.size() > 0) {
                            System.out.println("\nClass '" + string + "'\nThe following FieldExpressionAnnotations were been deleted by javac optimizations:");
                            objectArray2 = this.removedFieldExpressionAnnotations.keySet().toArray();
                            Arrays.sort(objectArray2);
                            for (Object object : objectArray2) {
                                System.out.println("- line_column: " + object + "   -->   " + this.removedFieldExpressionAnnotations.get(object));
                            }
                            System.out.println();
                        }
                        if (this.vFeas.size() + this.invFeas.size() > 0) {
                            objectArray2 = javaClass.getAttributes();
                            Attribute[] attributeArray3 = objectArray2;
                            if (this.vFeas.size() > 0) {
                                FieldExpressionAnnotation[] fieldExpressionAnnotationArray = new FieldExpressionAnnotation[this.vFeas.size()];
                                int n11 = 0;
                                Iterator<FieldExpressionAnnotation> iterator = this.vFeas.iterator();
                                while (iterator.hasNext()) {
                                    FieldExpressionAnnotation fieldExpressionAnnotation;
                                    fieldExpressionAnnotationArray[n11] = fieldExpressionAnnotation = iterator.next();
                                    ++n11;
                                }
                                FieldExpressionAnnotationsAttribute fieldExpressionAnnotationsAttribute = new FieldExpressionAnnotationsAttribute(constantPoolGen.lookupUtf8("RuntimeVisibleFieldExpressionAnnotations"), constantPool, fieldExpressionAnnotationArray);
                                attributeArray3 = new Attribute[objectArray2.length + 1];
                                for (n11 = 0; n11 < objectArray2.length; ++n11) {
                                    attributeArray3[n11] = objectArray2[n11];
                                }
                                attributeArray3[objectArray2.length] = fieldExpressionAnnotationsAttribute;
                                objectArray2 = attributeArray3;
                            }
                            if (this.invFeas.size() > 0) {
                                FieldExpressionAnnotation[] fieldExpressionAnnotationArray = new FieldExpressionAnnotation[this.invFeas.size()];
                                int n12 = 0;
                                Iterator<FieldExpressionAnnotation> iterator = this.invFeas.iterator();
                                while (iterator.hasNext()) {
                                    FieldExpressionAnnotation fieldExpressionAnnotation;
                                    fieldExpressionAnnotationArray[n12] = fieldExpressionAnnotation = iterator.next();
                                    ++n12;
                                }
                                FieldExpressionAnnotationsAttribute fieldExpressionAnnotationsAttribute = new FieldExpressionAnnotationsAttribute(constantPoolGen.lookupUtf8("RuntimeInvisibleFieldExpressionAnnotations"), constantPool, fieldExpressionAnnotationArray);
                                attributeArray3 = new Attribute[objectArray2.length + 1];
                                for (n12 = 0; n12 < objectArray2.length; ++n12) {
                                    attributeArray3[n12] = objectArray2[n12];
                                }
                                attributeArray3[objectArray2.length] = fieldExpressionAnnotationsAttribute;
                            }
                            javaClass.setAttributes(attributeArray3);
                        }
                        objectArray2 = new Method[arrayList.size()];
                        for (int i = 0; i < arrayList.size(); ++i) {
                            objectArray2[i] = methodArray[((ClassFileMethodInfo)arrayList.get(i)).getPosition()];
                        }
                        javaClass.setMethods((Method[])objectArray2);
                        javaClass.setConstantPool(constantPoolGen.getFinalConstantPool());
                    }
                    n2 = 0;
                    javaClass.setConstantPool(constantPoolGen.getFinalConstantPool());
                    for (Integer n13 : hashSet2) {
                        constantPoolGen = new ConstantPoolGen(javaClass.getConstantPool());
                        constantPoolGen.setConstant(n13.intValue(), (Constant)new ConstantUtf8(""));
                        javaClass.setConstantPool(constantPoolGen.getFinalConstantPool());
                        ++n2;
                    }
                    if (debug) {
                        System.out.println("--------------------------------------------------------------------------------");
                        System.out.println("WRITING OF MODIFIED BYTECODE INTO: " + string2 + ".class");
                    }
                    try {
                        javaClass.dump(string2 + ".class");
                        if (debug) {
                            System.out.println("Writing completed with success");
                        }
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                        if (debug) {
                            this.exceptionManagement("ERROR: the writing is failed");
                        }
                        this.exceptionManagement("ERROR: is faild the writing of the modiied bytecode in '" + string2 + ".class'");
                    }
                    if (debug) {
                        System.out.println("--------------------------------------------------------------------------------");
                    }
                }
                catch (Exception exception) {
                    System.out.println("The class file '" + string + "' wasn't been found.");
                    exception.printStackTrace();
                }
            }
        }
        if (stack.size() > 0) {
            this.changeBytecode(stack, hashSet);
        }
    }

    private final void loadAnnotationsFromFictitiousMethodList(Method[] methodArray, ConstantPool constantPool, ArrayList<Integer> arrayList, String string) {
        for (int n : arrayList) {
            int n2;
            Attribute[] attributeArray = methodArray[n].getAttributes();
            for (n2 = 0; n2 < attributeArray.length && !constantPool.constantToString(constantPool.getConstant(attributeArray[n2].getNameIndex())).equals("RuntimeVisibleAnnotations"); ++n2) {
            }
            if (n2 < attributeArray.length) {
                this.runtimeVisibleAnnotationsStructures.put(methodArray[n].getName().replace(string + randomString + "_", ""), ((AnnotationsAttribute)attributeArray[n2]).getAnnotations()[0]);
                if (string.equals("EA_")) {
                    this.removedExpressionAnnotations.put(methodArray[n].getName().replace(string + randomString + "_", ""), ((AnnotationsAttribute)attributeArray[n2]).getAnnotations()[0]);
                }
                if (string.equals("SFEA_") || string.equals("NSFEA_")) {
                    this.removedFieldExpressionAnnotations.put(methodArray[n].getName().replace(string + randomString + "_", ""), ((AnnotationsAttribute)attributeArray[n2]).getAnnotations()[0]);
                }
            }
            for (n2 = 0; n2 < attributeArray.length && !constantPool.constantToString(constantPool.getConstant(attributeArray[n2].getNameIndex())).equals("RuntimeInvisibleAnnotations"); ++n2) {
            }
            if (n2 >= attributeArray.length) continue;
            this.runtimeInvisibleAnnotationsStructures.put(methodArray[n].getName().replace(string + randomString + "_", ""), ((AnnotationsAttribute)attributeArray[n2]).getAnnotations()[0]);
            if (string.equals("EA_")) {
                this.removedExpressionAnnotations.put(methodArray[n].getName().replace(string + randomString + "_", ""), ((AnnotationsAttribute)attributeArray[n2]).getAnnotations()[0]);
            }
            if (!string.equals("SFEA_") && !string.equals("NSFEA_")) continue;
            this.removedFieldExpressionAnnotations.put(methodArray[n].getName().replace(string + randomString + "_", ""), ((AnnotationsAttribute)attributeArray[n2]).getAnnotations()[0]);
        }
    }

    private final JavaClass removeCodeAnnotationsAndCreateAttribute(JavaClass javaClass, MethodGen methodGen, int n, HashMap<String, Annotation> hashMap, HashMap<String, Annotation> hashMap2) {
        InstructionHandle instructionHandle;
        Object object2;
        Method[] methodArray = javaClass.getMethods();
        ConstantPool constantPool = javaClass.getConstantPool();
        ConstantPoolGen constantPoolGen = new ConstantPoolGen(javaClass.getConstantPool());
        Stack<Integer> stack = new Stack<Integer>();
        Stack<Integer> stack2 = new Stack<Integer>();
        Stack<Integer> stack3 = new Stack<Integer>();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        ArrayList<ExpressionAnnotation> arrayList3 = new ArrayList<ExpressionAnnotation>();
        ArrayList<ExpressionAnnotation> arrayList4 = new ArrayList<ExpressionAnnotation>();
        HashSet<Integer> hashSet = new HashSet<Integer>();
        InstructionList instructionList = methodGen.getInstructionList();
        if (instructionList.size() == 0) {
            return javaClass;
        }
        InstructionHandle instructionHandle2 = instructionList.getStart();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        String string = "";
        int n5 = 0;
        for (int i = 0; i < instructionList.size(); ++i) {
            InstructionHandle instructionHandle3;
            int n6;
            if (!(instructionHandle2.getInstruction() instanceof LDC) && !(instructionHandle2.getInstruction() instanceof LDC_W)) {
                instructionHandle2 = instructionHandle2.getNext();
                continue;
            }
            if (instructionHandle2.getInstruction() instanceof LDC_W) {
                string = instructionHandle2.getInstruction().toString(constantPool).substring(6);
                n5 = 3;
            } else {
                string = instructionHandle2.getInstruction().toString(constantPool).substring(4);
                n5 = 2;
            }
            if (!(string.startsWith("\"startBA-" + randomString + "-") || string.startsWith("\"startEA-" + randomString + "-") || string.startsWith("\"startNSFEA-" + randomString + "-") || string.startsWith("\"startSFEA-" + randomString + "-") || string.startsWith("\"endBA-" + randomString + "-") || string.startsWith("\"endEA-" + randomString + "-") || string.startsWith("\"endNSFEA-" + randomString + "-") || string.startsWith("\"endSFEA-" + randomString + "-"))) {
                instructionHandle2 = instructionHandle2.getNext();
                continue;
            }
            object2 = instructionHandle2.getInstruction().toString(constantPool);
            if (instructionHandle2.getInstruction() instanceof LDC) {
                hashSet.add(((ConstantString)constantPool.getConstant(((LDC)instructionHandle2.getInstruction()).getIndex())).getStringIndex());
            } else {
                hashSet.add(((ConstantString)constantPool.getConstant(((LDC_W)instructionHandle2.getInstruction()).getIndex())).getStringIndex());
            }
            string = string.substring(1, string.length() - 1);
            boolean bl = false;
            if (string.startsWith("startBA")) {
                stack.push(instructionHandle2.getPosition());
                bl = true;
            } else if (string.startsWith("endBA")) {
                Object object;
                int n7;
                Object object3;
                ++n2;
                bl = true;
                String[] stringArray = string.split("-");
                int n8 = Integer.parseInt(stringArray[2]);
                int n9 = Integer.parseInt(stringArray[3]);
                n6 = Integer.parseInt(stringArray[4]);
                int n10 = Integer.parseInt(stringArray[5]);
                int n11 = Integer.parseInt(stringArray[6]);
                boolean bl2 = Boolean.parseBoolean(stringArray[7]);
                int n12 = (Integer)stack.pop();
                int n13 = instructionHandle2.getPosition();
                if (bl2) {
                    object3 = instructionHandle2.getNext().getNext();
                    n7 = n5 + 3;
                    while (!(object3.getInstruction() instanceof ReturnInstruction)) {
                        object = object3.getInstruction().toString(constantPool);
                        if (((String)object).startsWith("ldc \"startBA-" + randomString + "-") || ((String)object).startsWith("ldc \"endBA-" + randomString + "-")) {
                            n7 += 5;
                        } else if (((String)object).startsWith("ldc_w \"startBA-" + randomString + "-") || ((String)object).startsWith("ldc_w \"endBA-" + randomString + "-")) {
                            n7 += 6;
                        } else if (((String)object).startsWith("ldc \"startEA-" + randomString + "-")) {
                            n7 += 2;
                        } else if (((String)object).startsWith("ldc_w \"startEA-" + randomString + "-")) {
                            n7 += 3;
                        } else if (((String)object).startsWith("ldc \"endEA-" + randomString + "-") || ((String)object).startsWith("ldc_w \"endEA-" + randomString + "-")) {
                            if (((String)object).startsWith("ldc \"endEA-" + randomString + "-")) {
                                n7 += 5;
                            } else if (((String)object).startsWith("ldc_w \"endEA-" + randomString + "-")) {
                                n7 += 6;
                            }
                            if (object3.getPrev().getInstruction().toString(constantPool).equals("invokestatic java/lang/Boolean/valueOf(Z)Ljava/lang/Boolean;") && object3.getNext().getNext().getInstruction().toString(constantPool).equals("checkcast java/lang/Boolean") && object3.getNext().getNext().getNext().getInstruction().toString(constantPool).equals("invokevirtual java/lang/Boolean/booleanValue()Z") || object3.getPrev().getInstruction().toString(constantPool).equals("invokestatic java/lang/Byte/valueOf(B)Ljava/lang/Byte;") && object3.getNext().getNext().getInstruction().toString(constantPool).equals("checkcast java/lang/Byte") && object3.getNext().getNext().getNext().getInstruction().toString(constantPool).equals("invokevirtual java/lang/Byte/byteValue()B") || object3.getPrev().getInstruction().toString(constantPool).equals("invokestatic java/lang/Short/valueOf(S)Ljava/lang/Short;") && object3.getNext().getNext().getInstruction().toString(constantPool).equals("checkcast java/lang/Short") && object3.getNext().getNext().getNext().getInstruction().toString(constantPool).equals("invokevirtual java/lang/Short/shortValue()S") || object3.getPrev().getInstruction().toString(constantPool).equals("invokestatic java/lang/Integer/valueOf(I)Ljava/lang/Integer;") && object3.getNext().getNext().getInstruction().toString(constantPool).equals("checkcast java/lang/Integer") && object3.getNext().getNext().getNext().getInstruction().toString(constantPool).equals("invokevirtual java/lang/Integer/intValue()I") || object3.getPrev().getInstruction().toString(constantPool).equals("invokestatic java/lang/Long/valueOf(J)Ljava/lang/Long;") && object3.getNext().getNext().getInstruction().toString(constantPool).equals("checkcast java/lang/Long") && object3.getNext().getNext().getNext().getInstruction().toString(constantPool).equals("invokevirtual java/lang/Long/longValue()J") || object3.getPrev().getInstruction().toString(constantPool).equals("invokestatic java/lang/Float/valueOf(F)Ljava/lang/Float;") && object3.getNext().getNext().getInstruction().toString(constantPool).equals("checkcast java/lang/Float") && object3.getNext().getNext().getNext().getInstruction().toString(constantPool).equals("invokevirtual java/lang/Float/floatValue()F") || object3.getPrev().getInstruction().toString(constantPool).equals("invokestatic java/lang/Double/valueOf(D)Ljava/lang/Double;") && object3.getNext().getNext().getInstruction().toString(constantPool).equals("checkcast java/lang/Double") && object3.getNext().getNext().getNext().getInstruction().toString(constantPool).equals("invokevirtual java/lang/Double/doubleValue()D") || object3.getPrev().getInstruction().toString(constantPool).equals("invokestatic java/lang/Character/valueOf(C)Ljava/lang/Character;") && object3.getNext().getNext().getInstruction().toString(constantPool).equals("checkcast java/lang/Character") && object3.getNext().getNext().getNext().getInstruction().toString(constantPool).equals("invokevirtual java/lang/Character/charValue()C")) {
                                n7 += 9;
                            }
                        }
                        object3 = object3.getNext();
                    }
                    n13 = object3.getPosition() + 1 - n7;
                }
                if (hashMap.containsKey(decimalFormat.format(n8) + "_" + decimalFormat.format(n9))) {
                    n7 = 1;
                    object3 = hashMap.get(decimalFormat.format(n8) + "_" + decimalFormat.format(n9));
                    object = new BlockAnnotation(n12, n13, n8, n9, n6, n10, n11, (Annotation)object3);
                    if (debug) {
                        System.out.println("\t(BA visible):\t" + ((BlockAnnotation)object).toString());
                    }
                    arrayList.add(object);
                } else if (hashMap2.containsKey(decimalFormat.format(n8) + "_" + decimalFormat.format(n9))) {
                    n7 = 0;
                    object3 = hashMap2.get(decimalFormat.format(n8) + "_" + decimalFormat.format(n9));
                    object = new BlockAnnotation(n12, n13, n8, n9, n6, n10, n11, (Annotation)object3);
                    if (debug) {
                        System.out.println("\t(BA invisible):\t" + ((BlockAnnotation)object).toString());
                    }
                    arrayList2.add(object);
                } else {
                    System.out.println("- The BlockAnnotation " + stringArray[8] + " at line " + n8 + " and column " + n9 + " has been deleted: (1) by the compiler optimization or (2) because it has Retention of type SOURCE");
                }
            } else if (string.startsWith("startEA")) {
                stack2.push(instructionHandle2.getPosition());
            } else if (string.startsWith("endEA")) {
                ++n3;
                bl = true;
                String[] stringArray = string.split("-");
                int n14 = Integer.parseInt(stringArray[2]);
                int n15 = Integer.parseInt(stringArray[3]);
                n6 = Integer.parseInt(stringArray[4]);
                int n16 = Integer.parseInt(stringArray[5]);
                int n17 = Integer.parseInt(stringArray[6]);
                int n18 = (Integer)stack2.pop();
                int n19 = instructionHandle2.getPosition();
                if (instructionHandle2.getPrev().getInstruction().toString(constantPool).equals("invokestatic java/lang/Boolean/valueOf(Z)Ljava/lang/Boolean;") && instructionHandle2.getNext().getNext().getInstruction().toString(constantPool).equals("checkcast java/lang/Boolean") && instructionHandle2.getNext().getNext().getNext().getInstruction().toString(constantPool).equals("invokevirtual java/lang/Boolean/booleanValue()Z") || instructionHandle2.getPrev().getInstruction().toString(constantPool).equals("invokestatic java/lang/Byte/valueOf(B)Ljava/lang/Byte;") && instructionHandle2.getNext().getNext().getInstruction().toString(constantPool).equals("checkcast java/lang/Byte") && instructionHandle2.getNext().getNext().getNext().getInstruction().toString(constantPool).equals("invokevirtual java/lang/Byte/byteValue()B") || instructionHandle2.getPrev().getInstruction().toString(constantPool).equals("invokestatic java/lang/Short/valueOf(S)Ljava/lang/Short;") && instructionHandle2.getNext().getNext().getInstruction().toString(constantPool).equals("checkcast java/lang/Short") && instructionHandle2.getNext().getNext().getNext().getInstruction().toString(constantPool).equals("invokevirtual java/lang/Short/shortValue()S") || instructionHandle2.getPrev().getInstruction().toString(constantPool).equals("invokestatic java/lang/Integer/valueOf(I)Ljava/lang/Integer;") && instructionHandle2.getNext().getNext().getInstruction().toString(constantPool).equals("checkcast java/lang/Integer") && instructionHandle2.getNext().getNext().getNext().getInstruction().toString(constantPool).equals("invokevirtual java/lang/Integer/intValue()I") || instructionHandle2.getPrev().getInstruction().toString(constantPool).equals("invokestatic java/lang/Long/valueOf(J)Ljava/lang/Long;") && instructionHandle2.getNext().getNext().getInstruction().toString(constantPool).equals("checkcast java/lang/Long") && instructionHandle2.getNext().getNext().getNext().getInstruction().toString(constantPool).equals("invokevirtual java/lang/Long/longValue()J") || instructionHandle2.getPrev().getInstruction().toString(constantPool).equals("invokestatic java/lang/Float/valueOf(F)Ljava/lang/Float;") && instructionHandle2.getNext().getNext().getInstruction().toString(constantPool).equals("checkcast java/lang/Float") && instructionHandle2.getNext().getNext().getNext().getInstruction().toString(constantPool).equals("invokevirtual java/lang/Float/floatValue()F") || instructionHandle2.getPrev().getInstruction().toString(constantPool).equals("invokestatic java/lang/Double/valueOf(D)Ljava/lang/Double;") && instructionHandle2.getNext().getNext().getInstruction().toString(constantPool).equals("checkcast java/lang/Double") && instructionHandle2.getNext().getNext().getNext().getInstruction().toString(constantPool).equals("invokevirtual java/lang/Double/doubleValue()D") || instructionHandle2.getPrev().getInstruction().toString(constantPool).equals("invokestatic java/lang/Character/valueOf(C)Ljava/lang/Character;") && instructionHandle2.getNext().getNext().getInstruction().toString(constantPool).equals("checkcast java/lang/Character") && instructionHandle2.getNext().getNext().getNext().getInstruction().toString(constantPool).equals("invokevirtual java/lang/Character/charValue()C")) {
                    n19 = instructionHandle2.getPrev().getPosition();
                }
                this.removedExpressionAnnotations.remove(decimalFormat.format(n14) + "_" + decimalFormat.format(n15));
                if (hashMap.containsKey(decimalFormat.format(n14) + "_" + decimalFormat.format(n15))) {
                    boolean bl3 = true;
                    Annotation annotation = hashMap.get(decimalFormat.format(n14) + "_" + decimalFormat.format(n15));
                    ExpressionAnnotation expressionAnnotation = new ExpressionAnnotation(n18, n19, n14, n15, n6, n16, n17, annotation);
                    if (debug) {
                        System.out.println("\t(EA visible):\t" + expressionAnnotation.toString());
                    }
                    arrayList3.add(expressionAnnotation);
                } else if (hashMap2.containsKey(decimalFormat.format(n14) + "_" + decimalFormat.format(n15))) {
                    boolean bl4 = false;
                    Annotation annotation = hashMap2.get(decimalFormat.format(n14) + "_" + decimalFormat.format(n15));
                    ExpressionAnnotation expressionAnnotation = new ExpressionAnnotation(n18, n19, n14, n15, n6, n16, n17, annotation);
                    if (debug) {
                        System.out.println("\t(EA invisible):\t" + expressionAnnotation.toString());
                    }
                    arrayList4.add(expressionAnnotation);
                } else {
                    System.out.println("- The ExpressionAnnotation " + stringArray[7] + " at line " + n14 + " and column " + n15 + " has been deleted: (1) by the compiler optimization or (2) because it has Retention of type SOURCE");
                }
            } else if (string.startsWith("startNSFEA") || string.startsWith("startSFEA")) {
                stack3.push(instructionHandle2.getPosition());
            } else if (string.startsWith("endNSFEA") || string.startsWith("endSFEA")) {
                ++n4;
                bl = true;
                String[] stringArray = string.split("-");
                int n20 = Integer.parseInt(stringArray[2]);
                int n21 = Integer.parseInt(stringArray[3]);
                n6 = Integer.parseInt(stringArray[4]);
                int n22 = Integer.parseInt(stringArray[5]);
                int n23 = Integer.parseInt(stringArray[6]);
                String string2 = stringArray[8];
                boolean bl5 = !string.startsWith("endNSFEA");
                int n24 = (Integer)stack3.pop();
                int n25 = instructionHandle2.getPosition();
                if (instructionHandle2.getPrev().getInstruction().toString(constantPool).equals("invokestatic java/lang/Boolean/valueOf(Z)Ljava/lang/Boolean;") && instructionHandle2.getNext().getNext().getInstruction().toString(constantPool).equals("checkcast java/lang/Boolean") && instructionHandle2.getNext().getNext().getNext().getInstruction().toString(constantPool).equals("invokevirtual java/lang/Boolean/booleanValue()Z") || instructionHandle2.getPrev().getInstruction().toString(constantPool).equals("invokestatic java/lang/Byte/valueOf(B)Ljava/lang/Byte;") && instructionHandle2.getNext().getNext().getInstruction().toString(constantPool).equals("checkcast java/lang/Byte") && instructionHandle2.getNext().getNext().getNext().getInstruction().toString(constantPool).equals("invokevirtual java/lang/Byte/byteValue()B") || instructionHandle2.getPrev().getInstruction().toString(constantPool).equals("invokestatic java/lang/Short/valueOf(S)Ljava/lang/Short;") && instructionHandle2.getNext().getNext().getInstruction().toString(constantPool).equals("checkcast java/lang/Short") && instructionHandle2.getNext().getNext().getNext().getInstruction().toString(constantPool).equals("invokevirtual java/lang/Short/shortValue()S") || instructionHandle2.getPrev().getInstruction().toString(constantPool).equals("invokestatic java/lang/Integer/valueOf(I)Ljava/lang/Integer;") && instructionHandle2.getNext().getNext().getInstruction().toString(constantPool).equals("checkcast java/lang/Integer") && instructionHandle2.getNext().getNext().getNext().getInstruction().toString(constantPool).equals("invokevirtual java/lang/Integer/intValue()I") || instructionHandle2.getPrev().getInstruction().toString(constantPool).equals("invokestatic java/lang/Long/valueOf(J)Ljava/lang/Long;") && instructionHandle2.getNext().getNext().getInstruction().toString(constantPool).equals("checkcast java/lang/Long") && instructionHandle2.getNext().getNext().getNext().getInstruction().toString(constantPool).equals("invokevirtual java/lang/Long/longValue()J") || instructionHandle2.getPrev().getInstruction().toString(constantPool).equals("invokestatic java/lang/Float/valueOf(F)Ljava/lang/Float;") && instructionHandle2.getNext().getNext().getInstruction().toString(constantPool).equals("checkcast java/lang/Float") && instructionHandle2.getNext().getNext().getNext().getInstruction().toString(constantPool).equals("invokevirtual java/lang/Float/floatValue()F") || instructionHandle2.getPrev().getInstruction().toString(constantPool).equals("invokestatic java/lang/Double/valueOf(D)Ljava/lang/Double;") && instructionHandle2.getNext().getNext().getInstruction().toString(constantPool).equals("checkcast java/lang/Double") && instructionHandle2.getNext().getNext().getNext().getInstruction().toString(constantPool).equals("invokevirtual java/lang/Double/doubleValue()D") || instructionHandle2.getPrev().getInstruction().toString(constantPool).equals("invokestatic java/lang/Character/valueOf(C)Ljava/lang/Character;") && instructionHandle2.getNext().getNext().getInstruction().toString(constantPool).equals("checkcast java/lang/Character") && instructionHandle2.getNext().getNext().getNext().getInstruction().toString(constantPool).equals("invokevirtual java/lang/Character/charValue()C")) {
                    n25 = instructionHandle2.getPrev().getPosition();
                }
                this.removedFieldExpressionAnnotations.remove(decimalFormat.format(n20) + "_" + decimalFormat.format(n21));
                if (!this.isAnInitAlreadyVisited || !string.startsWith("endNSFEA")) {
                    FieldExpressionAnnotation fieldExpressionAnnotation;
                    if (string.startsWith("endNSFEA")) {
                        this.isAnInitAlreadyVisited = true;
                    }
                    if (hashMap.containsKey(decimalFormat.format(n20) + "_" + decimalFormat.format(n21))) {
                        boolean bl6 = true;
                        Annotation annotation = hashMap.get(decimalFormat.format(n20) + "_" + decimalFormat.format(n21));
                        fieldExpressionAnnotation = new FieldExpressionAnnotation(n24, n25, n20, n21, n6, n22, n23, annotation, string2, bl5);
                        if (debug) {
                            System.out.println("\t(FEA visible):\t" + fieldExpressionAnnotation.toString());
                        }
                        this.vFeas.add(fieldExpressionAnnotation);
                    } else if (hashMap2.containsKey(decimalFormat.format(n20) + "_" + decimalFormat.format(n21))) {
                        boolean bl7 = false;
                        Annotation annotation = hashMap2.get(decimalFormat.format(n20) + "_" + decimalFormat.format(n21));
                        fieldExpressionAnnotation = new FieldExpressionAnnotation(n24, n25, n20, n21, n6, n22, n23, annotation, string2, bl5);
                        if (debug) {
                            System.out.println("\t(FEA invisible):\t" + fieldExpressionAnnotation.toString());
                        }
                        this.invFeas.add(fieldExpressionAnnotation);
                    } else {
                        System.out.println("- The FieldExpressionAnnotation " + stringArray[7] + " at line " + n20 + " and column " + n21 + " has been deleted: (1) by the compiler optimization or (2) because it has Retention of type SOURCE");
                    }
                }
            }
            if (bl) {
                instructionHandle3 = instructionHandle2;
                instructionHandle = instructionHandle2.getNext();
            } else {
                instructionHandle3 = instructionHandle2;
                instructionHandle = instructionHandle2;
            }
            n6 = 0;
            try {
                if (instructionHandle3.getPrev().getInstruction().toString(constantPool).equals("invokestatic java/lang/Boolean/valueOf(Z)Ljava/lang/Boolean;") && instructionHandle.getNext().getInstruction().toString(constantPool).equals("checkcast java/lang/Boolean") && instructionHandle.getNext().getNext().getInstruction().toString(constantPool).equals("invokevirtual java/lang/Boolean/booleanValue()Z") || instructionHandle3.getPrev().getInstruction().toString(constantPool).equals("invokestatic java/lang/Byte/valueOf(B)Ljava/lang/Byte;") && instructionHandle.getNext().getInstruction().toString(constantPool).equals("checkcast java/lang/Byte") && instructionHandle.getNext().getNext().getInstruction().toString(constantPool).equals("invokevirtual java/lang/Byte/byteValue()B") || instructionHandle3.getPrev().getInstruction().toString(constantPool).equals("invokestatic java/lang/Short/valueOf(S)Ljava/lang/Short;") && instructionHandle.getNext().getInstruction().toString(constantPool).equals("checkcast java/lang/Short") && instructionHandle.getNext().getNext().getInstruction().toString(constantPool).equals("invokevirtual java/lang/Short/shortValue()S") || instructionHandle3.getPrev().getInstruction().toString(constantPool).equals("invokestatic java/lang/Integer/valueOf(I)Ljava/lang/Integer;") && instructionHandle.getNext().getInstruction().toString(constantPool).equals("checkcast java/lang/Integer") && instructionHandle.getNext().getNext().getInstruction().toString(constantPool).equals("invokevirtual java/lang/Integer/intValue()I") || instructionHandle3.getPrev().getInstruction().toString(constantPool).equals("invokestatic java/lang/Long/valueOf(J)Ljava/lang/Long;") && instructionHandle.getNext().getInstruction().toString(constantPool).equals("checkcast java/lang/Long") && instructionHandle.getNext().getNext().getInstruction().toString(constantPool).equals("invokevirtual java/lang/Long/longValue()J") || instructionHandle3.getPrev().getInstruction().toString(constantPool).equals("invokestatic java/lang/Float/valueOf(F)Ljava/lang/Float;") && instructionHandle.getNext().getInstruction().toString(constantPool).equals("checkcast java/lang/Float") && instructionHandle.getNext().getNext().getInstruction().toString(constantPool).equals("invokevirtual java/lang/Float/floatValue()F") || instructionHandle3.getPrev().getInstruction().toString(constantPool).equals("invokestatic java/lang/Double/valueOf(D)Ljava/lang/Double;") && instructionHandle.getNext().getInstruction().toString(constantPool).equals("checkcast java/lang/Double") && instructionHandle.getNext().getNext().getInstruction().toString(constantPool).equals("invokevirtual java/lang/Double/doubleValue()D") || instructionHandle3.getPrev().getInstruction().toString(constantPool).equals("invokestatic java/lang/Character/valueOf(C)Ljava/lang/Character;") && instructionHandle.getNext().getInstruction().toString(constantPool).equals("checkcast java/lang/Character") && instructionHandle.getNext().getNext().getInstruction().toString(constantPool).equals("invokevirtual java/lang/Character/charValue()C")) {
                    instructionHandle3 = instructionHandle3.getPrev();
                    instructionHandle = instructionHandle.getNext().getNext();
                    n6 = 1;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            InstructionHandle object6 = instructionHandle.getNext();
            try {
                instructionList.delete(instructionHandle3, instructionHandle);
            }
            catch (TargetLostException targetLostException) {
                InstructionHandle[] instructionHandleArray = targetLostException.getTargets();
                for (int j = 0; j < instructionHandleArray.length; ++j) {
                    InstructionTargeter[] instructionTargeterArray = instructionHandleArray[j].getTargeters();
                    for (int k = 0; k < instructionTargeterArray.length; ++k) {
                        instructionTargeterArray[k].updateTarget(instructionHandleArray[j], object6);
                    }
                }
            }
            instructionList.update();
            instructionList.setPositions();
            methodGen.setInstructionList(instructionList);
            Method method = methodGen.getMethod();
            methodGen = new MethodGen(method, javaClass.getClassName(), constantPoolGen);
            instructionList = methodGen.getInstructionList();
            if (n6 != 0) {
                --i;
            }
            instructionHandle2 = instructionList.getInstructionHandles()[i];
            --i;
        }
        Method method = null;
        if (n2 + n3 + n4 > 0) {
            method = methodGen.getMethod();
            Attribute[] attributeArray = object2 = method.getAttributes();
            if (arrayList.size() > 0) {
                BlockAnnotation[] blockAnnotationArray = new BlockAnnotation[arrayList.size()];
                int n26 = 0;
                instructionHandle = arrayList.iterator();
                while (instructionHandle.hasNext()) {
                    BlockAnnotation blockAnnotation;
                    blockAnnotationArray[n26] = blockAnnotation = (BlockAnnotation)instructionHandle.next();
                    ++n26;
                }
                instructionHandle = new BlockAnnotationsAttribute(constantPoolGen.lookupUtf8("RuntimeVisibleBlockAnnotations"), constantPool, blockAnnotationArray);
                attributeArray = new Attribute[((Attribute[])object2).length + 1];
                for (n26 = 0; n26 < ((Attribute[])object2).length; ++n26) {
                    attributeArray[n26] = object2[n26];
                }
                attributeArray[((Attribute[])object2).length] = instructionHandle;
                object2 = attributeArray;
            }
            if (arrayList2.size() > 0) {
                BlockAnnotation[] blockAnnotationArray = new BlockAnnotation[arrayList2.size()];
                int n27 = 0;
                instructionHandle = arrayList2.iterator();
                while (instructionHandle.hasNext()) {
                    BlockAnnotation blockAnnotation;
                    blockAnnotationArray[n27] = blockAnnotation = (BlockAnnotation)instructionHandle.next();
                    ++n27;
                }
                instructionHandle = new BlockAnnotationsAttribute(constantPoolGen.lookupUtf8("RuntimeInvisibleBlockAnnotations"), constantPool, blockAnnotationArray);
                attributeArray = new Attribute[((Attribute[])object2).length + 1];
                for (n27 = 0; n27 < ((Attribute[])object2).length; ++n27) {
                    attributeArray[n27] = object2[n27];
                }
                attributeArray[((Attribute[])object2).length] = instructionHandle;
            }
            if (arrayList3.size() > 0) {
                ExpressionAnnotation[] expressionAnnotationArray = new ExpressionAnnotation[arrayList3.size()];
                int n28 = 0;
                instructionHandle = arrayList3.iterator();
                while (instructionHandle.hasNext()) {
                    ExpressionAnnotation expressionAnnotation;
                    expressionAnnotationArray[n28] = expressionAnnotation = (ExpressionAnnotation)instructionHandle.next();
                    ++n28;
                }
                instructionHandle = new ExpressionAnnotationsAttribute(constantPoolGen.lookupUtf8("RuntimeVisibleExpressionAnnotations"), constantPool, expressionAnnotationArray);
                attributeArray = new Attribute[((Attribute[])object2).length + 1];
                for (n28 = 0; n28 < ((Attribute[])object2).length; ++n28) {
                    attributeArray[n28] = object2[n28];
                }
                attributeArray[((Attribute[])object2).length] = instructionHandle;
                object2 = attributeArray;
            }
            if (arrayList4.size() > 0) {
                ExpressionAnnotation[] expressionAnnotationArray = new ExpressionAnnotation[arrayList4.size()];
                int n29 = 0;
                instructionHandle = arrayList4.iterator();
                while (instructionHandle.hasNext()) {
                    ExpressionAnnotation expressionAnnotation;
                    expressionAnnotationArray[n29] = expressionAnnotation = (ExpressionAnnotation)instructionHandle.next();
                    ++n29;
                }
                instructionHandle = new ExpressionAnnotationsAttribute(constantPoolGen.lookupUtf8("RuntimeInvisibleExpressionAnnotations"), constantPool, expressionAnnotationArray);
                attributeArray = new Attribute[((Attribute[])object2).length + 1];
                for (n29 = 0; n29 < ((Attribute[])object2).length; ++n29) {
                    attributeArray[n29] = object2[n29];
                }
                attributeArray[((Attribute[])object2).length] = instructionHandle;
            }
            method.setAttributes(attributeArray);
            methodArray[n] = method;
        }
        int n30 = 0;
        javaClass.setConstantPool(constantPoolGen.getFinalConstantPool());
        for (Integer n31 : hashSet) {
            constantPoolGen = new ConstantPoolGen(javaClass.getConstantPool());
            constantPoolGen.setConstant(n31.intValue(), (Constant)new ConstantUtf8(""));
            javaClass.setConstantPool(constantPoolGen.getFinalConstantPool());
            ++n30;
        }
        instructionList.dispose();
        return javaClass;
    }

    private final void classFilesNotRecompiledButModifiedRestoration(boolean bl) throws InterruptedException {
        for (int i = 0; i < annotationsClassFilesChangedToRestore.size(); ++i) {
            String string = annotationsClassFilesChangedToRestore.get(i);
            if (debug && bl) {
                System.out.println("Change of: " + string);
            }
            try {
                int n;
                int n2;
                JavaClass javaClass = Repository.lookupClass((String)string.substring(0, string.length() - 6));
                ConstantPool constantPool = javaClass.getConstantPool();
                Attribute[] attributeArray = javaClass.getAttributes();
                for (n2 = 0; n2 < attributeArray.length && !constantPool.constantToString(constantPool.getConstant(attributeArray[n2].getNameIndex())).equals("RuntimeVisibleAnnotations"); ++n2) {
                }
                if (n2 >= attributeArray.length) continue;
                AnnotationsAttribute annotationsAttribute = (AnnotationsAttribute)attributeArray[n2];
                for (n = 0; n < annotationsAttribute.getAnnotations().length && !annotationsAttribute.getAnnotations()[n].getCleanedType().equals("Target"); ++n) {
                }
                if (n >= annotationsAttribute.getAnnotations().length) continue;
                Object[] objectArray = (Object[])annotationsAttribute.getAnnotations()[n].getElementValuePair(0).getElementValue().getValue();
                Object[] objectArray2 = new Object[objectArray.length - 1];
                objectArray2 = new Object[objectArray2.length];
                int n3 = 0;
                for (int j = 0; j < objectArray.length; ++j) {
                    if (((Object[])((ElementValue)objectArray[j]).getValue())[1].equals("METHOD")) continue;
                    objectArray2[n3] = objectArray[j];
                    ++n3;
                }
                annotationsAttribute.getAnnotations()[n].getElementValuePair(0).getElementValue().setValue(objectArray2);
                attributeArray[n2] = annotationsAttribute;
                javaClass.setAttributes(attributeArray);
                try {
                    javaClass.dump(string);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    if (debug) {
                        this.exceptionManagement("ERROR: is failed the writing of the changes");
                        continue;
                    }
                    this.exceptionManagement("ERROR: is failed the writing of the changes of: " + string);
                }
                continue;
            }
            catch (Exception exception) {
                System.out.println("The class file '" + string.substring(0, string.length() - 6) + "' wasn't been found.");
                exception.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void searchCorrelatedFiles(String string, FileData fileData) {
        Serializable serializable;
        Serializable serializable2;
        Object object;
        int n;
        ArrayList<String> arrayList = fileData.getPackages();
        TreeSet<String> treeSet = fileData.getClassesAndInterfacesUsed();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        HashSet<String> hashSet = new HashSet<String>();
        File file = string.indexOf("\\") == -1 && string.indexOf("/") == -1 && string.indexOf(File.separator) == -1 ? new File("." + File.separator + string) : new File(string);
        File file2 = file.getParentFile();
        String[] stringArray = file2.list();
        HashSet<String> hashSet2 = new HashSet<String>();
        hashSet2.add("atjavac\\SourceCodeReplacement");
        if (string.indexOf(File.separator) > -1) {
            hashSet2.add(string.substring(string.lastIndexOf(File.separator) + 1, string.lastIndexOf(".")));
        } else {
            hashSet2.add(string.substring(0, string.lastIndexOf(".")));
        }
        for (n = 0; stringArray != null && n < stringArray.length; ++n) {
            int n2 = stringArray[n].lastIndexOf(".");
            if (n2 <= 0 || !stringArray[n].substring(n2 + 1).equals("java") && !stringArray[n].substring(n2 + 1).equals("class") || !treeSet.contains(stringArray[n].substring(0, n2)) || hashSet2.contains(stringArray[n].substring(0, n2)) || stringArray[n].indexOf("$") >= 0) continue;
            hashSet2.add(stringArray[n].substring(0, stringArray[n].lastIndexOf(".")));
            String string2 = file2 + File.separator + stringArray[n].substring(0, stringArray[n].lastIndexOf("."));
            object = new File(string2 + ".java");
            serializable2 = new File(string2 + ".class");
            if (((File)object).isFile() && (!((File)serializable2).isFile() || recompileAll || ((File)serializable2).isFile() && ((File)object).lastModified() > ((File)serializable2).lastModified())) {
                serializable = javaFilesToCompile;
                synchronized (serializable) {
                    if (!javaFilesToCompile.contains(((File)object).toString())) {
                        javaFilesToCompile.add(((File)object).toString());
                    }
                }
                arrayList2.add(((File)object).toString());
                continue;
            }
            if (!((File)serializable2).isFile() || ((File)serializable2).getName().indexOf("$") >= 0) continue;
            classFilesToAnalize.add(((File)serializable2).toString());
            arrayList3.add(((File)serializable2).toString());
        }
        for (n = 0; n < arrayList.size(); ++n) {
            Object object2;
            if (arrayList.get(n).endsWith(".*")) {
                object2 = new File(arrayList.get(n).substring(0, arrayList.get(n).length() - 1).replace(".", File.separator));
                stringArray = ((File)object2).list();
                hashSet2 = new HashSet();
                for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
                    if (stringArray[i].indexOf(".") <= 0 || !treeSet.contains(stringArray[i].substring(0, stringArray[i].lastIndexOf("."))) || hashSet2.contains(stringArray[i].substring(0, stringArray[i].lastIndexOf("."))) || stringArray[i].indexOf("$") >= 0) continue;
                    hashSet2.add(stringArray[i].substring(0, stringArray[i].lastIndexOf(".")));
                    object = arrayList.get(n).substring(0, arrayList.get(n).length() - 1).replace(".", File.separator) + stringArray[i].substring(0, stringArray[i].lastIndexOf("."));
                    serializable2 = new File((String)object + ".java");
                    serializable = new File((String)object + ".class");
                    if (((File)serializable2).isFile() && (!((File)serializable).isFile() || recompileAll || ((File)serializable).isFile() && ((File)serializable2).lastModified() > ((File)serializable).lastModified())) {
                        ArrayList<String> arrayList4 = javaFilesToCompile;
                        synchronized (arrayList4) {
                            if (!javaFilesToCompile.contains(((File)serializable2).toString())) {
                                javaFilesToCompile.add(((File)serializable2).toString());
                            }
                        }
                        arrayList2.add(((File)serializable2).toString());
                        continue;
                    }
                    if (!((File)serializable).isFile() || ((File)serializable).getName().indexOf("$") >= 0) continue;
                    classFilesToAnalize.add(((File)serializable).toString());
                    arrayList3.add(((File)serializable).toString());
                }
                continue;
            }
            object2 = arrayList.get(n).replace(".", File.separator);
            File file3 = new File((String)object2 + ".java");
            object = new File((String)object2 + ".class");
            if (file3.isFile() && (!((File)object).isFile() || recompileAll || ((File)object).isFile() && file3.lastModified() > ((File)object).lastModified())) {
                for (int i = 0; i < arrayList2.size(); ++i) {
                    if (!((String)arrayList2.get(i)).substring(((String)arrayList2.get(i)).lastIndexOf(File.separator) + 1).equals(file3.toString().substring(file3.toString().lastIndexOf(File.separator) + 1))) continue;
                    arrayList2.remove(i);
                }
                serializable2 = javaFilesToCompile;
                synchronized (serializable2) {
                    if (!javaFilesToCompile.contains(file3.toString())) {
                        javaFilesToCompile.add(file3.toString());
                    }
                }
                arrayList2.add(file3.toString());
                continue;
            }
            if (!((File)object).isFile() || ((File)object).getName().indexOf("$") >= 0) continue;
            classFilesToAnalize.add(((File)object).toString());
            arrayList3.add(((File)object).toString());
        }
        for (String string3 : treeSet) {
            if (!string3.contains(".")) continue;
            File file4 = new File(string3.replace(".", File.separator) + ".java");
            object = new File(string3.replace(".", File.separator) + ".class");
            if (file4.isFile() && (!((File)object).isFile() || recompileAll || ((File)object).isFile() && file4.lastModified() > ((File)object).lastModified())) {
                serializable2 = javaFilesToCompile;
                synchronized (serializable2) {
                    if (!javaFilesToCompile.contains(file4.toString())) {
                        javaFilesToCompile.add(file4.toString());
                    }
                    continue;
                }
            }
            if (!((File)object).isFile() || ((File)object).getName().indexOf("$") >= 0) continue;
            classFilesToAnalize.add(((File)object).toString());
        }
        for (String string4 : arrayList2) {
            hashSet.add(string4.substring(0, string4.length() - 5));
        }
        for (String string5 : arrayList3) {
            hashSet.add(string5.substring(0, string5.length() - 6));
        }
        javaFilesTOimportedFilesWithoutExtension.put(string, hashSet);
        if (debug) {
            System.out.println("It use the following fies:");
            System.out.println("- java files to compile: " + arrayList2);
            System.out.println("- class files already compiled : " + arrayList3);
        }
    }

    private final void exceptionManagement(String string) {
        if (!string.equals("")) {
            System.out.println(string);
        }
        this.restoreOriginalFiles(true);
        if (isCompilationEnded) {
            System.out.println(typesOfLevel0);
            for (String string2 : typesOfLevel0) {
                File file = new File(string2 + ".class");
                if (!file.exists()) continue;
                file.delete();
            }
        }
        try {
            this.classFilesNotRecompiledButModifiedRestoration(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        endTime = new Date().getTime();
        System.out.println("\nCOMPILATION FAILED (in " + dateFormatter.format(new Date(endTime - startTime)) + ")");
        System.exit(0);
    }

    private final void restoreOriginalFiles(boolean bl) {
        for (String string : renamedJavaFiles) {
            String string2 = string.substring(0, string.lastIndexOf(".")) + "_ORIGINAL_by_atjavac.tmp";
            String string3 = string.substring(0, string.lastIndexOf(".")) + "_MODIFIED_by_atjavac.bak";
            File file = new File(string);
            File file2 = new File(string2);
            File file3 = new File(string3);
            file3.delete();
            if (file.exists()) {
                if (bl) {
                    file.renameTo(file3);
                } else {
                    file.delete();
                }
            }
            if (!file2.exists()) continue;
            file2.renameTo(file);
        }
    }

    static {
        dateFormatter = new SimpleDateFormat("mm:ss:SSS");
        javaFilesToCompile = new ArrayList();
        javaFilesToCompileAlreadyParsed = new TreeSet();
        classFilesToAnalize = new HashSet();
        javaFilesTOfileInfo = new HashMap();
        javaFilesTOimportedFilesWithoutExtension = new HashMap();
        typesOfLevel0 = new ArrayList();
        typesOfLevel0TOjavaFiles = new HashMap();
        annotationsTOelementTypeInfo = new HashMap();
        annotationsWithElementTypeBlockTOexistElementTypeMethod = new HashMap();
        annotationsWithElementTypeExpressionTOexistElementTypeMethod = new HashMap();
        annotationsClassFilesChangedToRestore = new ArrayList();
        renamedJavaFiles = new ArrayList();
        isCompilationEnded = false;
        decimalFormat = new DecimalFormat("00000");
        status = 0;
        Attribute.addAttributeReader((String)"RuntimeVisibleAnnotations", (AttributeReader)new AnnotationsAttributeReader());
        Attribute.addAttributeReader((String)"RuntimeInvisibleAnnotations", (AttributeReader)new AnnotationsAttributeReader());
        Attribute.addAttributeReader((String)"RuntimeVisibleBlockAnnotations", (AttributeReader)new BlockAnnotationsAttributeReader());
        Attribute.addAttributeReader((String)"RuntimeInvisibleBlockAnnotations", (AttributeReader)new BlockAnnotationsAttributeReader());
        Attribute.addAttributeReader((String)"RuntimeVisibleExpressionAnnotations", (AttributeReader)new ExpressionAnnotationsAttributeReader());
        Attribute.addAttributeReader((String)"RuntimeInvisibleExpressionAnnotations", (AttributeReader)new ExpressionAnnotationsAttributeReader());
        Attribute.addAttributeReader((String)"RuntimeVisibleFieldExpressionAnnotations", (AttributeReader)new FieldExpressionAnnotationsAttributeReader());
        Attribute.addAttributeReader((String)"RuntimeInvisibleFieldExpressionAnnotations", (AttributeReader)new FieldExpressionAnnotationsAttributeReader());
        Attribute.addAttributeReader((String)ELEMENT_TYPE_BLOCK_ATTRIBUTE_NAME, (AttributeReader)new ElementTypeBLOCKAttributeReader());
        Attribute.addAttributeReader((String)ELEMENT_TYPE_EXPRESSION_ATTRIBUTE_NAME, (AttributeReader)new ElementTypeEXPRESSIONAttributeReader());
    }
}

