/*
 * Decompiled with CFR 0.152.
 */
package atjavac.parser.util;

import atjavac.parser.util.ClassData;
import atjavac.parser.util.StringIntInt;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileData {
    private String fileName;
    private int level = 0;
    private int numClasses = 0;
    private int currClassIndex = -1;
    private ArrayList<ClassData> classes = new ArrayList();
    private ArrayList<Integer> parentClass = new ArrayList();
    private TreeSet<String> classesAndInterfacesUsed = new TreeSet();
    private ArrayList<String> packages = new ArrayList();
    private int numMethods = 0;
    private HashMap<String, Integer> classToIndex = new HashMap();
    private int numBlockAnnotations = 0;
    private int numBlockAnnotationsWithReturnAsLastStatement = 0;
    private int numExpressionAndFieldExpressionAnnotations = 0;
    private int numExpressionAndFieldExpressionAnnotationsOfLevel0 = 0;
    private int numElementTypeBlocks = 0;
    private int numElementTypeExpressions = 0;
    private int numClassWithETBlockOrETExpression = 0;
    private boolean isElementTypeStaticImported = false;

    public FileData(String string) {
        this.fileName = string;
    }

    public void addPackage(String string) {
        this.packages.add(string);
        if (string.equals("java.lang.annotation.ElementType.*")) {
            this.isElementTypeStaticImported = true;
        }
    }

    public void addClassOrInterfaceType(String string) {
        this.classesAndInterfacesUsed.add(string);
    }

    public void startClass(String string, String string2, int n, int n2) {
        this.classes.add(new ClassData(string, string2, n, n2, this.level));
        int n3 = this.currClassIndex;
        this.currClassIndex = this.numClasses++;
        this.parentClass.add(n3);
        this.classToIndex.put(string2, this.currClassIndex);
        ++this.level;
    }

    public void setCurrClassAsAnnotation() {
        this.classes.get(this.currClassIndex).setAsAnnotation();
    }

    public void endClass(int n, int n2) {
        this.classes.get(this.currClassIndex).setEndClass(n, n2);
        this.currClassIndex = this.parentClass.get(this.currClassIndex);
        --this.level;
    }

    public void addField(String string, boolean bl) {
        this.classes.get(this.currClassIndex).addField(string, bl);
    }

    public void startMethod(String string, int n, int n2, boolean bl) {
        this.classes.get(this.currClassIndex).startMethod(string, n, n2, bl);
        ++this.numMethods;
    }

    public void endMethod(int n, int n2) {
        this.classes.get(this.currClassIndex).endMethod(n, n2);
    }

    public void addElementTypeBlock(int n, int n2, int n3, int n4) {
        this.classes.get(this.currClassIndex).addElementTypeBlock(n, n2, n3, n4);
        ++this.numElementTypeBlocks;
        if (!this.classes.get(this.currClassIndex).existElementTypeExpression()) {
            ++this.numClassWithETBlockOrETExpression;
        }
    }

    public void addElementTypeExpression(int n, int n2, int n3, int n4) {
        this.classes.get(this.currClassIndex).addElementTypeExpression(n, n2, n3, n4);
        ++this.numElementTypeExpressions;
        if (!this.classes.get(this.currClassIndex).existElementTypeBlock()) {
            ++this.numClassWithETBlockOrETExpression;
        }
    }

    public void addElementTypeList(ArrayList<StringIntInt> arrayList) {
        this.classes.get(this.currClassIndex).addElementTypeList(arrayList);
    }

    public void addBlockAnnotation(String string, int n, int n2, int n3, int n4, int n5, int n6, int n7, String string2, int n8, int n9, boolean bl) {
        this.classes.get(this.currClassIndex).addBlockAnnotation(string, n, n2, n3, n4, n5, n6, n7, string2, n8, n9, bl);
        ++this.numBlockAnnotations;
        if (string2.equals("ReturnStatement")) {
            ++this.numBlockAnnotationsWithReturnAsLastStatement;
        }
    }

    public void addExpressionAnnotation(String string, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        this.classes.get(this.currClassIndex).addExpressionAnnotation(string, n, n2, n3, n4, n5, n6, n7, n8);
        ++this.numExpressionAndFieldExpressionAnnotations;
        if (n8 == 0) {
            ++this.numExpressionAndFieldExpressionAnnotationsOfLevel0;
        }
    }

    public void addMethodAnnotations(ArrayList<StringIntInt> arrayList) {
        this.classes.get(this.currClassIndex).addMethodAnnotations(arrayList);
    }

    public String getFileName() {
        return this.fileName;
    }

    public ArrayList<ClassData> getClasses() {
        return this.classes;
    }

    public ClassData getClass(String string) {
        return this.classes.get(this.classToIndex.get(string));
    }

    public ArrayList<String> getPackages() {
        return this.packages;
    }

    public boolean isElementTypeStaticImported() {
        return this.isElementTypeStaticImported;
    }

    public TreeSet<String> getClassesAndInterfacesUsed() {
        return this.classesAndInterfacesUsed;
    }

    public int getNumMethods() {
        return this.numMethods;
    }

    public int getNumElementTypeBlocks() {
        return this.numElementTypeBlocks;
    }

    public int getNumElementTypeExpressions() {
        return this.numElementTypeExpressions;
    }

    public int getNumBlockAnnotations() {
        return this.numBlockAnnotations;
    }

    public int getNumBlockAnnotationsWithReturnAsLastStatement() {
        return this.numBlockAnnotationsWithReturnAsLastStatement;
    }

    public int getNumExpressionAndFieldExpressionAnnotations() {
        return this.numExpressionAndFieldExpressionAnnotations;
    }

    public int numExpressionAndFieldExpressionAnnotationsOfLevel0() {
        return this.numExpressionAndFieldExpressionAnnotationsOfLevel0;
    }

    public int getNumClassWithElementTypeBlockOrElementTypeExpression() {
        return this.numClassWithETBlockOrETExpression;
    }

    public void print() {
        for (ClassData classData : this.classes) {
            System.out.println("\nCLASSE:'" + classData.getDeclaration() + "':");
            classData.print();
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("{");
        for (int i = 0; i < this.classes.size(); ++i) {
            if (i < this.classes.size() - 1) {
                stringBuffer.append(this.classes.get(i).getName()).append(",");
                continue;
            }
            stringBuffer.append(this.classes.get(i).getName());
        }
        stringBuffer.append("}");
        return "[classes=" + stringBuffer.toString() + ", packages=" + this.packages + ", classesAndInterfacesUsed=" + this.classesAndInterfacesUsed + "]";
    }
}

