/*
 * Decompiled with CFR 0.152.
 */
package atjavac.bcel.extensions;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;

public class StringEscapeUtils {
    public static String escapeJava(String string) {
        return StringEscapeUtils.escapeJavaStyleString(string, false);
    }

    public static void escapeJava(Writer writer, String string) throws IOException {
        StringEscapeUtils.escapeJavaStyleString(writer, string, false);
    }

    public static String escapeJavaScript(String string) {
        return StringEscapeUtils.escapeJavaStyleString(string, true);
    }

    public static void escapeJavaScript(Writer writer, String string) throws IOException {
        StringEscapeUtils.escapeJavaStyleString(writer, string, true);
    }

    private static String escapeJavaStyleString(String string, boolean bl) {
        if (string == null) {
            return null;
        }
        try {
            StringWriter stringWriter = new StringWriter(string.length() * 2);
            StringEscapeUtils.escapeJavaStyleString(stringWriter, string, bl);
            return stringWriter.toString();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    private static void escapeJavaStyleString(Writer writer, String string, boolean bl) throws IOException {
        if (writer == null) {
            throw new IllegalArgumentException("The Writer must not be null");
        }
        if (string == null) {
            return;
        }
        int n = string.length();
        block12: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c > '\u0fff') {
                writer.write("\\u" + StringEscapeUtils.hex(c));
                continue;
            }
            if (c > '\u00ff') {
                writer.write("\\u0" + StringEscapeUtils.hex(c));
                continue;
            }
            if (c > '\u007f') {
                writer.write("\\u00" + StringEscapeUtils.hex(c));
                continue;
            }
            if (c < ' ') {
                switch (c) {
                    case '\b': {
                        writer.write(92);
                        writer.write(98);
                        break;
                    }
                    case '\n': {
                        writer.write(92);
                        writer.write(110);
                        break;
                    }
                    case '\t': {
                        writer.write(92);
                        writer.write(116);
                        break;
                    }
                    case '\f': {
                        writer.write(92);
                        writer.write(102);
                        break;
                    }
                    case '\r': {
                        writer.write(92);
                        writer.write(114);
                        break;
                    }
                    default: {
                        if (c > '\u000f') {
                            writer.write("\\u00" + StringEscapeUtils.hex(c));
                            break;
                        }
                        writer.write("\\u000" + StringEscapeUtils.hex(c));
                        break;
                    }
                }
                continue;
            }
            switch (c) {
                case '\'': {
                    if (bl) {
                        writer.write(92);
                    }
                    writer.write(39);
                    continue block12;
                }
                case '\"': {
                    writer.write(92);
                    writer.write(34);
                    continue block12;
                }
                case '\\': {
                    writer.write(92);
                    writer.write(92);
                    continue block12;
                }
                default: {
                    writer.write(c);
                }
            }
        }
    }

    private static String hex(char c) {
        return Integer.toHexString(c).toUpperCase();
    }

    public static String unescapeJava(String string) {
        if (string == null) {
            return null;
        }
        try {
            StringWriter stringWriter = new StringWriter(string.length());
            StringEscapeUtils.unescapeJava(stringWriter, string);
            return stringWriter.toString();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    public static void unescapeJava(Writer writer, String string) throws IOException {
        if (writer == null) {
            throw new IllegalArgumentException("The Writer must not be null");
        }
        if (string == null) {
            return;
        }
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(4);
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (bl2) {
                stringBuffer.append(c);
                if (stringBuffer.length() != 4) continue;
                try {
                    int n2 = Integer.parseInt(stringBuffer.toString(), 16);
                    writer.write((char)n2);
                    stringBuffer.setLength(0);
                    bl2 = false;
                    bl = false;
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("Unable to parse unicode value: " + stringBuffer);
                }
                continue;
            }
            if (bl) {
                bl = false;
                switch (c) {
                    case '\\': {
                        writer.write(92);
                        break;
                    }
                    case '\'': {
                        writer.write(39);
                        break;
                    }
                    case '\"': {
                        writer.write(34);
                        break;
                    }
                    case 'r': {
                        writer.write(13);
                        break;
                    }
                    case 'f': {
                        writer.write(12);
                        break;
                    }
                    case 't': {
                        writer.write(9);
                        break;
                    }
                    case 'n': {
                        writer.write(10);
                        break;
                    }
                    case 'b': {
                        writer.write(8);
                        break;
                    }
                    case 'u': {
                        bl2 = true;
                        break;
                    }
                    default: {
                        writer.write(c);
                        break;
                    }
                }
                continue;
            }
            if (c == '\\') {
                bl = true;
                continue;
            }
            writer.write(c);
        }
        if (bl) {
            writer.write(92);
        }
    }

    public static String unescapeJavaScript(String string) {
        return StringEscapeUtils.unescapeJava(string);
    }

    public static void unescapeJavaScript(Writer writer, String string) throws IOException {
        StringEscapeUtils.unescapeJava(writer, string);
    }
}

