/*
 * Decompiled with CFR 0.152.
 */
package atjavac.bcel.extensions;

import atjavac.bcel.extensions.Annotation;
import atjavac.bcel.extensions.Conversion;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.generic.ConstantPoolGen;

public class CodeAnnotation
implements Comparable {
    private int startPc;
    private int endPc;
    private int startSourceLine;
    private int startSourceColumn;
    private int endSourceLine;
    private int endSourceColumn;
    private int level;
    private Annotation annotation;

    public CodeAnnotation(int n, int n2, int n3, int n4, int n5, int n6, int n7, Annotation annotation) {
        this.startPc = n;
        this.endPc = n2;
        this.startSourceLine = n3;
        this.startSourceColumn = n4;
        this.endSourceLine = n5;
        this.endSourceColumn = n6;
        this.level = n7;
        this.annotation = annotation;
    }

    public CodeAnnotation(DataInputStream dataInputStream, ConstantPool constantPool) throws IOException {
        this.startPc = dataInputStream.readShort();
        this.endPc = dataInputStream.readShort();
        this.startSourceLine = dataInputStream.readShort();
        this.startSourceColumn = dataInputStream.readShort();
        this.endSourceLine = dataInputStream.readShort();
        this.endSourceColumn = dataInputStream.readShort();
        this.level = dataInputStream.readShort();
        this.annotation = new Annotation(dataInputStream, constantPool);
    }

    public int compareTo(Object object) {
        if (object instanceof CodeAnnotation) {
            CodeAnnotation codeAnnotation = (CodeAnnotation)object;
            if (this.startSourceLine != codeAnnotation.getStartSourceLine()) {
                return this.startSourceLine - codeAnnotation.getStartSourceLine();
            }
            if (this.startSourceColumn != codeAnnotation.getStartSourceColumn()) {
                return this.startSourceColumn - codeAnnotation.getStartSourceColumn();
            }
            if (this.endSourceLine != codeAnnotation.getEndSourceLine()) {
                return this.endSourceLine - codeAnnotation.getEndSourceLine();
            }
            return this.endSourceColumn - codeAnnotation.getEndSourceColumn();
        }
        return 0;
    }

    public int getStartPc() {
        return this.startPc;
    }

    public int getEndPc() {
        return this.endPc;
    }

    public int getStartSourceLine() {
        return this.startSourceLine;
    }

    public int getStartSourceColumn() {
        return this.startSourceColumn;
    }

    public int getEndSourceLine() {
        return this.endSourceLine;
    }

    public int getEndSourceColumn() {
        return this.endSourceColumn;
    }

    public int getLevel() {
        return this.level;
    }

    public Annotation getAnnotation() {
        return this.annotation;
    }

    public int getLength(ConstantPool constantPool) {
        return 14 + this.annotation.getLength(constantPool);
    }

    public void dump(DataOutputStream dataOutputStream, ConstantPoolGen constantPoolGen) throws IOException {
        dataOutputStream.writeShort(this.startPc);
        dataOutputStream.writeShort(this.endPc);
        dataOutputStream.writeShort(this.startSourceLine);
        dataOutputStream.writeShort(this.startSourceColumn);
        dataOutputStream.writeShort(this.endSourceLine);
        dataOutputStream.writeShort(this.endSourceColumn);
        dataOutputStream.writeShort(this.level);
        this.annotation.dump(dataOutputStream, constantPoolGen);
    }

    public ByteArrayOutputStream getBytecode(ByteArrayOutputStream byteArrayOutputStream, ConstantPoolGen constantPoolGen) {
        byteArrayOutputStream.write(Conversion.get2BytesFromInt(this.startPc), 0, 2);
        byteArrayOutputStream.write(Conversion.get2BytesFromInt(this.endPc), 0, 2);
        byteArrayOutputStream.write(Conversion.get2BytesFromInt(this.startSourceLine), 0, 2);
        byteArrayOutputStream.write(Conversion.get2BytesFromInt(this.startSourceColumn), 0, 2);
        byteArrayOutputStream.write(Conversion.get2BytesFromInt(this.endSourceLine), 0, 2);
        byteArrayOutputStream.write(Conversion.get2BytesFromInt(this.endSourceColumn), 0, 2);
        byteArrayOutputStream.write(Conversion.get2BytesFromInt(this.level), 0, 2);
        byteArrayOutputStream = this.annotation.getBytecode(byteArrayOutputStream, constantPoolGen);
        return byteArrayOutputStream;
    }

    public ByteArrayOutputStream getAnnotationBytecode(ByteArrayOutputStream byteArrayOutputStream, ConstantPoolGen constantPoolGen) {
        byteArrayOutputStream = this.annotation.getBytecode(byteArrayOutputStream, constantPoolGen);
        return byteArrayOutputStream;
    }

    public ByteArrayOutputStream getAnnotationBytecodeAsAttributeWithoutHeader(ConstantPool constantPool) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ConstantPoolGen constantPoolGen = new ConstantPoolGen(constantPool);
        byteArrayOutputStream.write(Conversion.get2BytesFromInt(1), 0, 2);
        byteArrayOutputStream = this.annotation.getBytecode(byteArrayOutputStream, constantPoolGen);
        return byteArrayOutputStream;
    }

    public int getLengthAsAnnotation(ConstantPool constantPool) {
        return this.annotation.getLength(constantPool);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("level: ").append(this.level).append(" ");
        stringBuffer.append("startPc: ").append(this.startPc).append(" ");
        stringBuffer.append("endPc: ").append(this.endPc).append(" ");
        stringBuffer.append("startSourceLine: ").append(this.startSourceLine).append(" ");
        stringBuffer.append("startSourceColumn: ").append(this.startSourceColumn).append(" ");
        stringBuffer.append("endSourceLine: ").append(this.endSourceLine).append(" ");
        stringBuffer.append("endSourceColumn: ").append(this.endSourceColumn).append(" ");
        stringBuffer.append("annotation: ").append(this.annotation.toString()).append(" ");
        return stringBuffer.toString();
    }

    public String toStringExpanded() {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("level: ").append(this.level).append("\n");
        stringBuffer.append("startPc: ").append(this.startPc).append("\n");
        stringBuffer.append("endPc: ").append(this.endPc).append("\n");
        stringBuffer.append("startSourceLine: ").append(this.startSourceLine).append("\n");
        stringBuffer.append("startSourceColumn: ").append(this.startSourceColumn).append("\n");
        stringBuffer.append("endSourceLine: ").append(this.endSourceLine).append("\n");
        stringBuffer.append("endSourceColumn: ").append(this.endSourceColumn).append("\n");
        stringBuffer.append("annotation: ").append(this.annotation.toStringExpanded());
        return stringBuffer.toString();
    }
}

