/*
 * Decompiled with CFR 0.152.
 */
package atjavac.bcel.extensions;

import atjavac.bcel.extensions.Annotation;
import atjavac.bcel.extensions.Conversion;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.Visitor;
import org.apache.bcel.generic.ConstantPoolGen;

public class AnnotationsAttribute
extends Attribute {
    private Annotation[] annotations;

    public AnnotationsAttribute(byte by, int n, int n2, ConstantPool constantPool, Annotation[] annotationArray) {
        super(by, n, n2, constantPool);
        this.annotations = annotationArray;
        this.length = n2;
    }

    public Annotation[] getAnnotations() {
        return this.annotations;
    }

    public void accept(Visitor visitor) {
        throw new UnsupportedOperationException();
    }

    public int getLength(ConstantPool constantPool) {
        int n = 0;
        for (Annotation annotation : this.annotations) {
            n += annotation.getLength(constantPool);
        }
        return 2 + n;
    }

    public void dump(DataOutputStream dataOutputStream) throws IOException {
        ConstantPoolGen constantPoolGen = new ConstantPoolGen(this.getConstantPool());
        dataOutputStream.writeShort(this.getNameIndex());
        dataOutputStream.writeInt(this.getLength(this.getConstantPool()));
        dataOutputStream.writeShort(this.annotations.length);
        for (Annotation annotation : this.annotations) {
            annotation.dump(dataOutputStream, constantPoolGen);
        }
    }

    public ByteArrayOutputStream getBytecode() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ConstantPoolGen constantPoolGen = new ConstantPoolGen(this.getConstantPool());
        byteArrayOutputStream.write(Conversion.get2BytesFromInt(this.getNameIndex()), 0, 2);
        byteArrayOutputStream.write(Conversion.get4BytesFromInt(this.getLength(this.getConstantPool())), 0, 4);
        byteArrayOutputStream.write(Conversion.get2BytesFromInt(this.annotations.length), 0, 2);
        for (Annotation annotation : this.annotations) {
            byteArrayOutputStream = annotation.getBytecode(byteArrayOutputStream, constantPoolGen);
        }
        return byteArrayOutputStream;
    }

    public Attribute copy(ConstantPool constantPool) {
        return this;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        for (Annotation annotation : this.annotations) {
            stringBuffer.append(annotation.toString());
            if (n < this.annotations.length) {
                stringBuffer.append(" ");
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public String toStringExpanded() {
        StringBuffer stringBuffer = new StringBuffer();
        for (Annotation annotation : this.annotations) {
            stringBuffer.append(annotation.toStringExpanded());
        }
        return stringBuffer.toString();
    }
}

