/*
 * Decompiled with CFR 0.152.
 */
package atjavac.bcel.extensions;

import atjavac.bcel.extensions.Conversion;
import atjavac.bcel.extensions.ElementValuePair;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.generic.ConstantPoolGen;

public class Annotation {
    private String type;
    private String cleanedType;
    private String dottedType;
    private ElementValuePair[] elementValuePairs;
    int lastInsert = 0;

    public Annotation(String string, ElementValuePair[] elementValuePairArray) {
        this.type = string;
        this.cleanedType = string.substring(string.lastIndexOf("/") + 1, string.length() - 1);
        this.dottedType = string.substring(1, string.length() - 1).replace("/", ".");
        System.out.println(this.dottedType);
        this.elementValuePairs = elementValuePairArray;
    }

    public Annotation(DataInputStream dataInputStream, ConstantPool constantPool) throws IOException {
        short s = dataInputStream.readShort();
        this.type = constantPool.constantToString(constantPool.getConstant((int)s));
        this.cleanedType = this.type.substring(this.type.lastIndexOf("/") + 1, this.type.length() - 1);
        this.dottedType = this.type.substring(1, this.type.length() - 1).replace("/", ".");
        int n = dataInputStream.readShort();
        this.elementValuePairs = new ElementValuePair[n];
        for (int i = 0; i < n; ++i) {
            this.elementValuePairs[i] = new ElementValuePair(dataInputStream, constantPool);
        }
    }

    public Annotation(String string, int n) {
        this.type = string;
        this.cleanedType = string.substring(string.lastIndexOf("/") + 1, string.length() - 1);
        this.dottedType = string.substring(1, string.length() - 1).replace("/", ".");
        this.elementValuePairs = new ElementValuePair[n];
    }

    public void addElementValuePair(ElementValuePair elementValuePair) {
        this.elementValuePairs[this.lastInsert] = elementValuePair;
        ++this.lastInsert;
    }

    public String getType() {
        return this.type;
    }

    public String getCleanedType() {
        return this.cleanedType;
    }

    public String getDottedType() {
        return this.dottedType;
    }

    public int getNumElementValuePairs() {
        return this.elementValuePairs.length;
    }

    public ElementValuePair[] getElementValuePairs() {
        return this.elementValuePairs;
    }

    public ElementValuePair getElementValuePair(int n) {
        return this.elementValuePairs[n];
    }

    public ElementValuePair getElementValuePair(String string) {
        for (ElementValuePair elementValuePair : this.elementValuePairs) {
            if (!elementValuePair.getName().equals(string)) continue;
            return elementValuePair;
        }
        return null;
    }

    public int getLength(ConstantPool constantPool) {
        int n = 0;
        for (ElementValuePair elementValuePair : this.elementValuePairs) {
            n += elementValuePair.getLength(constantPool);
        }
        return 4 + n;
    }

    public void dump(DataOutputStream dataOutputStream, ConstantPoolGen constantPoolGen) throws IOException {
        dataOutputStream.writeShort(constantPoolGen.lookupUtf8(this.type));
        dataOutputStream.writeShort(this.elementValuePairs.length);
        for (ElementValuePair elementValuePair : this.elementValuePairs) {
            elementValuePair.dump(dataOutputStream, constantPoolGen);
        }
    }

    public ByteArrayOutputStream getBytecode(ByteArrayOutputStream byteArrayOutputStream, ConstantPoolGen constantPoolGen) {
        byteArrayOutputStream.write(Conversion.get2BytesFromInt(constantPoolGen.lookupUtf8(this.type)), 0, 2);
        byteArrayOutputStream.write(Conversion.get2BytesFromInt(this.elementValuePairs.length), 0, 2);
        for (ElementValuePair elementValuePair : this.elementValuePairs) {
            byteArrayOutputStream = elementValuePair.getBytecode(byteArrayOutputStream, constantPoolGen);
        }
        return byteArrayOutputStream;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("@").append(this.cleanedType).append("(");
        int n = 0;
        for (ElementValuePair elementValuePair : this.elementValuePairs) {
            stringBuffer.append(elementValuePair.toString());
            if (n < this.elementValuePairs.length - 1) {
                stringBuffer.append(", ");
            }
            ++n;
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public String toStringExpanded() {
        StringBuffer stringBuffer = new StringBuffer("\n------------------------\nANNOTATION\n------------------------");
        stringBuffer.append("\nType=").append(this.type);
        stringBuffer.append("\nNumElementValuePairs=").append(this.elementValuePairs.length);
        for (ElementValuePair elementValuePair : this.elementValuePairs) {
            stringBuffer.append(elementValuePair.toStringExpanded());
        }
        return stringBuffer.toString();
    }
}

