/*
 * Decompiled with CFR 0.152.
 */
package atjava.lang.annotation;

public class BytecodeUtility {
    private byte[] bytecode;
    private int startPc = 0;
    private int endPc = 0;

    BytecodeUtility(byte[] bytecode, int startPc) {
        this.bytecode = bytecode;
        this.startPc = startPc;
    }

    public String toBinBytecodeString() {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < this.bytecode.length) {
            String bin = Integer.toBinaryString(this.bytecode[i] & 0xFF);
            while (bin.length() != 8) {
                bin = "0" + bin;
            }
            result.append(bin).append(" ");
            ++i;
        }
        return result.toString();
    }

    public String toIntBytecodeString() {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < this.bytecode.length) {
            result.append(this.bytecode[i] & 0xFF).append(" ");
            ++i;
        }
        return result.toString();
    }

    public String toHexBytecodeString() {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < this.bytecode.length) {
            String hex = Integer.toHexString(this.bytecode[i] & 0xFF);
            if (hex.length() == 1) {
                result.append("0x0").append(hex).append(" ");
            } else {
                result.append("0x").append(hex).append(" ");
            }
            ++i;
        }
        return result.toString();
    }

    public String toSymBytecodeString() {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < this.bytecode.length) {
            String instruction;
            switch (this.bytecode[i] & 0xFF) {
                case 0: {
                    instruction = String.valueOf(this.startPc + i) + ": nop";
                    break;
                }
                case 1: {
                    instruction = String.valueOf(this.startPc + i) + ": aconst_null";
                    break;
                }
                case 2: {
                    instruction = String.valueOf(this.startPc + i) + ": iconst_m1";
                    break;
                }
                case 3: {
                    instruction = String.valueOf(this.startPc + i) + ": iconst_0";
                    break;
                }
                case 4: {
                    instruction = String.valueOf(this.startPc + i) + ": iconst_1";
                    break;
                }
                case 5: {
                    instruction = String.valueOf(this.startPc + i) + ": iconst_2";
                    break;
                }
                case 6: {
                    instruction = String.valueOf(this.startPc + i) + ": iconst_3";
                    break;
                }
                case 7: {
                    instruction = String.valueOf(this.startPc + i) + ": iconst_4";
                    break;
                }
                case 8: {
                    instruction = String.valueOf(this.startPc + i) + ": iconst_5";
                    break;
                }
                case 9: {
                    instruction = String.valueOf(this.startPc + i) + ": lconst_0";
                    break;
                }
                case 10: {
                    instruction = String.valueOf(this.startPc + i) + ": lconst_1";
                    break;
                }
                case 11: {
                    instruction = String.valueOf(this.startPc + i) + ": fconst_0";
                    break;
                }
                case 12: {
                    instruction = String.valueOf(this.startPc + i) + ": fconst_1";
                    break;
                }
                case 13: {
                    instruction = String.valueOf(this.startPc + i) + ": fconst_2";
                    break;
                }
                case 14: {
                    instruction = String.valueOf(this.startPc + i) + ": dconst_0";
                    break;
                }
                case 15: {
                    instruction = String.valueOf(this.startPc + i) + ": dconst_1";
                    break;
                }
                case 16: {
                    instruction = String.valueOf(this.startPc + i) + ": bipush " + (this.bytecode[i + 1] & 0xFF);
                    ++i;
                    break;
                }
                case 17: {
                    instruction = String.valueOf(this.startPc + i) + ": sipush " + ((this.bytecode[i + 2] & 0xFF) + ((this.bytecode[i + 1] & 0xFF) << 8));
                    i += 2;
                    break;
                }
                case 18: {
                    instruction = String.valueOf(this.startPc + i) + ": ldc #" + (this.bytecode[i + 1] & 0xFF);
                    ++i;
                    break;
                }
                case 19: {
                    instruction = String.valueOf(this.startPc + i) + ": ldc_w #" + ((this.bytecode[i + 2] & 0xFF) + ((this.bytecode[i + 1] & 0xFF) << 8));
                    i += 2;
                    break;
                }
                case 20: {
                    instruction = String.valueOf(this.startPc + i) + ": ldc2_w #" + ((this.bytecode[i + 2] & 0xFF) + ((this.bytecode[i + 1] & 0xFF) << 8));
                    i += 2;
                    break;
                }
                case 21: {
                    instruction = String.valueOf(this.startPc + i) + ": iload " + (this.bytecode[i + 1] & 0xFF);
                    ++i;
                    break;
                }
                case 22: {
                    instruction = String.valueOf(this.startPc + i) + ": lload " + (this.bytecode[i + 1] & 0xFF);
                    ++i;
                    break;
                }
                case 23: {
                    instruction = String.valueOf(this.startPc + i) + ": fload " + (this.bytecode[i + 1] & 0xFF);
                    ++i;
                    break;
                }
                case 24: {
                    instruction = String.valueOf(this.startPc + i) + ": dload " + (this.bytecode[i + 1] & 0xFF);
                    ++i;
                    break;
                }
                case 25: {
                    instruction = String.valueOf(this.startPc + i) + ": aload " + (this.bytecode[i + 1] & 0xFF);
                    ++i;
                    break;
                }
                case 26: {
                    instruction = String.valueOf(this.startPc + i) + ": iload_0";
                    break;
                }
                case 27: {
                    instruction = String.valueOf(this.startPc + i) + ": iload_1";
                    break;
                }
                case 28: {
                    instruction = String.valueOf(this.startPc + i) + ": iload_2";
                    break;
                }
                case 29: {
                    instruction = String.valueOf(this.startPc + i) + ": iload_3";
                    break;
                }
                case 30: {
                    instruction = String.valueOf(this.startPc + i) + ": lload_0";
                    break;
                }
                case 31: {
                    instruction = String.valueOf(this.startPc + i) + ": lload_1";
                    break;
                }
                case 32: {
                    instruction = String.valueOf(this.startPc + i) + ": lload_2";
                    break;
                }
                case 33: {
                    instruction = String.valueOf(this.startPc + i) + ": lload_3";
                    break;
                }
                case 34: {
                    instruction = String.valueOf(this.startPc + i) + ": fload_0";
                    break;
                }
                case 35: {
                    instruction = String.valueOf(this.startPc + i) + ": fload_1";
                    break;
                }
                case 36: {
                    instruction = String.valueOf(this.startPc + i) + ": fload_2";
                    break;
                }
                case 37: {
                    instruction = String.valueOf(this.startPc + i) + ": fload_3";
                    break;
                }
                case 38: {
                    instruction = String.valueOf(this.startPc + i) + ": dload_0";
                    break;
                }
                case 39: {
                    instruction = String.valueOf(this.startPc + i) + ": dload_1";
                    break;
                }
                case 40: {
                    instruction = String.valueOf(this.startPc + i) + ": dload_2";
                    break;
                }
                case 41: {
                    instruction = String.valueOf(this.startPc + i) + ": dload_3";
                    break;
                }
                case 42: {
                    instruction = String.valueOf(this.startPc + i) + ": aload_0";
                    break;
                }
                case 43: {
                    instruction = String.valueOf(this.startPc + i) + ": aload_1";
                    break;
                }
                case 44: {
                    instruction = String.valueOf(this.startPc + i) + ": aload_2";
                    break;
                }
                case 45: {
                    instruction = String.valueOf(this.startPc + i) + ": aload_3";
                    break;
                }
                case 46: {
                    instruction = String.valueOf(this.startPc + i) + ": iaload";
                    break;
                }
                case 47: {
                    instruction = String.valueOf(this.startPc + i) + ": laload";
                    break;
                }
                case 48: {
                    instruction = String.valueOf(this.startPc + i) + ": faload";
                    break;
                }
                case 49: {
                    instruction = String.valueOf(this.startPc + i) + ": daload";
                    break;
                }
                case 50: {
                    instruction = String.valueOf(this.startPc + i) + ": aaload";
                    break;
                }
                case 51: {
                    instruction = String.valueOf(this.startPc + i) + ": baload";
                    break;
                }
                case 52: {
                    instruction = String.valueOf(this.startPc + i) + ": caload";
                    break;
                }
                case 53: {
                    instruction = String.valueOf(this.startPc + i) + ": saload";
                    break;
                }
                case 54: {
                    instruction = String.valueOf(this.startPc + i) + ": istore " + (this.bytecode[i + 1] & 0xFF);
                    ++i;
                    break;
                }
                case 55: {
                    instruction = String.valueOf(this.startPc + i) + ": lstore " + (this.bytecode[i + 1] & 0xFF);
                    ++i;
                    break;
                }
                case 56: {
                    instruction = String.valueOf(this.startPc + i) + ": fstore " + (this.bytecode[i + 1] & 0xFF);
                    ++i;
                    break;
                }
                case 57: {
                    instruction = String.valueOf(this.startPc + i) + ": dstore " + (this.bytecode[i + 1] & 0xFF);
                    ++i;
                    break;
                }
                case 58: {
                    instruction = String.valueOf(this.startPc + i) + ": astore " + (this.bytecode[i + 1] & 0xFF);
                    ++i;
                    break;
                }
                case 59: {
                    instruction = String.valueOf(this.startPc + i) + ": istore_0";
                    break;
                }
                case 60: {
                    instruction = String.valueOf(this.startPc + i) + ": istore_1";
                    break;
                }
                case 61: {
                    instruction = String.valueOf(this.startPc + i) + ": istore_2";
                    break;
                }
                case 62: {
                    instruction = String.valueOf(this.startPc + i) + ": istore_3";
                    break;
                }
                case 63: {
                    instruction = String.valueOf(this.startPc + i) + ": lstore_0";
                    break;
                }
                case 64: {
                    instruction = String.valueOf(this.startPc + i) + ": lstore_1";
                    break;
                }
                case 65: {
                    instruction = String.valueOf(this.startPc + i) + ": lstore_2";
                    break;
                }
                case 66: {
                    instruction = String.valueOf(this.startPc + i) + ": lstore_3";
                    break;
                }
                case 67: {
                    instruction = String.valueOf(this.startPc + i) + ": fstore_0";
                    break;
                }
                case 68: {
                    instruction = String.valueOf(this.startPc + i) + ": fstore_1";
                    break;
                }
                case 69: {
                    instruction = String.valueOf(this.startPc + i) + ": fstore_2";
                    break;
                }
                case 70: {
                    instruction = String.valueOf(this.startPc + i) + ": fstore_3";
                    break;
                }
                case 71: {
                    instruction = String.valueOf(this.startPc + i) + ": dstore_0";
                    break;
                }
                case 72: {
                    instruction = String.valueOf(this.startPc + i) + ": dstore_1";
                    break;
                }
                case 73: {
                    instruction = String.valueOf(this.startPc + i) + ": dstore_2";
                    break;
                }
                case 74: {
                    instruction = String.valueOf(this.startPc + i) + ": dstore_3";
                    break;
                }
                case 75: {
                    instruction = String.valueOf(this.startPc + i) + ": astore_0";
                    break;
                }
                case 76: {
                    instruction = String.valueOf(this.startPc + i) + ": astore_1";
                    break;
                }
                case 77: {
                    instruction = String.valueOf(this.startPc + i) + ": astore_2";
                    break;
                }
                case 78: {
                    instruction = String.valueOf(this.startPc + i) + ": astore_3";
                    break;
                }
                case 79: {
                    instruction = String.valueOf(this.startPc + i) + ": iastore";
                    break;
                }
                case 80: {
                    instruction = String.valueOf(this.startPc + i) + ": lastore";
                    break;
                }
                case 81: {
                    instruction = String.valueOf(this.startPc + i) + ": fastore";
                    break;
                }
                case 82: {
                    instruction = String.valueOf(this.startPc + i) + ": dastore";
                    break;
                }
                case 83: {
                    instruction = String.valueOf(this.startPc + i) + ": aastore";
                    break;
                }
                case 84: {
                    instruction = String.valueOf(this.startPc + i) + ": bastore";
                    break;
                }
                case 85: {
                    instruction = String.valueOf(this.startPc + i) + ": castore";
                    break;
                }
                case 86: {
                    instruction = String.valueOf(this.startPc + i) + ": sastore";
                    break;
                }
                case 87: {
                    instruction = String.valueOf(this.startPc + i) + ": pop";
                    break;
                }
                case 88: {
                    instruction = String.valueOf(this.startPc + i) + ": pop2";
                    break;
                }
                case 89: {
                    instruction = String.valueOf(this.startPc + i) + ": dup";
                    break;
                }
                case 90: {
                    instruction = String.valueOf(this.startPc + i) + ": dup_x1";
                    break;
                }
                case 91: {
                    instruction = String.valueOf(this.startPc + i) + ": dup_x2";
                    break;
                }
                case 92: {
                    instruction = String.valueOf(this.startPc + i) + ": dup2";
                    break;
                }
                case 93: {
                    instruction = String.valueOf(this.startPc + i) + ": dup2_x1";
                    break;
                }
                case 94: {
                    instruction = String.valueOf(this.startPc + i) + ": dup2_x2";
                    break;
                }
                case 95: {
                    instruction = String.valueOf(this.startPc + i) + ": swap";
                    break;
                }
                case 96: {
                    instruction = String.valueOf(this.startPc + i) + ": iadd";
                    break;
                }
                case 97: {
                    instruction = String.valueOf(this.startPc + i) + ": ladd";
                    break;
                }
                case 98: {
                    instruction = String.valueOf(this.startPc + i) + ": fadd";
                    break;
                }
                case 99: {
                    instruction = String.valueOf(this.startPc + i) + ": dadd";
                    break;
                }
                case 100: {
                    instruction = String.valueOf(this.startPc + i) + ": isub";
                    break;
                }
                case 101: {
                    instruction = String.valueOf(this.startPc + i) + ": lsub";
                    break;
                }
                case 102: {
                    instruction = String.valueOf(this.startPc + i) + ": fsub";
                    break;
                }
                case 103: {
                    instruction = String.valueOf(this.startPc + i) + ": dsub";
                    break;
                }
                case 104: {
                    instruction = String.valueOf(this.startPc + i) + ": imul";
                    break;
                }
                case 105: {
                    instruction = String.valueOf(this.startPc + i) + ": lmul";
                    break;
                }
                case 106: {
                    instruction = String.valueOf(this.startPc + i) + ": fmul";
                    break;
                }
                case 107: {
                    instruction = String.valueOf(this.startPc + i) + ": dmul";
                    break;
                }
                case 108: {
                    instruction = String.valueOf(this.startPc + i) + ": idiv";
                    break;
                }
                case 109: {
                    instruction = String.valueOf(this.startPc + i) + ": ldiv";
                    break;
                }
                case 110: {
                    instruction = String.valueOf(this.startPc + i) + ": fdiv";
                    break;
                }
                case 111: {
                    instruction = String.valueOf(this.startPc + i) + ": ddiv";
                    break;
                }
                case 112: {
                    instruction = String.valueOf(this.startPc + i) + ": irem";
                    break;
                }
                case 113: {
                    instruction = String.valueOf(this.startPc + i) + ": lrem";
                    break;
                }
                case 114: {
                    instruction = String.valueOf(this.startPc + i) + ": frem";
                    break;
                }
                case 115: {
                    instruction = String.valueOf(this.startPc + i) + ": drem";
                    break;
                }
                case 116: {
                    instruction = String.valueOf(this.startPc + i) + ": ineg";
                    break;
                }
                case 117: {
                    instruction = String.valueOf(this.startPc + i) + ": lneg";
                    break;
                }
                case 118: {
                    instruction = String.valueOf(this.startPc + i) + ": fneg";
                    break;
                }
                case 119: {
                    instruction = String.valueOf(this.startPc + i) + ": dneg";
                    break;
                }
                case 120: {
                    instruction = String.valueOf(this.startPc + i) + ": ishl";
                    break;
                }
                case 121: {
                    instruction = String.valueOf(this.startPc + i) + ": lshl";
                    break;
                }
                case 122: {
                    instruction = String.valueOf(this.startPc + i) + ": ishr";
                    break;
                }
                case 123: {
                    instruction = String.valueOf(this.startPc + i) + ": lshr";
                    break;
                }
                case 124: {
                    instruction = String.valueOf(this.startPc + i) + ": iushr";
                    break;
                }
                case 125: {
                    instruction = String.valueOf(this.startPc + i) + ": lushr";
                    break;
                }
                case 126: {
                    instruction = String.valueOf(this.startPc + i) + ": iand";
                    break;
                }
                case 127: {
                    instruction = String.valueOf(this.startPc + i) + ": land";
                    break;
                }
                case 128: {
                    instruction = String.valueOf(this.startPc + i) + ": ior";
                    break;
                }
                case 129: {
                    instruction = String.valueOf(this.startPc + i) + ": lor";
                    break;
                }
                case 130: {
                    instruction = String.valueOf(this.startPc + i) + ": ixor";
                    break;
                }
                case 131: {
                    instruction = String.valueOf(this.startPc + i) + ": lxor";
                    break;
                }
                case 132: {
                    instruction = String.valueOf(this.startPc + i) + ": iinc " + (this.bytecode[i + 1] & 0xFF) + " by " + (this.bytecode[i + 2] & 0xFF);
                    i += 2;
                    break;
                }
                case 133: {
                    instruction = String.valueOf(this.startPc + i) + ": i2l";
                    break;
                }
                case 134: {
                    instruction = String.valueOf(this.startPc + i) + ": i2f";
                    break;
                }
                case 135: {
                    instruction = String.valueOf(this.startPc + i) + ": i2d";
                    break;
                }
                case 136: {
                    instruction = String.valueOf(this.startPc + i) + ": l2i";
                    break;
                }
                case 137: {
                    instruction = String.valueOf(this.startPc + i) + ": l2f";
                    break;
                }
                case 138: {
                    instruction = String.valueOf(this.startPc + i) + ": l2d";
                    break;
                }
                case 139: {
                    instruction = String.valueOf(this.startPc + i) + ": f2i";
                    break;
                }
                case 140: {
                    instruction = String.valueOf(this.startPc + i) + ": f2l";
                    break;
                }
                case 141: {
                    instruction = String.valueOf(this.startPc + i) + ": f2d";
                    break;
                }
                case 142: {
                    instruction = String.valueOf(this.startPc + i) + ": d2i";
                    break;
                }
                case 143: {
                    instruction = String.valueOf(this.startPc + i) + ": d2l";
                    break;
                }
                case 144: {
                    instruction = String.valueOf(this.startPc + i) + ": d2f";
                    break;
                }
                case 145: {
                    instruction = String.valueOf(this.startPc + i) + ": i2b";
                    break;
                }
                case 146: {
                    instruction = String.valueOf(this.startPc + i) + ": i2c";
                    break;
                }
                case 147: {
                    instruction = String.valueOf(this.startPc + i) + ": i2s";
                    break;
                }
                case 148: {
                    instruction = String.valueOf(this.startPc + i) + ": lcmp";
                    break;
                }
                case 149: {
                    instruction = String.valueOf(this.startPc + i) + ": fcmpl";
                    break;
                }
                case 150: {
                    instruction = String.valueOf(this.startPc + i) + ": fcmpg";
                    break;
                }
                case 151: {
                    instruction = String.valueOf(this.startPc + i) + ": dcmpl";
                    break;
                }
                case 152: {
                    instruction = String.valueOf(this.startPc + i) + ": dcmpg";
                    break;
                }
                case 153: {
                    instruction = String.valueOf(this.startPc + i) + ": ifeq " + (this.startPc + i + ((this.bytecode[i + 2] & 0xFF) + (this.bytecode[i + 1] << 8))) + " (+" + ((this.bytecode[i + 2] & 0xFF) + (this.bytecode[i + 1] << 8)) + ")";
                    i += 2;
                    break;
                }
                case 154: {
                    instruction = String.valueOf(this.startPc + i) + ": ifne " + (this.startPc + i + ((this.bytecode[i + 2] & 0xFF) + (this.bytecode[i + 1] << 8))) + " (+" + ((this.bytecode[i + 2] & 0xFF) + (this.bytecode[i + 1] << 8)) + ")";
                    i += 2;
                    break;
                }
                case 155: {
                    instruction = String.valueOf(this.startPc + i) + ": iflt " + (this.startPc + i + ((this.bytecode[i + 2] & 0xFF) + (this.bytecode[i + 1] << 8))) + " (+" + ((this.bytecode[i + 2] & 0xFF) + (this.bytecode[i + 1] << 8)) + ")";
                    i += 2;
                    break;
                }
                case 156: {
                    instruction = String.valueOf(this.startPc + i) + ": ifge " + (this.startPc + i + ((this.bytecode[i + 2] & 0xFF) + (this.bytecode[i + 1] << 8))) + " (+" + ((this.bytecode[i + 2] & 0xFF) + (this.bytecode[i + 1] << 8)) + ")";
                    i += 2;
                    break;
                }
                case 157: {
                    instruction = String.valueOf(this.startPc + i) + ": ifgt " + (this.startPc + i + ((this.bytecode[i + 2] & 0xFF) + (this.bytecode[i + 1] << 8))) + " (+" + ((this.bytecode[i + 2] & 0xFF) + (this.bytecode[i + 1] << 8)) + ")";
                    i += 2;
                    break;
                }
                case 158: {
                    instruction = String.valueOf(this.startPc + i) + ": ifle " + (this.startPc + i + ((this.bytecode[i + 2] & 0xFF) + (this.bytecode[i + 1] << 8))) + " (+" + ((this.bytecode[i + 2] & 0xFF) + (this.bytecode[i + 1] << 8)) + ")";
                    i += 2;
                    break;
                }
                case 159: {
                    instruction = String.valueOf(this.startPc + i) + ": if_icmpeq " + (this.startPc + i + ((this.bytecode[i + 2] & 0xFF) + (this.bytecode[i + 1] << 8))) + " (+" + ((this.bytecode[i + 2] & 0xFF) + (this.bytecode[i + 1] << 8)) + ")";
                    i += 2;
                    break;
                }
                case 160: {
                    instruction = String.valueOf(this.startPc + i) + ": if_icmpne " + (this.startPc + i + ((this.bytecode[i + 2] & 0xFF) + (this.bytecode[i + 1] << 8))) + " (+" + ((this.bytecode[i + 2] & 0xFF) + (this.bytecode[i + 1] << 8)) + ")";
                    i += 2;
                    break;
                }
                case 161: {
                    instruction = String.valueOf(this.startPc + i) + ": if_icmplt " + (this.startPc + i + ((this.bytecode[i + 2] & 0xFF) + (this.bytecode[i + 1] << 8))) + " (+" + ((this.bytecode[i + 2] & 0xFF) + (this.bytecode[i + 1] << 8)) + ")";
                    i += 2;
                    break;
                }
                case 162: {
                    instruction = String.valueOf(this.startPc + i) + ": if_icmpge " + (this.startPc + i + ((this.bytecode[i + 2] & 0xFF) + (this.bytecode[i + 1] << 8))) + " (+" + ((this.bytecode[i + 2] & 0xFF) + (this.bytecode[i + 1] << 8)) + ")";
                    i += 2;
                    break;
                }
                case 163: {
                    instruction = String.valueOf(this.startPc + i) + ": if_icmpgt " + (this.startPc + i + ((this.bytecode[i + 2] & 0xFF) + (this.bytecode[i + 1] << 8))) + " (+" + ((this.bytecode[i + 2] & 0xFF) + (this.bytecode[i + 1] << 8)) + ")";
                    i += 2;
                    break;
                }
                case 164: {
                    instruction = String.valueOf(this.startPc + i) + ": if_icmple " + (this.startPc + i + ((this.bytecode[i + 2] & 0xFF) + (this.bytecode[i + 1] << 8))) + " (+" + ((this.bytecode[i + 2] & 0xFF) + (this.bytecode[i + 1] << 8)) + ")";
                    i += 2;
                    break;
                }
                case 165: {
                    instruction = String.valueOf(this.startPc + i) + ": if_acmpeq " + (this.startPc + i + ((this.bytecode[i + 2] & 0xFF) + (this.bytecode[i + 1] << 8))) + " (+" + ((this.bytecode[i + 2] & 0xFF) + (this.bytecode[i + 1] << 8)) + ")";
                    i += 2;
                    break;
                }
                case 166: {
                    instruction = String.valueOf(this.startPc + i) + ": if_acmpne " + (this.startPc + i + ((this.bytecode[i + 2] & 0xFF) + (this.bytecode[i + 1] << 8))) + " (+" + ((this.bytecode[i + 2] & 0xFF) + (this.bytecode[i + 1] << 8)) + ")";
                    i += 2;
                    break;
                }
                case 167: {
                    instruction = String.valueOf(this.startPc + i) + ": goto " + (this.startPc + i + ((this.bytecode[i + 2] & 0xFF) + (this.bytecode[i + 1] << 8))) + " (+" + ((this.bytecode[i + 2] & 0xFF) + (this.bytecode[i + 1] << 8)) + ")";
                    i += 2;
                    break;
                }
                case 168: {
                    instruction = String.valueOf(this.startPc + i) + ": jsr " + (this.startPc + i + ((this.bytecode[i + 2] & 0xFF) + (this.bytecode[i + 1] << 8))) + " (+" + ((this.bytecode[i + 2] & 0xFF) + (this.bytecode[i + 1] << 8)) + ")";
                    i += 2;
                    break;
                }
                case 169: {
                    instruction = String.valueOf(this.startPc + i) + ": ret " + (this.bytecode[i + 1] & 0xFF);
                    ++i;
                    break;
                }
                case 170: {
                    int offset;
                    int tmp = i;
                    instruction = String.valueOf(this.startPc + i) + ": tableswitch ";
                    i += (4 - (this.startPc + i + 1) % 4) % 4;
                    int defaultValue = (this.bytecode[i + 4] & 0xFF) + ((this.bytecode[i + 3] & 0xFF) << 8) + ((this.bytecode[i + 2] & 0xFF) << 16) + ((this.bytecode[i + 1] & 0xFF) << 24);
                    int lowValue = (this.bytecode[(i += 4) + 4] & 0xFF) + ((this.bytecode[i + 3] & 0xFF) << 8) + ((this.bytecode[i + 2] & 0xFF) << 16) + ((this.bytecode[i + 1] & 0xFF) << 24);
                    int highValue = (this.bytecode[(i += 4) + 4] & 0xFF) + ((this.bytecode[i + 3] & 0xFF) << 8) + ((this.bytecode[i + 2] & 0xFF) << 16) + ((this.bytecode[i + 1] & 0xFF) << 24);
                    i += 4;
                    instruction = String.valueOf(instruction) + lowValue + " to " + highValue + "\n";
                    int c = 0;
                    while (c < highValue - lowValue + 1) {
                        offset = (this.bytecode[i + 4] & 0xFF) + ((this.bytecode[i + 3] & 0xFF) << 8) + ((this.bytecode[i + 2] & 0xFF) << 16) + ((this.bytecode[i + 1] & 0xFF) << 24);
                        i += 4;
                        instruction = String.valueOf(instruction) + "\t" + c + ": " + (this.startPc + tmp + offset) + " (+" + offset + ")\n";
                        ++c;
                    }
                    instruction = String.valueOf(instruction) + "\tdefault: " + (this.startPc + tmp + defaultValue) + " (+" + defaultValue + ")";
                    break;
                }
                case 171: {
                    int offset;
                    int tmp = i;
                    instruction = String.valueOf(this.startPc + i) + ": lookupswitch ";
                    i += (4 - (this.startPc + i + 1) % 4) % 4;
                    int defaultValue = (this.bytecode[i + 4] & 0xFF) + ((this.bytecode[i + 3] & 0xFF) << 8) + ((this.bytecode[i + 2] & 0xFF) << 16) + ((this.bytecode[i + 1] & 0xFF) << 24);
                    int npairs = (this.bytecode[(i += 4) + 4] & 0xFF) + ((this.bytecode[i + 3] & 0xFF) << 8) + ((this.bytecode[i + 2] & 0xFF) << 16) + ((this.bytecode[i + 1] & 0xFF) << 24);
                    i += 4;
                    instruction = String.valueOf(instruction) + npairs + "\n";
                    int c = 0;
                    while (c < npairs) {
                        int match = (this.bytecode[i + 4] & 0xFF) + ((this.bytecode[i + 3] & 0xFF) << 8) + ((this.bytecode[i + 2] & 0xFF) << 16) + ((this.bytecode[i + 1] & 0xFF) << 24);
                        offset = (this.bytecode[(i += 4) + 4] & 0xFF) + ((this.bytecode[i + 3] & 0xFF) << 8) + ((this.bytecode[i + 2] & 0xFF) << 16) + ((this.bytecode[i + 1] & 0xFF) << 24);
                        i += 4;
                        instruction = String.valueOf(instruction) + "\t" + match + ": " + (this.startPc + tmp + offset) + " (+" + offset + ")\n";
                        ++c;
                    }
                    instruction = String.valueOf(instruction) + "\tdefault: " + (this.startPc + tmp + defaultValue) + " (+" + defaultValue + ")";
                    break;
                }
                case 172: {
                    instruction = String.valueOf(this.startPc + i) + ": ireturn";
                    break;
                }
                case 173: {
                    instruction = String.valueOf(this.startPc + i) + ": lreturn";
                    break;
                }
                case 174: {
                    instruction = String.valueOf(this.startPc + i) + ": freturn";
                    break;
                }
                case 175: {
                    instruction = String.valueOf(this.startPc + i) + ": dreturn";
                    break;
                }
                case 176: {
                    instruction = String.valueOf(this.startPc + i) + ": areturn";
                    break;
                }
                case 177: {
                    instruction = String.valueOf(this.startPc + i) + ": return";
                    break;
                }
                case 178: {
                    instruction = String.valueOf(this.startPc + i) + ": getstatic #" + ((this.bytecode[i + 2] & 0xFF) + ((this.bytecode[i + 1] & 0xFF) << 8));
                    i += 2;
                    break;
                }
                case 179: {
                    instruction = String.valueOf(this.startPc + i) + ": putstatic #" + ((this.bytecode[i + 2] & 0xFF) + ((this.bytecode[i + 1] & 0xFF) << 8));
                    i += 2;
                    break;
                }
                case 180: {
                    instruction = String.valueOf(this.startPc + i) + ": getfield #" + ((this.bytecode[i + 2] & 0xFF) + ((this.bytecode[i + 1] & 0xFF) << 8));
                    i += 2;
                    break;
                }
                case 181: {
                    instruction = String.valueOf(this.startPc + i) + ": putfield #" + ((this.bytecode[i + 2] & 0xFF) + ((this.bytecode[i + 1] & 0xFF) << 8));
                    i += 2;
                    break;
                }
                case 182: {
                    instruction = String.valueOf(this.startPc + i) + ": invokevirtual #" + ((this.bytecode[i + 2] & 0xFF) + ((this.bytecode[i + 1] & 0xFF) << 8));
                    i += 2;
                    break;
                }
                case 183: {
                    instruction = String.valueOf(this.startPc + i) + ": invokespecial #" + ((this.bytecode[i + 2] & 0xFF) + ((this.bytecode[i + 1] & 0xFF) << 8));
                    i += 2;
                    break;
                }
                case 184: {
                    instruction = String.valueOf(this.startPc + i) + ": invokestatic #" + ((this.bytecode[i + 2] & 0xFF) + ((this.bytecode[i + 1] & 0xFF) << 8));
                    i += 2;
                    break;
                }
                case 185: {
                    instruction = String.valueOf(this.startPc + i) + ": invokeinterface #" + ((this.bytecode[i + 2] & 0xFF) + ((this.bytecode[i + 1] & 0xFF) << 8)) + " " + (this.bytecode[i + 3] & 0xFF);
                    i += 4;
                    break;
                }
                case 186: {
                    instruction = String.valueOf(this.startPc + i) + ": xxxunusedxxx";
                    break;
                }
                case 187: {
                    instruction = String.valueOf(this.startPc + i) + ": new #" + ((this.bytecode[i + 2] & 0xFF) + ((this.bytecode[i + 1] & 0xFF) << 8));
                    i += 2;
                    break;
                }
                case 188: {
                    instruction = String.valueOf(this.startPc + i) + ": newarray ";
                    int arrayType = this.bytecode[i + 1] & 0xFF;
                    ++i;
                    switch (arrayType) {
                        case 4: {
                            instruction = String.valueOf(instruction) + "boolean";
                        }
                        case 5: {
                            instruction = String.valueOf(instruction) + "char";
                        }
                        case 6: {
                            instruction = String.valueOf(instruction) + "float";
                        }
                        case 7: {
                            instruction = String.valueOf(instruction) + "double";
                        }
                        case 8: {
                            instruction = String.valueOf(instruction) + "byte";
                        }
                        case 9: {
                            instruction = String.valueOf(instruction) + "short";
                        }
                        case 10: {
                            instruction = String.valueOf(instruction) + "int";
                        }
                        case 11: {
                            instruction = String.valueOf(instruction) + "long";
                        }
                    }
                    instruction = String.valueOf(instruction) + "invalid array type";
                    break;
                }
                case 189: {
                    instruction = String.valueOf(this.startPc + i) + ": anewarray #" + ((this.bytecode[i + 2] & 0xFF) + ((this.bytecode[i + 1] & 0xFF) << 8));
                    i += 2;
                    break;
                }
                case 190: {
                    instruction = String.valueOf(this.startPc + i) + ": arraylength";
                    break;
                }
                case 191: {
                    instruction = String.valueOf(this.startPc + i) + ": athrow";
                    break;
                }
                case 192: {
                    instruction = String.valueOf(this.startPc + i) + ": checkcast #" + ((this.bytecode[i + 2] & 0xFF) + ((this.bytecode[i + 1] & 0xFF) << 8));
                    i += 2;
                    break;
                }
                case 193: {
                    instruction = String.valueOf(this.startPc + i) + ": instanceof #" + ((this.bytecode[i + 2] & 0xFF) + ((this.bytecode[i + 1] & 0xFF) << 8));
                    i += 2;
                    break;
                }
                case 194: {
                    instruction = String.valueOf(this.startPc + i) + ": monitorenter";
                    break;
                }
                case 195: {
                    instruction = String.valueOf(this.startPc + i) + ": monitorexit";
                    break;
                }
                case 196: {
                    instruction = String.valueOf(this.startPc + i) + ": wide ";
                    int opcode = this.bytecode[i + 1] & 0xFF;
                    ++i;
                    switch (opcode) {
                        case 21: {
                            instruction = "iload " + ((this.bytecode[i + 2] & 0xFF) + ((this.bytecode[i + 1] & 0xFF) << 8));
                            i += 2;
                            break;
                        }
                        case 22: {
                            instruction = "lload " + ((this.bytecode[i + 2] & 0xFF) + ((this.bytecode[i + 1] & 0xFF) << 8));
                            i += 2;
                            break;
                        }
                        case 23: {
                            instruction = "fload " + ((this.bytecode[i + 2] & 0xFF) + ((this.bytecode[i + 1] & 0xFF) << 8));
                            i += 2;
                            break;
                        }
                        case 24: {
                            instruction = "dload " + ((this.bytecode[i + 2] & 0xFF) + ((this.bytecode[i + 1] & 0xFF) << 8));
                            i += 2;
                            break;
                        }
                        case 25: {
                            instruction = "aload " + ((this.bytecode[i + 2] & 0xFF) + ((this.bytecode[i + 1] & 0xFF) << 8));
                            i += 2;
                            break;
                        }
                        case 54: {
                            instruction = "istore " + ((this.bytecode[i + 2] & 0xFF) + ((this.bytecode[i + 1] & 0xFF) << 8));
                            i += 2;
                            break;
                        }
                        case 55: {
                            instruction = "lstore " + ((this.bytecode[i + 2] & 0xFF) + ((this.bytecode[i + 1] & 0xFF) << 8));
                            i += 2;
                            break;
                        }
                        case 56: {
                            instruction = "fstore " + ((this.bytecode[i + 2] & 0xFF) + ((this.bytecode[i + 1] & 0xFF) << 8));
                            i += 2;
                            break;
                        }
                        case 57: {
                            instruction = "dstore " + ((this.bytecode[i + 2] & 0xFF) + ((this.bytecode[i + 1] & 0xFF) << 8));
                            i += 2;
                            break;
                        }
                        case 58: {
                            instruction = "astore " + ((this.bytecode[i + 2] & 0xFF) + ((this.bytecode[i + 1] & 0xFF) << 8));
                            i += 2;
                            break;
                        }
                        case 169: {
                            instruction = "ret " + ((this.bytecode[i + 2] & 0xFF) + ((this.bytecode[i + 1] & 0xFF) << 8));
                            i += 2;
                            break;
                        }
                        case 132: {
                            instruction = "iinc " + ((this.bytecode[i + 2] & 0xFF) + ((this.bytecode[i + 1] & 0xFF) << 8)) + " by " + ((this.bytecode[i + 4] & 0xFF) + (this.bytecode[i + 3] & 0xFF) << 8);
                            i += 4;
                        }
                    }
                    break;
                }
                case 197: {
                    instruction = String.valueOf(this.startPc + i) + ": multianewarray #" + ((this.bytecode[i + 2] & 0xFF) + (this.bytecode[i + 1] & 0xFF) << 8) + " dim " + (this.bytecode[i + 3] & 0xFF);
                    i += 3;
                    break;
                }
                case 198: {
                    instruction = String.valueOf(this.startPc + i) + ": ifnull " + (this.startPc + i + ((this.bytecode[i + 2] & 0xFF) + (this.bytecode[i + 1] << 8))) + " (+" + ((this.bytecode[i + 2] & 0xFF) + (this.bytecode[i + 1] << 8)) + ")";
                    i += 2;
                    break;
                }
                case 199: {
                    instruction = String.valueOf(this.startPc + i) + ": ifnonnull " + (this.startPc + i + ((this.bytecode[i + 2] & 0xFF) + (this.bytecode[i + 1] << 8))) + " (+" + ((this.bytecode[i + 2] & 0xFF) + (this.bytecode[i + 1] << 8)) + ")";
                    i += 2;
                    break;
                }
                case 200: {
                    instruction = String.valueOf(this.startPc + i) + ": goto_w " + (this.startPc + i + ((this.bytecode[i + 4] & 0xFF) + ((this.bytecode[i + 3] & 0xFF) << 8) + ((this.bytecode[i + 2] & 0xFF) << 16) + (this.bytecode[i + 1] << 24))) + " (+" + ((this.bytecode[i + 4] & 0xFF) + ((this.bytecode[i + 3] & 0xFF) << 8) + ((this.bytecode[i + 2] & 0xFF) << 16) + (this.bytecode[i + 1] << 24)) + ")";
                    i += 4;
                    break;
                }
                case 201: {
                    instruction = String.valueOf(this.startPc + i) + ": jsr_w " + (this.startPc + i + ((this.bytecode[i + 4] & 0xFF) + ((this.bytecode[i + 3] & 0xFF) << 8) + ((this.bytecode[i + 2] & 0xFF) << 16) + (this.bytecode[i + 1] << 24))) + " (+" + ((this.bytecode[i + 4] & 0xFF) + ((this.bytecode[i + 3] & 0xFF) << 8) + ((this.bytecode[i + 2] & 0xFF) << 16) + (this.bytecode[i + 1] << 24)) + ")";
                    i += 4;
                    break;
                }
                case 202: {
                    instruction = String.valueOf(this.startPc + i) + ": breakpoint";
                    break;
                }
                case 254: {
                    instruction = String.valueOf(this.startPc + i) + ": impdep1";
                    break;
                }
                case 255: {
                    instruction = String.valueOf(this.startPc + i) + ": impdep2";
                    break;
                }
                default: {
                    instruction = String.valueOf(this.startPc + i) + ": unknown";
                }
            }
            result.append(instruction).append("\n");
            ++i;
        }
        return result.substring(0, result.length() - 1).toString();
    }
}

