/*
 * Decompiled with CFR 0.152.
 */
package atjava.lang.annotation;

import atjava.lang.annotation.BytecodeUtility;
import atjava.lang.annotation.InvalidReferenceException;
import atjava.lang.annotation.SourceNotAvailableException;
import atjavac.bcel.extensions.ExpressionAnnotation;
import java.lang.annotation.Annotation;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotatedExpression {
    protected int startSourceLine = 0;
    protected int startSourceColumn = 0;
    protected int endSourceLine = 0;
    protected int endSourceColumn = 0;
    private int startSourceIndex = -1;
    private int endSourceIndex = -1;
    private int startBodySourceIndex = -1;
    private int endBodySourceIndex = -1;
    protected int startPc = -1;
    protected int endPc = -1;
    private byte[] bytecode;
    private String annotType = "";
    private String classNameWithPath = "";
    private String sourceFile = "";
    private String source = "";
    private Annotation annotation;
    private boolean isSourceCodeAvailable = true;
    private boolean isSourceCodeChanged = false;
    private boolean isInvalidReferenceExceptionAppens = false;
    private int InvalidReferenceExceptionLine = 0;
    private int InvalidReferenceExceptionColumn = 0;
    private int level = 0;
    private ArrayList<AnnotatedExpression> innerAnnotatedExpressionsList = new ArrayList();

    public int startSourceLine() {
        return this.startSourceLine;
    }

    public int startSourceColumn() {
        return this.startSourceLine;
    }

    public int endSourceLine() {
        return this.startSourceLine;
    }

    public int endSourceColumn() {
        return this.startSourceLine;
    }

    protected AnnotatedExpression(Class c, String sourceFile, boolean isSourceCodeAvailable, boolean isSourceCodeChanged, String sourceCode, byte[] methodBytecode, ExpressionAnnotation ea, Annotation a) {
        this.classNameWithPath = c.getName();
        this.sourceFile = sourceFile;
        this.isSourceCodeAvailable = isSourceCodeAvailable;
        this.isSourceCodeChanged = isSourceCodeChanged;
        this.annotType = ea.getAnnotation().getDottedType();
        this.annotation = a;
        this.level = ea.getLevel();
        this.startPc = ea.getStartPc();
        this.endPc = ea.getEndPc();
        this.startSourceLine = ea.getStartSourceLine();
        this.startSourceColumn = ea.getStartSourceColumn();
        this.endSourceLine = ea.getEndSourceLine();
        this.endSourceColumn = ea.getEndSourceColumn();
        if (this.startPc < methodBytecode.length && this.endPc <= methodBytecode.length) {
            this.bytecode = new byte[this.endPc - this.startPc];
            int currByte = 0;
            int currMethodByte = this.startPc;
            while (currMethodByte < this.endPc) {
                this.bytecode[currByte] = methodBytecode[currMethodByte];
                ++currMethodByte;
                ++currByte;
            }
        }
        if (isSourceCodeAvailable) {
            this.startSourceIndex = this.searchIndexOfPosition(sourceCode, this.startSourceLine, this.startSourceColumn);
            this.endSourceIndex = this.searchIndexOfPosition(sourceCode, this.endSourceLine, this.endSourceColumn) + 1;
            if (this.startSourceIndex > -1 && this.endSourceIndex > -1) {
                this.source = sourceCode.substring(this.startSourceIndex, this.endSourceIndex);
            }
            this.startBodySourceIndex = this.getStartBodySourceIndex();
            this.endBodySourceIndex = this.getEndBodySourceIndex();
        }
    }

    public Annotation[] getExpressionAnnotations() {
        Annotation[] result = new Annotation[this.innerAnnotatedExpressionsList.size()];
        int i = 0;
        while (i < this.innerAnnotatedExpressionsList.size()) {
            result[i] = this.innerAnnotatedExpressionsList.get(i).getAnnotation();
            ++i;
        }
        return result;
    }

    public <T extends Annotation> T[] getExpressionAnnotations(Class<T> annotationClass) {
        if (annotationClass == null) {
            throw new NullPointerException();
        }
        ArrayList<Annotation> resultList = new ArrayList<Annotation>();
        for (AnnotatedExpression ab : this.innerAnnotatedExpressionsList) {
            if (!ab.getAnnotationType().equals(annotationClass.getName())) continue;
            resultList.add(ab.getAnnotation());
        }
        Annotation[] result = new Annotation[resultList.size()];
        int i = 0;
        while (i < resultList.size()) {
            result[i] = (Annotation)resultList.get(i);
            ++i;
        }
        return result;
    }

    public boolean areExpressionAnnotationsPresent() {
        return this.innerAnnotatedExpressionsList.size() > 0;
    }

    public boolean areExpressionAnnotationsPresent(Class<? extends Annotation> annotationClass) {
        for (AnnotatedExpression ab : this.innerAnnotatedExpressionsList) {
            if (!ab.getAnnotationType().equals(annotationClass.getName())) continue;
            return true;
        }
        return false;
    }

    public boolean areExpressionAnnotationsPresentAtSomeLevel(Class<? extends Annotation> annotationClass) {
        for (AnnotatedExpression ae : this.innerAnnotatedExpressionsList) {
            if (ae.getAnnotationType().equals(annotationClass.getName())) {
                return true;
            }
            if (!ae.areExpressionAnnotationsPresentAtSomeLevel(annotationClass)) continue;
            return true;
        }
        return false;
    }

    public AnnotatedExpression[] getAnnotatedExpressions() {
        AnnotatedExpression[] result = new AnnotatedExpression[this.innerAnnotatedExpressionsList.size()];
        int i = 0;
        while (i < this.innerAnnotatedExpressionsList.size()) {
            result[i] = this.innerAnnotatedExpressionsList.get(i);
            ++i;
        }
        return result;
    }

    public AnnotatedExpression[] getAnnotatedExpressions(Class<? extends Annotation> annotationClass) {
        if (annotationClass == null) {
            throw new NullPointerException();
        }
        ArrayList<AnnotatedExpression> resultList = new ArrayList<AnnotatedExpression>();
        for (AnnotatedExpression ab : this.innerAnnotatedExpressionsList) {
            if (!ab.getAnnotationType().equals(annotationClass.getName())) continue;
            resultList.add(ab);
        }
        AnnotatedExpression[] result = new AnnotatedExpression[resultList.size()];
        int i = 0;
        while (i < resultList.size()) {
            result[i] = (AnnotatedExpression)resultList.get(i);
            ++i;
        }
        return result;
    }

    protected void addAnnotatedExpression(AnnotatedExpression ae) {
        if (ae.getLevel() <= this.getLevel() || ae.startSourceLine <= this.startSourceLine && (ae.startSourceLine != this.startSourceLine || ae.startSourceColumn < this.startSourceColumn) || ae.endSourceLine >= this.endSourceLine && (ae.endSourceLine != this.endSourceLine || ae.endSourceColumn > this.endSourceColumn)) {
            return;
        }
        if (ae.getLevel() == this.getLevel() + 1) {
            this.innerAnnotatedExpressionsList.add(ae);
        } else {
            for (AnnotatedExpression iae : this.innerAnnotatedExpressionsList) {
                if (ae.startSourceLine <= iae.startSourceLine && (ae.startSourceLine != iae.startSourceLine || ae.startSourceColumn < iae.startSourceColumn) || ae.endSourceLine >= iae.endSourceLine && (ae.endSourceLine != iae.endSourceLine || ae.endSourceColumn > iae.endSourceColumn)) continue;
                iae.addAnnotatedExpression(ae);
                break;
            }
        }
    }

    public byte[] getBytecode() {
        return this.bytecode;
    }

    public Annotation getAnnotation() {
        return this.annotation;
    }

    public String getSourceCode() throws SourceNotAvailableException, InvalidReferenceException {
        if (this.isSourceCodeChanged) {
            throw new InvalidReferenceException(this.classNameWithPath, this.sourceFile, this.InvalidReferenceExceptionLine + 1, this.InvalidReferenceExceptionColumn + 1);
        }
        if (this.isInvalidReferenceExceptionAppens) {
            throw new InvalidReferenceException(this.classNameWithPath, this.sourceFile, this.InvalidReferenceExceptionLine + 1, this.InvalidReferenceExceptionColumn + 1);
        }
        if (!this.isSourceCodeAvailable) {
            throw new SourceNotAvailableException(this.classNameWithPath);
        }
        return this.source;
    }

    public String getBodySourceCode() throws SourceNotAvailableException, InvalidReferenceException {
        if (this.isSourceCodeChanged) {
            throw new InvalidReferenceException(this.classNameWithPath, this.sourceFile, this.InvalidReferenceExceptionLine + 1, this.InvalidReferenceExceptionColumn + 1);
        }
        if (this.isInvalidReferenceExceptionAppens) {
            throw new InvalidReferenceException(this.classNameWithPath, this.sourceFile, this.InvalidReferenceExceptionLine + 1, this.InvalidReferenceExceptionColumn + 1);
        }
        if (!this.isSourceCodeAvailable) {
            throw new SourceNotAvailableException(this.classNameWithPath);
        }
        if (this.startBodySourceIndex > -1 && this.endBodySourceIndex > -1) {
            return this.source.substring(this.startBodySourceIndex - this.startSourceIndex, this.endBodySourceIndex - this.startSourceIndex);
        }
        return this.source;
    }

    public int getLevel() {
        return this.level;
    }

    public String getAnnotationType() {
        return this.annotType;
    }

    public String toString() {
        String result = "ANNOTATED EXPRESSION - ";
        result = String.valueOf(result) + "level: " + this.level + ", startSource: (" + this.startSourceLine + ", " + this.startSourceColumn + "), endSource: (" + this.endSourceLine + ", " + this.endSourceColumn + "), startPc: " + this.startPc + ", endPc: " + this.endPc + ", " + this.annotation + "\n";
        return result.substring(0, result.length() - 1);
    }

    public String toStringWithInnerAnnotatedExpression() {
        String result = "";
        int i = 0;
        while (i < this.getLevel()) {
            result = String.valueOf(result) + "  ";
            ++i;
        }
        result = String.valueOf(result) + "ANNOTATED EXPRESSION - ";
        result = String.valueOf(result) + "level: " + this.getLevel() + ", startSource: (" + this.startSourceLine + ", " + this.startSourceColumn + "), endSource: (" + this.endSourceLine + ", " + this.endSourceColumn + "), startPc: " + this.startPc + ", endPc: " + this.endPc + ", " + this.annotation + "\n";
        for (AnnotatedExpression iab : this.innerAnnotatedExpressionsList) {
            result = String.valueOf(result) + iab.toStringWithInnerAnnotatedExpression() + "\n";
        }
        return result.substring(0, result.length() - 1);
    }

    public String toBinBytecodeString() {
        return new BytecodeUtility(this.bytecode, this.startPc).toBinBytecodeString();
    }

    public String toIntBytecodeString() {
        return new BytecodeUtility(this.bytecode, this.startPc).toIntBytecodeString();
    }

    public String toHexBytecodeString() {
        return new BytecodeUtility(this.bytecode, this.startPc).toHexBytecodeString();
    }

    public String toSymBytecodeString() {
        return new BytecodeUtility(this.bytecode, this.startPc).toSymBytecodeString();
    }

    private int searchIndexOfPosition(String text, int line, int column) {
        --line;
        --column;
        int c = 0;
        if (text.charAt(0) == '\n') {
            --line;
        }
        int i = 0;
        while (i < line) {
            if (text.indexOf("\n", c + 1) < 0) {
                this.isInvalidReferenceExceptionAppens = true;
                this.InvalidReferenceExceptionLine = line + 1;
                this.InvalidReferenceExceptionColumn = column + 1;
                return -1;
            }
            c = text.indexOf("\n", c + 1);
            ++i;
        }
        ++c;
        int extraTabSpace = 0;
        int i2 = 0;
        while (i2 < column - extraTabSpace) {
            try {
                if (text.charAt(c + i2) == '\t') {
                    extraTabSpace += 7 - (extraTabSpace + i2) % 8;
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                this.isInvalidReferenceExceptionAppens = true;
                this.InvalidReferenceExceptionLine = line + 1;
                this.InvalidReferenceExceptionColumn = column + 1;
                return -1;
            }
            ++i2;
        }
        int indexToReturn = c + column - extraTabSpace;
        try {
            text.charAt(indexToReturn);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.isInvalidReferenceExceptionAppens = true;
            this.InvalidReferenceExceptionLine = line + 1;
            this.InvalidReferenceExceptionColumn = column + 1;
            return -1;
        }
        return indexToReturn;
    }

    private int getStartBodySourceIndex() {
        int numberUnclosedRoundBrackets = 0;
        int i = 0;
        while (i < this.source.length()) {
            switch (this.source.charAt(i)) {
                case '(': {
                    ++numberUnclosedRoundBrackets;
                    break;
                }
                case ')': {
                    --numberUnclosedRoundBrackets;
                    break;
                }
                case '{': {
                    if (numberUnclosedRoundBrackets != 0) break;
                    return this.startSourceIndex + i + 1;
                }
            }
            ++i;
        }
        return -1;
    }

    private int getEndBodySourceIndex() {
        int i = this.source.length() - 1;
        while (i >= 0) {
            if (this.source.charAt(i) == '}') {
                return this.startSourceIndex + i;
            }
            --i;
        }
        return -1;
    }
}

