﻿module SeqAndAsyncMonads


//////////////////////
// primes seq
//////////////////////
let N = Seq.initInfinite id
//  let rec N_from v =
//    seq{ 
//      yield v
//      yield! (N_from (v+1))
//    }
//  in N_from 0

let factors x =
  seq{for i in 1..x do if x % i = 0 then yield i}

let primes =
  seq{for x in N do if factors x |> Seq.length = 2 then yield x}


//////////////////////
// seq unfold
//////////////////////
let fibo = (0,1) |> Seq.unfold (fun (prev,curr) -> let next = curr+prev in Some(curr,(curr,next)))


//////////////////////
// complex seq
//////////////////////
let rec fibo'() =
    seq{
        yield 1
        yield 1
        yield! Seq.zip (fibo'()) (Seq.skip 1 (fibo'())) |> Seq.map (fun (a,b) -> a + b)
    }
    


//////////////////////
// async and let!
//////////////////////
open System.Net
open Microsoft.FSharp.Control.WebExtensions

let urlList = [ "Microsoft.com", "http://www.microsoft.com/"
                "MSDN", "http://msdn.microsoft.com/"
                "Bing", "http://www.bing.com"
              ]

let fetchAsync(name, url:string) =
    async { 
        try
            let uri = new System.Uri(url)
            let webClient = new WebClient()
            let! html = webClient.AsyncDownloadString(uri)
            printfn "Read %d characters for %s" html.Length name
        with
            | ex -> printfn "%s" (ex.Message);
    }

let runAll() =
    urlList
    |> Seq.map fetchAsync
    |> Async.Parallel 
    |> Async.RunSynchronously
    |> ignore

runAll()

