﻿module ListSeqSetMapHOFs


//////////////////////
// map
//////////////////////
let rec incr_all_by v l =
  match l with
  | [] -> []
  | x::xs -> (x+v)::incr_all_by v xs

let rec mul_all_by f l =
  match l with
  | [] -> []
  | x::xs -> (x*f)::mul_all_by f xs

let rec _map f l =
  match l with
  | [] -> []
  | x::xs -> f x :: _map f xs

let incr_all_by' v l = _map (fun x -> x + v) l
let incr_all_by'' v l = _map ((+) v) l

let incr_all_by''' v l = List.map ((+) v) l

let l = [1..1000]
let l' = l |> List.map (fun x -> x * x)
let evens = l |> List.filter (fun x -> x % 2 = 0)
let sum = l |> List.fold (fun sum x -> sum + x) 0
let odds = l |> List.filter (fun x -> x % 2 = 1)
let even_odds = List.zip evens odds
let exists = even_odds |> List.exists (fun (x,y) -> (x + y) % 175 = 0)
let (x,y) = even_odds |> List.find (fun (x,y) -> (x + y) % 175 = 0)
let rs = 
  let rand = new System.Random()
  in [for i in 1..1000 do yield rand.Next()] |> List.sort




//////////////////////
// Set
//////////////////////
let e = Set.empty
let s1 = Set.empty.Add(1).Add(2).Add(7)
let s2 = Set.ofList ["Mercury"; "Venus"; "Earth"; "Mars"; "Jupiter"; "Saturn"; "Uranus"; "Neptune"]

let a = Set.ofSeq [ 1 .. 10 ]
let b = Set.ofSeq [ 5 .. 15 ]

let c = a + b
let d = b - a

open System
let shakespeare = "O Romeo, Romeo! wherefore art thou Romeo?"
let shakespeareSet = shakespeare.Split([| ' '; ','; '!'; '?' |], StringSplitOptions.RemoveEmptyEntries) |> Set.ofSeq



//////////////////////
// map
//////////////////////
let capitals =
    [("Australia", "Canberra"); ("Canada", "Ottawa"); ("China", "Beijing");
        ("Denmark", "Copenhagen"); ("Egypt", "Cairo"); ("Finland", "Helsinki");
        ("France", "Paris"); ("Germany", "Berlin"); ("India", "New Delhi");
        ("Japan", "Tokyo"); ("Mexico", "Mexico City"); ("Russia", "Moscow");
        ("Slovenia", "Ljubljana"); ("Spain", "Madrid"); ("Sweden", "Stockholm");
        ("Taiwan", "Taipei"); ("USA", "Washington D.C."); ("Italy", "Rome")]
    |> Map.ofList
 
let rec capitals_main() =
    Console.Write("Find a capital by country (type 'q' to quit): ")
    match Console.ReadLine() with
    | "q" -> Console.WriteLine("Bye bye")
    | country ->
        match capitals |> Map.tryFind country with
        | Some(capital) -> Console.WriteLine("The capital of {0} is {1}\n", country, capital)
        | None -> Console.WriteLine("Country not found.\n")
        capitals_main() (* loop again *)
 


//////////////////////
// map of custom data
//////////////////////
type Point = { X : float; Y : float }
let points = 
  let r = new Random()
  in Set.ofSeq (seq{for i in 0..1000 do yield {X = r.NextDouble(); Y = r.NextDouble() } } )

let territories = 
  Map.ofList [({X = 0.0; Y = 0.0}, "Kamchatka"); ({ X = 1.0; Y = 0.0 }, "Japan") (* ... *) ]

