﻿module LetFunList

//////////////////////
// let
//////////////////////
let x = 0
let y = 10
let a,b,c = x+y, "hello world", (Set.empty : Set<int>)

let l = [1..10]
let l' = [for x in 1..10 do yield x * x]
let l'' = [1..2..10]

let arr = [|1..10|]

let s = seq{1..10}


//////////////////////
// functions
//////////////////////
let f x = x + 10

let add x y = x + y
let add3 x = add 3 x
let add3' = add 3

let square x = x * x
let toString x = x.ToString()


let id x = x
let apply2 f x y = f x y


//////////////////////
// lambdas and HOFs
//////////////////////
let sqr = fun x -> x * x

let rec integrate f l u h = 
  if l >= u then 0.0
  else (f l) * h + integrate f (l+h) u h

let I = integrate sqr 1.0 3.0 1.0
let I' = integrate cos 0.0 1.0 0.01 // sin(1.0)
let I'' = integrate (fun x -> x * x + 2.0) 0.0 1.0 0.1

open System
let duration f = 
    let startTime = DateTime.Now;
    let returnValue = f()
    let endTime = DateTime.Now;
    printfn "Duration (ms): %f" (endTime - startTime).TotalMilliseconds
    returnValue
 
let rec fib = function
    | 0 -> 0
    | 1 -> 1
    | n -> fib (n - 1) + fib (n - 2)


//////////////////////
// composition
//////////////////////
let complexFunction x =
    toString (add 5 (square x))

let (|>) x f = f x
let complexFunction' x =
    x |> square |> add 5 |> toString

let (>>) f g x = g(f(x))
let line b c = ((*) b) >> ((+) c)


//////////////////////
// units of measure
//////////////////////
[<Measure>]
type m

[<Measure>]
type s

let g = 9.81<m/s^2>

let step (p:float<m>) (v:float<m/s>) (dt:float<s>) =
  (p + v * dt, v + g * dt)

let p,v = step 0.0<m> 10.0<m/s> 0.01<s>