﻿module DotNetInterop



//////////////////////
// XNA game
//////////////////////
open System
open System.Collections.Generic
open System.Linq
open Microsoft.Xna.Framework
open Microsoft.Xna.Framework.Audio
open Microsoft.Xna.Framework.Content
open Microsoft.Xna.Framework.GamerServices
open Microsoft.Xna.Framework.Graphics
open Microsoft.Xna.Framework.Input
open Microsoft.Xna.Framework.Media

type SpriteBatch with
  member this.Draw(t:Texture2D, c:Vector2) =
    let s = Vector2(t.Width |> float32, t.Height |> float32)
    this.Draw(t, c - s * 0.5f, Color.White)

type GameTime with
  member this.dt with get() = this.ElapsedGameTime.TotalSeconds |> float32

type Game() as this =
  inherit Microsoft.Xna.Framework.Game()

  let graphics = new GraphicsDeviceManager(this)
  do graphics.PreferredBackBufferWidth <- 800
  do graphics.PreferredBackBufferHeight <- 480

  do this.Content.RootDirectory <- "Content"

  let mutable plasma_positions = ResizeArray(100)
  let mutable ship_position = Vector2(400.0f,240.0f)
  let mutable ship : Texture2D = null
  let mutable plasma : Texture2D = null
  let mutable font : SpriteFont = null
  let mutable sprite_batch : SpriteBatch = null

  let mutable prev_kb = KeyboardState()

  override this.Initialize() =
    sprite_batch <- new SpriteBatch(this.GraphicsDevice)
    do base.Initialize()

  override this.LoadContent() =
    font <- this.Content.Load "font"
    ship <- this.Content.Load "ship"
    plasma <- this.Content.Load "plasma_small"

  override this.Update(gt) =
    let dt = gt.ElapsedGameTime.TotalSeconds |> float32
    let kb = Keyboard.GetState()
      
    ship_position <- ship_position +
      ((if kb.IsKeyDown(Keys.Up) then     -Vector2.UnitY * dt else Vector2.Zero) +
       (if kb.IsKeyDown(Keys.Down) then  Vector2.UnitY * dt else Vector2.Zero) +
       (if kb.IsKeyDown(Keys.Left) then -Vector2.UnitX * dt else Vector2.Zero) +
       (if kb.IsKeyDown(Keys.Right) then Vector2.UnitX * dt else Vector2.Zero)) * 200.0f

    if kb.IsKeyDown(Keys.Space) && prev_kb.IsKeyUp(Keys.Space) then
      plasma_positions.Add ship_position

    let plasma_positions' = 
      seq{
        for p in plasma_positions do
          yield p - Vector2.UnitY * dt * 300.0f
      }
    plasma_positions <- ResizeArray(plasma_positions')

    base.Update(gt)
    prev_kb <- kb

  override this.Draw(gt) =
    do this.GraphicsDevice.Clear Color.Black

    sprite_batch.Begin()
    for p in plasma_positions do
      sprite_batch.Draw(plasma, p)
    sprite_batch.Draw(ship, ship_position)
    sprite_batch.End()

    do base.Draw(gt)