﻿module ImperativeProgramming

let mutable count = 0
let incr () = count <- count + 1

let count' = ref 0
let incr' () = count' := !count' + 1

for i = 0 to 10 do
  incr()
  incr'()
  printf "%d, %d\n" count !count'

let fact n =
  let mutable v = 1
  for i = 1 to n do
    v <- v * i
  v
