﻿module Monads

let fail = None

type MaybeBuilder() =
  member b.ReturnFrom(p)  = p
  member b.Return(x)  = Some x
  member b.Bind(p, k) =
    match p with
    | None -> fail
    | Some r -> k r
  member b.Delay(f) : option<'a> = f()

let maybe = MaybeBuilder()

let (!) n = maybe {if n > 1000 then return! fail else return n}

let safesum inp1 inp2 =
    maybe { let! n1 = !inp1
            let! n2 = !inp2
            let sum = n1 + n2
            return sum }

let (!!) op x y = 
  maybe {
    let! x = !x
    let! y = !y
    return op x y
  }

let safesum' inp1 inp2 =
    maybe { let! sum = !! (+) inp1 inp2
            return sum }




type ListMonad() =
   member this.Bind((m:'a list), (f: 'a -> 'b list)) = List.concat( List.map (fun x -> f x) m )
   member this.Return(x) = [x]
   member this.Zero() = []

let list = ListMonad()

let cartesian = 
  list { 
    let! x = [1..5]
    let! y = [1..5]
    if x > y then
      return (x,y)
  }



type State<'s, 'a> = 's ->'a * 's
type StateMonad() =         
  member this.Bind(p : State<'s,'a>, k : 'a -> State<'s,'b>) : State<'s,'b> = 
    fun s ->
      let res,s' = p s
      in k res s'
  member this.Return(x) : State<'s,'a> = fun s -> x,s      
       
let state = StateMonad()
let run p s = p s

let get_x = fun s -> fst s,s
let set_x x' = fun (x,y) -> (),(x',y)
let get_y = fun s -> snd s,s
let set_y y' = fun (x,y) -> (),(x,y')

let mul = 
  state{
    let! x = get_x
    let! y = get_y
    do! set_y (x*y)
  }