﻿module FSharpTypes

open System

//////////////////////
// tuples, aliases
//////////////////////
type Vector3 = float * float * float



//////////////////////
// record
//////////////////////
type Person = {Name:string; Surname:string; BirthDate:DateTime}
let make_joe() = {Name="Joe"; Surname="Smith"; BirthDate = DateTime(1985,3,2)}
let is_joe p =
  match p with
  | {Name="Joe"; Surname = y; BirthDate = z} -> true
  | _ -> false
let change_to_john p = {p with Name = "John"}



//////////////////////
// disc. unions
//////////////////////
type Vector2 = Vector2 of float * float with
  static member (+) (Vector2(x1,y1), Vector2(x2,y2)) = Vector2(x1+x2,y1+y2)
  static member (-) (Vector2(x1,y1), Vector2(x2,y2)) = Vector2(x1-x2,y1-y2)
  static member (*) (Vector2(x,y), f) = Vector2(x * f,y * f)
  static member (*) (f, Vector2(x,y)) = Vector2(x * f,y * f)
  static member (/) (Vector2(x,y), f) = Vector2(x / f,y / f)
  static member (/) (f, Vector2(x,y)) = Vector2(f / x,f / y)
  static member (~-) (Vector2(x,y)) = Vector2(-x,-y)

let v1 = Vector2(10.0,10.0)
let v2 = Vector2(20.0,20.0)


type IntList = Cons of int * IntList | Empty
let rec sum l =
  match l with
  | Empty -> 0
  | Cons(x,xs) -> x + sum xs

let rec sum' =
  function
  | Empty -> 0
  | Cons(x,xs) -> x + sum xs

type BinTree<'a when 'a : comparison> = Node of 'a * 'a BinTree * 'a BinTree | Leaf
let rec insert x t =
  match t with
  | Leaf -> Node(x,Leaf,Leaf)
  | Node(y,l,r) when x > y -> Node(y,l,r |> insert x)
  | Node(y,l,r) -> Node(y,l |> insert x,r)
let rec find x t =
  match t with
  | Leaf -> false
  | Node(y,l,r) when x > y -> find x r
  | Node(y,l,r) when x < y -> find x l
  | Node(y,l,r) -> true

type Expr = Const of int | Sum of Expr * Expr | Diff of Expr * Expr | Mul of Expr * Expr | Div of Expr * Expr
let (!) x = Const x
let (.+) x y = Sum(x,y)
let (.-) x y = Diff(x,y)
let (.*) x y = Mul(x,y)
let (./) x y = Div(x,y)

let rec eval =
  function 
  | Const i -> i
  | Sum(x,y) -> eval x + eval y
  | Diff(x,y) -> eval x - eval y
  | Mul(x,y) -> eval x * eval y
  | Div(x,y) -> eval x / eval y
