﻿module ActivePatterns


//////////////////////
// complete patterns
//////////////////////
let (|Even|Odd|) input = if input % 2 = 0 then Even else Odd

let (|Factors|) n = [for i = 1 to n do if n % i = 0 then yield i]

let (|Prime|NotPrime|) n = 
  match n with
  | Factors([1; n]) -> Prime
  | _ -> NotPrime

let primes_to n = 
  for i = 2 to n do
    match i with
    | Prime -> printf "%d\n" i
    | NotPrime -> ()



//////////////////////
// incomplete
//////////////////////
type expr = Const of int | Mul of expr * expr | Sum of expr * expr

let (|Char|_|) p s = 
  match s with
  | (c:char)::cs when p c -> Some(c,cs)
  | _ -> None

let rec (|ZeroOrMore|_|) p s =
  match s with
  | Char p (c,ZeroOrMore p (cs,s)) when p c -> Some(c::cs,s)
  | _ -> Some([],s)

let rec (|OneOrMore|_|) p s =
  match s with
  | Char p (c,ZeroOrMore p (cs,s)) when p c -> Some(c::cs,s)
  | _ -> None

let (|Integer|_|) s =
  match s with
  | OneOrMore (System.Char.IsDigit) (cs,s) -> Some(new string(cs |> Seq.toArray) |> int,s)
  | _ -> None

let (|Blank|_|) =
  function
  | OneOrMore (System.Char.IsSeparator) (cs,s) -> Some(s)
  | _ -> None

let (|LParens|_|) =
  function
  | Char ((=) '(') (_,cs) -> Some(cs)
  | _ -> None

let (|RParens|_|) =
  function
  | Char ((=) ')') (_,cs) -> Some(cs)
  | _ -> None

let (|Plus|_|) = 
  function
  | Char ((=) '+') (_,cs) -> Some(cs)
  | _ -> None

let (|Times|_|) = 
  function
  | Char ((=) 'x') (_,cs) -> Some(cs)
  | _ -> None

let (|SomeExprs|_|) = 
  function
  | Integer(i,Plus(Integer(i',s))) -> Some(Sum(Const(i),Const(i')))
  | LParens(Integer(i,Plus(Integer(i',RParens(s))))) -> Some(Sum(Const(i),Const(i')))
  | Integer(i,Times(Integer(i',s))) -> Some(Mul(Const(i),Const(i')))
  | LParens(Integer(i,Times(Integer(i',RParens(s))))) -> Some(Mul(Const(i),Const(i')))
  | Integer(i,s) -> Some(Const(i))
  | _ -> None
